/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Status;
import ix.icore.Variable;
import ix.icore.plan.Plan;
import ix.ip2.ActionUnreadyReason;
import ix.ip2.ActivityHandler;
import ix.ip2.AgendaItem;
import ix.ip2.HandlerAction;
import ix.ip2.Ip2;
import ix.ip2.UnboundVariablesUnreadyReason;
import ix.util.Strings;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.xml.XML;
import java.util.List;

public class LoadPlanHandler
extends ActivityHandler {
    public static final Symbol S_LOAD_PLAN = Symbol.intern("load-plan");
    protected Ip2 ip2;
    Symbol verb;

    public LoadPlanHandler(Ip2 ip2) {
        this(ip2, "load-plan");
    }

    public LoadPlanHandler(Ip2 ip2, String string) {
        super(Strings.capitalize(Strings.replace("-", " ", string)));
        this.ip2 = ip2;
        this.verb = Symbol.intern(string);
    }

    public List getSyntaxList() {
        return (LList)Lisp.readFromString("((" + this.verb + " ?plan))");
    }

    public boolean appliesTo(AgendaItem agendaItem) {
        LList lList = agendaItem.getPattern();
        return lList.length() == 2 && lList.get(0) == this.verb;
    }

    public void addHandlerActions(AgendaItem agendaItem) {
        agendaItem.addAction(new LoadPlanAction(agendaItem));
        agendaItem.addAction(new ReplacePlanAction(agendaItem));
    }

    class ReplacePlanAction
    extends LoadPlanAction {
        ReplacePlanAction(AgendaItem agendaItem) {
            super(agendaItem, "Replace plan, keeping state");
        }

        public void handle(AgendaItem agendaItem) {
            Plan plan = this.getSpecifiedPlan(agendaItem);
            LoadPlanHandler.this.ip2.resetViewers();
            LoadPlanHandler.this.ip2.clearAllButState();
            LoadPlanHandler.this.ip2.loadPlan(plan);
        }
    }

    class LoadPlanAction
    extends HandlerAction {
        AgendaItem item;

        LoadPlanAction(AgendaItem agendaItem) {
            this(agendaItem, "Load plan");
        }

        LoadPlanAction(AgendaItem agendaItem, String string) {
            this.item = agendaItem;
            this.shortDescription = string;
        }

        public boolean isReady() {
            return Variable.isFullyBound(this.item.getPattern());
        }

        public ActionUnreadyReason getUnreadyReason() {
            return new UnboundVariablesUnreadyReason((HandlerAction)this, this.item);
        }

        public void handle(AgendaItem agendaItem) {
            LoadPlanHandler.this.ip2.loadPlan(this.getSpecifiedPlan(agendaItem));
            agendaItem.setStatus(Status.COMPLETE);
        }

        Plan getSpecifiedPlan(AgendaItem agendaItem) {
            LList lList = (LList)Variable.removeVars(agendaItem.getPattern());
            Object object = lList.get(1);
            if (object instanceof Plan) {
                return (Plan)object;
            }
            if (object instanceof Symbol || object instanceof String) {
                return XML.readObject(Plan.class, object.toString());
            }
            throw new IllegalArgumentException(object + " is not a valid reference to a plan");
        }
    }
}

