/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.domain.ListOfObjectProperty;
import ix.icore.domain.ObjectProperty;
import ix.util.Debug;
import ix.util.Function1;
import ix.util.ObjectComparator;
import ix.util.Strings;
import ix.util.UniqueObject;
import ix.util.Util;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ObjectView {
    protected static final Symbol TYPE = Symbol.intern("type");
    protected static final Object NO_VALUE = new UniqueObject("NO_VALUE");
    protected String name;
    protected String objectHeader;
    protected List objects;
    protected List types;
    protected ListOfObjectProperty properties;
    protected ValueParser parser = this.makeValueParser();

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getObjectHeader() {
        return this.objectHeader;
    }

    public String getObjectHeader(String string) {
        return this.objectHeader != null ? this.objectHeader : string;
    }

    public void setObjectHeader(String string) {
        this.objectHeader = string;
    }

    public List getObjects() {
        return this.objects;
    }

    public void setObjects(List list) {
        this.objects = list;
    }

    public void addObject(Object object) {
        if (this.objects == null) {
            this.objects = new LinkedList();
        } else if (this.objects instanceof LList) {
            this.objects = new LinkedList(this.objects);
        }
        this.objects.add(object);
    }

    public List getTypes() {
        return this.types;
    }

    public void setTypes(List list) {
        this.types = list;
    }

    public ListOfObjectProperty getProperties() {
        return this.properties;
    }

    public void setProperties(ListOfObjectProperty listOfObjectProperty) {
        this.properties = listOfObjectProperty;
    }

    public SortedSet getInitialObjects(Map map, Function1 function1) {
        TreeSet treeSet = new TreeSet(new ObjectComparator());
        if (this.objects != null) {
            treeSet.addAll(this.objects);
        }
        treeSet.addAll(this.getNewObjects(map, treeSet, function1));
        return treeSet;
    }

    public SortedSet getNewObjects(Map map, Set set, Function1 function1) {
        TreeSet<Object> treeSet = new TreeSet<Object>(new ObjectComparator());
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Map.Entry entry : map.entrySet()) {
            Object object;
            LList lList = (LList)entry.getKey();
            if (lList.cdr() == Lisp.NIL || !((object = lList.get(1)) instanceof Symbol) && !(object instanceof String) || set.contains(object) || hashSet.contains(object)) continue;
            if (this.isRelevantObject(object, function1)) {
                treeSet.add(object);
                continue;
            }
            hashSet.add(object);
        }
        return treeSet;
    }

    public boolean isRelevantObject(Object object, Function1 function1) {
        Cons cons = Lisp.list(TYPE, object);
        Object object2 = function1.funcall(cons);
        return this.types != null && this.types.contains(object2);
    }

    protected ValueParser makeValueParser() {
        return new ValueParser();
    }

    public Object read(ObjectProperty objectProperty, String string, Object object) {
        return this.parser.read(objectProperty, string, object);
    }

    public String write(ObjectProperty objectProperty, Object object) {
        return this.parser.write(objectProperty, object);
    }

    public static class ValueParser {
        public Object read(ObjectProperty objectProperty, String string, Object object) {
            Debug.noteln("read " + objectProperty, (Object)Strings.quote(string));
            if (string.equals("")) {
                return this.readEmptyValue(objectProperty, object);
            }
            ObjectProperty.Syntax syntax = objectProperty.getDefaultedSyntax();
            if (syntax == ObjectProperty.Syntax.NUMBER) {
                return Util.mustBe(Number.class, Lisp.readFromString(string));
            }
            if (syntax == ObjectProperty.Syntax.SYMBOL) {
                return Symbol.intern(string);
            }
            if (syntax == ObjectProperty.Syntax.STRING) {
                return string;
            }
            if (syntax == ObjectProperty.Syntax.LIST) {
                return Lisp.elementsFromString(string);
            }
            if (syntax == ObjectProperty.Syntax.OBJECT) {
                return Lisp.readFromString(string);
            }
            return Lisp.readFromString(string);
        }

        public Object readEmptyValue(ObjectProperty objectProperty, Object object) {
            ObjectProperty.Syntax syntax = objectProperty.getDefaultedSyntax();
            if (syntax == ObjectProperty.Syntax.NUMBER) {
                return NO_VALUE;
            }
            if (syntax == ObjectProperty.Syntax.SYMBOL) {
                return NO_VALUE;
            }
            if (syntax == ObjectProperty.Syntax.STRING) {
                return object == NO_VALUE ? NO_VALUE : "";
            }
            if (syntax == ObjectProperty.Syntax.LIST) {
                return NO_VALUE;
            }
            if (syntax == ObjectProperty.Syntax.OBJECT) {
                return NO_VALUE;
            }
            return NO_VALUE;
        }

        public String write(ObjectProperty objectProperty, Object object) {
            Debug.noteln("write " + objectProperty, (Object)Lisp.printToString(object));
            Debug.expect(object != null, "Null object property value");
            if (object == NO_VALUE) {
                return "";
            }
            ObjectProperty.Syntax syntax = objectProperty.getDefaultedSyntax();
            if (syntax == ObjectProperty.Syntax.NUMBER) {
                return Lisp.printToString(object);
            }
            if (syntax == ObjectProperty.Syntax.SYMBOL) {
                return object.toString();
            }
            if (syntax == ObjectProperty.Syntax.STRING) {
                return object.toString();
            }
            if (syntax == ObjectProperty.Syntax.LIST) {
                return object instanceof LList ? Lisp.elementsToString((LList)object) : Lisp.printToString(object);
            }
            if (syntax == ObjectProperty.Syntax.OBJECT) {
                return Lisp.printToString(object);
            }
            return Lisp.printToString(object);
        }
    }
}

