/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.IXAgent;
import ix.icore.Status;
import ix.icore.Variable;
import ix.ip2.ActivityHandler;
import ix.ip2.AgendaItem;
import ix.ip2.HandlerAction;
import ix.ispace.ContactManager;
import ix.ispace.VerbCapability;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.util.LinkedList;
import java.util.List;

public class SetCapabilitiesHandler
extends ActivityHandler {
    Symbol S_SET_CAPABILITIES = Symbol.intern("set-capabilities");
    IXAgent agent;

    public SetCapabilitiesHandler(IXAgent iXAgent) {
        super("Set agent capabilities");
        this.agent = iXAgent;
    }

    public List getSyntaxList() {
        return (LList)Lisp.readFromString("((set-capabilities ?agent-name (?verb ...)))");
    }

    public boolean appliesTo(AgendaItem agendaItem) {
        LList lList = agendaItem.getPattern();
        return lList.length() == 3 && lList.get(0) == this.S_SET_CAPABILITIES;
    }

    public void addHandlerActions(AgendaItem agendaItem) {
        agendaItem.addAction(new HandlerAction.AutomaticWhenBound(agendaItem, this));
    }

    public void handle(AgendaItem agendaItem) {
        LList lList = (LList)Variable.removeVars(agendaItem.getPattern());
        String string = lList.get(1).toString();
        List list = (List)lList.get(2);
        List list2 = this.makeVerbCapabilities(list);
        ContactManager contactManager = this.agent.getContactManager();
        contactManager.noteAgent(string);
        contactManager.setCapabilities(string, list2);
        agendaItem.setStatus(Status.COMPLETE);
    }

    List makeVerbCapabilities(List list) {
        LinkedList<VerbCapability> linkedList = new LinkedList<VerbCapability>();
        for (Object e : list) {
            if (!(e instanceof String) && !(e instanceof Symbol)) {
                throw new IllegalArgumentException("Invalid verb " + e);
            }
            linkedList.add(VerbCapability.from(e.toString()));
        }
        return linkedList;
    }
}

