/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.ConstraintManager;
import ix.icore.ConstraintManagerRegistry;
import ix.icore.Variable;
import ix.icore.domain.Constraint;
import ix.icore.domain.End;
import ix.icore.process.PNode;
import ix.icore.process.PNodeEnd;
import ix.ip2.Ip2ModelManager;
import ix.iplan.DomainAnalyser;
import ix.util.Debug;
import ix.util.FailureException;
import ix.util.context.ContextHashMap;
import ix.util.lisp.LList;
import ix.util.lisp.Symbol;

public class UseCM
implements ConstraintManager {
    private static final Symbol USE = Symbol.intern("use");
    ContextHashMap useTable = new ContextHashMap();
    ContextHashMap freeTable = new ContextHashMap();
    Ip2ModelManager mm;

    public UseCM(Ip2ModelManager ip2ModelManager) {
        this.mm = ip2ModelManager;
    }

    public void registerWith(ConstraintManagerRegistry constraintManagerRegistry) {
        constraintManagerRegistry.addConstraintManager(this, Symbol.intern("resource"), new Symbol[]{USE});
    }

    public void reset() {
        this.useTable.clearCompletely();
        this.freeTable.clearCompletely();
    }

    public void clear() {
        this.useTable.clear();
        this.freeTable.clear();
    }

    public void addConstraint(Constraint constraint) {
        throw new UnsupportedOperationException("Method addConstraint(Constraint) is not supported by this CM.");
    }

    public void addConstraint(PNode pNode, Constraint constraint) {
        Debug.noteln("Use CM adding", (Object)constraint);
        Debug.noteln("At", (Object)pNode);
    }

    public void evalAtBegin(PNodeEnd pNodeEnd, Constraint constraint) {
        Debug.noteln("Use CM eval " + constraint + " at " + pNodeEnd);
        Debug.expectSame(End.BEGIN, pNodeEnd.getEnd());
        constraint = (Constraint)Variable.removeAllVars(constraint);
        LList lList = constraint.getPattern();
        PNode pNode = (PNode)this.useTable.get(lList);
        if (pNode != null) {
            throw new FailureException(lList + " already in use at " + pNode);
        }
        this.useTable.put(lList, pNodeEnd.getNode());
        PNode pNode2 = (PNode)this.freeTable.get(lList);
        if (pNode2 != null) {
            this.mm.linkBefore(pNode2.getEnd(), pNodeEnd);
        }
    }

    public void evalAtEnd(PNodeEnd pNodeEnd, Constraint constraint) {
        Debug.noteln("Use CM eval " + constraint + " at " + pNodeEnd);
        Debug.expectSame(End.END, pNodeEnd.getEnd());
        constraint = (Constraint)Variable.removeAllVars(constraint);
        LList lList = constraint.getPattern();
        Debug.expectSame(pNodeEnd.getNode(), this.useTable.get(lList));
        this.useTable.put(lList, (Object)null);
        this.freeTable.put(lList, pNodeEnd.getNode());
    }

    public boolean mightInteract(Constraint constraint, Constraint constraint2) {
        return DomainAnalyser.match(constraint.getPattern(), constraint2.getPattern());
    }
}

