/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.Activity;
import ix.icore.domain.Domain;
import ix.icore.plan.Plan;
import ix.icore.plan.build.SimplePlanBuilder;
import ix.iplan.NoPlanException;
import ix.iplan.PlanCheckingSimulator;
import ix.iplan.PlanTest;
import ix.iplan.PlanTestDefaults;
import ix.iplan.PlanTestGroup;
import ix.iplan.Slip;
import ix.iplan.SlipStats;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.Strings;
import ix.util.StructuralEquality;
import ix.util.context.Context;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.xml.XML;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AutoTester {
    protected PrintStream traceOut = Debug.out;
    protected int numberOfTests = 0;
    protected int numberOfPlans = 0;
    protected List failedTests = null;
    protected SlipStats statSummary = null;
    protected PlanTestDefaults planTestDefaults = null;
    protected boolean planFromPlans = false;
    protected Map<String, PlanTestGroup> nameToTestGroup = new LinkedHashMap<String, PlanTestGroup>();

    public static void main(String[] stringArray) {
        Debug.off();
        Parameters.setIsInteractive(false);
        Parameters.processCommandLineArguments(stringArray);
        AutoTester autoTester = new AutoTester();
        autoTester.setPlanFromPlans(Parameters.getBoolean("plan-from-plans", false));
        String string = Parameters.getParameter("test-list", "test-domains/standard-tests.xml");
        List list = autoTester.readTestList(string);
        autoTester.runTestList(list);
    }

    void setPlanTestDefaults(PlanTestDefaults planTestDefaults) {
        this.planTestDefaults = planTestDefaults;
    }

    void setPlanFromPlans(boolean bl) {
        this.planFromPlans = bl;
    }

    void definePlanTestGroup(PlanTestGroup planTestGroup) {
        this.traceln("\nDefining", planTestGroup);
        this.nameToTestGroup.put(planTestGroup.getName(), planTestGroup);
    }

    PlanTestGroup getPlanTestGroup(String string) {
        return this.nameToTestGroup.get(string);
    }

    void runTestList(List list) {
        Debug.noteln("Tests", (Object)XML.objectToXMLString(list));
        this.failedTests = new LinkedList();
        this.statSummary = new SlipStats(null);
        this.planTestDefaults = null;
        this.numberOfTests = 0;
        this.numberOfPlans = 0;
        this.testLoop(list);
        if (this.failedTests.isEmpty()) {
            this.traceln("No failed tests.");
        } else {
            this.traceln(this.failedTests.size() + " failed tests:");
            for (PlanTest planTest : this.failedTests) {
                this.traceln(planTest.testDescription());
            }
        }
        this.traceln("");
        this.traceln("Statistics totals for " + this.numberOfTests + " tests" + " and " + this.numberOfPlans + " plans:");
        this.statSummary.report(this.traceOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testLoop(List list) {
        for (PlanTest planTest : list) {
            try {
                planTest.makeTestRunner(this).runTest();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(this.traceOut);
                this.testFailure(planTest, Debug.describeException(throwable));
            }
            finally {
                Context.clearContexts();
            }
            this.traceln("");
        }
    }

    void recordFailure(PlanTest planTest) {
        if (!this.failedTests.contains(planTest)) {
            this.failedTests.add(planTest);
        }
    }

    public void trace(String string) {
        this.traceOut.print(string);
    }

    public void traceln(String string) {
        this.traceOut.println(string);
    }

    public void traceln(String string, Object object) {
        this.traceOut.println(string + " " + object);
    }

    public void testFailure(PlanTest planTest, String string) {
        this.recordFailure(planTest);
        this.traceln("Test failure because", string);
    }

    List readTestList(String string) {
        Debug.noteln("Loading a test list from", (Object)string);
        try {
            return XML.readObject(List.class, string);
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw new RethrownException(exception, "Cannot get a test list from " + Strings.quote(string) + ": " + Debug.describeException(exception));
        }
    }

    Slip makeTestPlanner(PlanTest planTest) {
        Slip slip = new Slip(false);
        slip.mainStartup(new String[0]);
        if (planTest.getStepLimit() > 0) {
            slip.setStepLimit(planTest.getStepLimit());
        }
        return slip;
    }

    String fullDomainName(PlanTest planTest) {
        String string = planTest.getDomain();
        String string2 = Strings.afterLast(".", string);
        return "test-domains/" + (string.equals(string2) ? string + ".lsp" : string);
    }

    public class TestRunner {
        PlanTest test;
        int planNumber;
        int remainingReplans;
        Map changedState;

        public TestRunner(PlanTest planTest) {
            this.test = planTest;
        }

        public void runTest() {
            if (AutoTester.this.planTestDefaults != null) {
                this.test.takeDefaults(AutoTester.this.planTestDefaults);
            }
            this.describeTest();
            ++AutoTester.this.numberOfTests;
            Slip slip = AutoTester.this.makeTestPlanner(this.test);
            Domain domain = this.readDomain();
            Plan plan = this.initialPlan();
            Plan plan2 = this.taskPlan();
            if (plan == null && plan2 == null) {
                throw new IllegalArgumentException("No task or initial plan specified in test " + XML.objectToXMLString(this.test));
            }
            slip.setDomain(domain);
            if (plan != null) {
                slip.loadPlan(plan);
            }
            if (plan2 != null) {
                slip.loadPlan(plan2);
            }
            this.remainingReplans = this.test.getIsExhaustive() ? this.test.getPlans() : this.test.getPlans() - 1;
            this.planNumber = 1;
            try {
                slip.plan();
                this.havePlan(slip);
                while (!this.testFinished()) {
                    ++this.planNumber;
                    --this.remainingReplans;
                    slip.replan();
                    this.havePlan(slip);
                }
            }
            catch (NoPlanException noPlanException) {
                this.checkNoPlan();
            }
        }

        private boolean testFinished() {
            if (this.remainingReplans > 0) {
                return false;
            }
            if (this.remainingReplans == 0) {
                if (this.test.getIsExhaustive()) {
                    AutoTester.this.testFailure(this.test, "too many solutions");
                }
                return true;
            }
            throw new ConsistencyException("remainingReplans < 0");
        }

        private void havePlan(Slip slip) {
            ++AutoTester.this.numberOfPlans;
            this.describePlan(slip);
            AutoTester.this.statSummary.addStats(slip.getStatistics());
            this.savePlan(slip);
            this.checkPlan(slip);
            if (this.changedState != null) {
                this.saveChangedState(this.changedState);
            }
            if (AutoTester.this.planFromPlans) {
                this.planFromPlan(slip);
            }
        }

        private void checkNoPlan() {
            if (this.remainingReplans == 0 && this.test.getIsExhaustive()) {
                AutoTester.this.traceln("No more plans, but that's ok");
            } else {
                AutoTester.this.testFailure(this.test, "missing solution");
            }
        }

        protected void describeTest() {
            AutoTester.this.traceln(this.test.testDescription());
        }

        protected void describePlan(Slip slip) {
            AutoTester.this.traceln("Plan " + this.planNumber);
            slip.getStatistics().report(AutoTester.this.traceOut);
        }

        protected void savePlan(Slip slip) {
            Plan plan = slip.getPlan();
            String string = "test-results/" + this.savedPlanName();
            XML.writeObject(plan, string);
        }

        protected String savedPlanName() {
            return this.test.getDomain() + "-" + Strings.replace(" ", "-", this.test.taskDescription()) + "-plan-" + this.planNumber + ".xml";
        }

        protected void saveChangedState(Map map) {
            Plan plan = new Plan();
            plan.setWorldState(map);
            String string = "test-results/" + this.savedChangedStateName();
            XML.writeObject(plan, string);
        }

        protected String savedChangedStateName() {
            return this.test.getDomain() + "-" + Strings.replace(" ", "-", this.test.taskDescription()) + "-changed-" + this.planNumber + ".init";
        }

        protected Domain readDomain() {
            return XML.readObject(Domain.class, AutoTester.this.fullDomainName(this.test));
        }

        protected Plan initialPlan() {
            String string = this.test.getInitialPlan();
            if (string != null) {
                string = "test-domains/" + string;
                return XML.readObject(Plan.class, string);
            }
            return null;
        }

        protected Plan taskPlan() {
            String string = this.test.getTask();
            if (string != null) {
                SimplePlanBuilder simplePlanBuilder = new SimplePlanBuilder();
                LList lList = Lisp.elementsFromString(string);
                simplePlanBuilder.addActivity(new Activity(lList));
                return simplePlanBuilder.getPlan();
            }
            return null;
        }

        protected void checkPlan(Slip slip) {
            PlanCheckingSimulator planCheckingSimulator = new PlanCheckingSimulator(slip);
            planCheckingSimulator.setTrace(false);
            AutoTester.this.trace("Simulated execution: ");
            this.changedState = this.runSimulation(planCheckingSimulator);
            int n = this.test.getRandomSimulations();
            if (n > 0) {
                planCheckingSimulator.setShuffle(true);
                for (int i = 1; i <= n; ++i) {
                    AutoTester.this.trace("Permutation test " + i + ": ");
                    Map map = this.runSimulation(planCheckingSimulator);
                    if (((Object)map).equals(this.changedState)) continue;
                    AutoTester.this.trace("Different final state.");
                }
            }
        }

        protected Map runSimulation(PlanCheckingSimulator planCheckingSimulator) {
            planCheckingSimulator.run();
            if (Debug.on) {
                planCheckingSimulator.describeChangedWorldState();
            }
            planCheckingSimulator.report();
            if (!planCheckingSimulator.getProblems().isEmpty()) {
                AutoTester.this.testFailure(this.test, "problems during simulated execution");
            }
            return planCheckingSimulator.getChangedWorldStateMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void planFromPlan(Slip slip) {
            AutoTester.this.traceln("Planning from the plan");
            Context context = Context.getContext();
            Context context2 = null;
            Domain domain = slip.getDomain();
            Plan plan = slip.getPlan();
            try {
                Context.setContext(Context.rootContext);
                context2 = Context.pushContext();
                Slip slip2 = AutoTester.this.makeTestPlanner(this.test);
                slip2.setDomain(domain);
                slip2.loadPlan(plan);
                slip2.plan();
                Plan plan2 = slip2.getPlan();
                this.savePlanFromPlan(plan2);
                boolean bl = new StructuralEquality().equal(plan, plan2);
                AutoTester.this.traceln("The plan " + (bl ? "is" : "is not") + " the same as before");
                this.checkPlan(slip2);
            }
            catch (NoPlanException noPlanException) {
                AutoTester.this.testFailure(this.test, "could not use the plan as an initial plan");
            }
            finally {
                try {
                    Context.setContext(context);
                    if (context2 != null) {
                        context2.discard();
                    }
                }
                catch (Throwable throwable) {
                    Debug.noteException(throwable);
                }
            }
        }

        protected void savePlanFromPlan(Plan plan) {
            String string = this.savedPlanName();
            XML.writeObject(plan, "/tmp/plan-from-" + string);
        }
    }
}

