/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.domain.Domain;
import ix.icore.plan.Plan;
import ix.ip2.Ip2;
import ix.iplan.IPlanOptionManager;
import ix.iplan.IPlanTool;
import ix.iplan.PlanCheckingSimulator;
import ix.iplan.PlanEvaluation;
import ix.util.ConsistencyException;

public class ChecksimPlanEvaluation
implements PlanEvaluation {
    Ip2 ip2;
    IPlanOptionManager.Opt option;
    String nextStep = "run";
    String simOutput = "";

    public ChecksimPlanEvaluation(Ip2 ip2, String string) {
        this.ip2 = ip2;
        this.option = ip2.getOptionManager().getOption(string);
    }

    public Object getValue() {
        return this.nextStep;
    }

    public boolean hasDetails() {
        return true;
    }

    public void detailsRequested() {
        IPlanTool iPlanTool = (IPlanTool)this.ip2.ensureTool("I-Plan");
        if (this.nextStep.equals("run")) {
            Plan plan = this.option.asPlan();
            Domain domain = this.ip2.getDomain();
            PlanCheckingSimulator planCheckingSimulator = new PlanCheckingSimulator(plan, domain);
            iPlanTool.checkPlan(planCheckingSimulator);
            this.simOutput = iPlanTool.getSimFrame().getText();
            this.nextStep = planCheckingSimulator.getProblems().isEmpty() ? "ok" : planCheckingSimulator.getProblems().size() + " problems";
        } else if (this.nextStep.equals("ok") || this.nextStep.endsWith("problems")) {
            IPlanTool.SimFrame simFrame = iPlanTool.getSimFrame();
            simFrame.setText("The simulation output was:\n\n" + this.simOutput);
            simFrame.setVisible(true);
        } else {
            throw new ConsistencyException("Unknown next-step", this.nextStep);
        }
    }
}

