/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.Activity;
import ix.icore.Annotated;
import ix.icore.Status;
import ix.icore.Variable;
import ix.icore.domain.Constraint;
import ix.icore.domain.Domain;
import ix.icore.domain.End;
import ix.icore.domain.ListOfConstraint;
import ix.icore.domain.ListOfPatternAssignment;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.icore.plan.Input;
import ix.icore.plan.Output;
import ix.icore.plan.ProcessParameter;
import ix.icore.process.PNode;
import ix.icore.process.PNodeEnd;
import ix.ip2.ActivityItem;
import ix.ip2.AdviceManager;
import ix.ip2.AgendaItem;
import ix.ip2.VariableManager;
import ix.iplan.Alternative;
import ix.iplan.DomainAnalyser;
import ix.iplan.IPlan;
import ix.iplan.IPlanModelManager;
import ix.iplan.NoPlanException;
import ix.iplan.PlanStats;
import ix.iplan.PlannerBase;
import ix.iplan.Poison;
import ix.iplan.ServiceSymbols;
import ix.iplan.SlipAchiever;
import ix.iplan.SlipFindExecutable;
import ix.iplan.SlipSingleStepper;
import ix.iplan.SlipStats;
import ix.iplan.TimePointNet;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.FailureException;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.StableHashMap;
import ix.util.Util;
import ix.util.context.Context;
import ix.util.context.ContextBoolean;
import ix.util.context.ContextGensym;
import ix.util.context.ContextHashMap;
import ix.util.context.ContextMap;
import ix.util.context.ContextMultiHashMap;
import ix.util.context.ContextMultiMap;
import ix.util.context.LLQueue;
import ix.util.lisp.Cons;
import ix.util.lisp.ItemVar;
import ix.util.lisp.Keyword;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.match.MatchEnv;
import ix.util.match.Matcher;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Slip
extends PlannerBase
implements ServiceSymbols {
    IPlanModelManager iplanMM;
    DomainAnalyser analysis;
    boolean useDomainAnalysis = true;
    boolean pickAlternativesDepthFirst = false;
    LListCollector alternatives = new LListCollector();
    ContextBoolean contextIsPoisoned = new ContextBoolean(false);
    ContextMap nodeEndStatusMap = new ContextHashMap();
    ContextMap isWaiting = new ContextHashMap();
    ContextMultiMap unwaitTable = new ContextMultiHashMap();
    LLQueue<Object[]> history = new LLQueue();
    Map savedInitialWorldState;
    SlipStats stats = new SlipStats(this);
    ContextGensym.Generator objectNameGenerator = new ContextGensym.Generator();
    int stepLimit = 100;
    int hardStepLimit = 500;
    SlipSingleStepper stepper = null;
    boolean singleStep = false;
    Step invalidStep;
    private Step nextStep = this.invalidStep = new Step(){

        public void run() {
            throw new ConsistencyException("Invalid algorithm step");
        }

        public String toString() {
            return "INVALID STEP";
        }
    };
    Step testStep = new Step(){

        public void run() {
            PNodeEnd pNodeEnd = Slip.this.findExecutable();
            if (pNodeEnd == null) {
                throw new HavePlanException();
            }
            Debug.noteln("Executing:", (Object)pNodeEnd);
            Slip.this.setStatus(pNodeEnd, Status.COMPLETE);
            Slip.this.nextStep = this;
        }
    };
    static final Symbol S_TRUE = Symbol.intern("true");
    static final Symbol SEARCH_PREFERENCE = Symbol.intern("search-preference");
    static final Symbol DEPTH_FIRST = Symbol.intern(":depth-first");
    public static final Keyword K_ALL = (Keyword)Symbol.intern(":all");
    public static final Keyword K_NONE = (Keyword)Symbol.intern(":none");
    public static final Symbol S_ACHIEVABLE_CONDS = Symbol.intern("achievable-world-state-conditions");
    public static final Symbol S_USE_FOR_EFFECTS = Symbol.intern("use-for-world-state-effects");
    ParameterMaker makeInput = new ParameterMaker(){

        public ProcessParameter makeParameter(Symbol symbol, Symbol symbol2, Symbol symbol3) {
            return new Input(symbol, symbol2, symbol3);
        }
    };
    ParameterMaker makeOutput = new ParameterMaker(){

        public ProcessParameter makeParameter(Symbol symbol, Symbol symbol2, Symbol symbol3) {
            return new Output(symbol, symbol2, symbol3);
        }
    };
    static final Symbol S_ACHIEVE_GOAL = Symbol.intern("__achieve-goal__");
    static final Symbol S_ACHIEVE_PV = Symbol.intern("__achieve-pv__");
    static final Symbol S_AT_END = Symbol.intern("__at-end___");
    static final Symbol S_EQL = Symbol.intern("=");
    ContextHashMap waitingForAchieveTable = new ContextHashMap();
    PossibleConditionFinder possibleCondFinder = new PossibleConditionFinder();
    PossibleEffectFinder possibleEffectFinder = new PossibleEffectFinder();
    PossibleConstraintFinder possibleConstraintFinder = new PossibleConstraintFinder();

    public Slip(boolean bl) {
        super(bl);
    }

    IPlanModelManager MM() {
        return this.iplanMM;
    }

    public static void main(String[] stringArray) {
        Util.printGreeting("I-Plan");
        Parameters.setIsInteractive(false);
        Slip slip = new Slip(true);
        slip.mainStartup(stringArray);
        slip.plan();
        slip.outputPlan();
        slip.exit();
    }

    @Override
    public void startup() {
        super.startup();
        this.iplanMM = (IPlanModelManager)this.modelManager;
    }

    @Override
    protected void processCommandLineArguments() {
        super.processCommandLineArguments();
        if (Parameters.haveParameter("step-limit")) {
            this.setStepLimit(Parameters.getInt("step-limit", this.stepLimit));
        }
        this.singleStep = Parameters.getBoolean("single-step", this.singleStep);
        if (this.singleStep) {
            this.stepper = new SlipSingleStepper(this);
        }
        this.useDomainAnalysis = Parameters.getBoolean("use-domain-analysis", this.useDomainAnalysis);
        if (this.useDomainAnalysis) {
            this.analysis = new DomainAnalyser(this.domain);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.alternatives.clear();
        this.nodeEndStatusMap.clearCompletely();
        this.isWaiting.clearCompletely();
        this.unwaitTable.clearCompletely();
        this.history.clearCompletely();
        this.stats = new SlipStats(this);
    }

    @Override
    public PlanStats getStatistics() {
        return this.stats;
    }

    Symbol generateObjectName(Symbol symbol) {
        return this.objectNameGenerator.nextSymbol(symbol.toString());
    }

    public void setStepLimit(int n) {
        this.stepLimit = n;
        this.hardStepLimit = Math.max(this.hardStepLimit, 3 * this.stepLimit);
    }

    @Override
    public void setDomain(Domain domain) {
        super.setDomain(domain);
        if (!this.useDomainAnalysis) {
            // empty if block
        }
        this.analysis = new DomainAnalyser(this.domain);
        this.analysis.analyse();
        this.pickAlternativesDepthFirst = this.preferDepthFirst();
    }

    @Override
    protected void addHandlers() {
    }

    void setNextStep(Step step) {
        this.nextStep = step;
    }

    @Override
    public void plan() {
        Debug.noteln("Plan requested from", (Object)this);
        this.history("Plan");
        if (this.useDomainAnalysis) {
            this.analysis.analyseIfNeeded();
        }
        Map map = this.iplanMM.getWorldStateMap();
        this.savedInitialWorldState = new StableHashMap(map);
        this.computeProperStatusValues();
        this.initStatusTable();
        this.nextStep = new SlipFindExecutable(this);
        this.planLoop();
    }

    @Override
    public void replan() {
        Debug.noteln("Replan requested from", (Object)this);
        this.history("Replan");
        this.stats = new SlipStats(this);
        this.nextStep = new ReplanStep();
        this.planLoop();
    }

    boolean findFirstPlan() {
        try {
            this.plan();
            return true;
        }
        catch (NoPlanException noPlanException) {
            return false;
        }
    }

    boolean findNextPlan() {
        try {
            this.replan();
            return true;
        }
        catch (NoPlanException noPlanException) {
            return false;
        }
    }

    void planLoop() {
        try {
            while (true) {
                try {
                    Step step = this.nextStep;
                    this.nextStep = this.invalidStep;
                    Debug.noteln("Step " + (this.stats.numberStepsTaken + 1) + ": " + Context.getContext() + " " + step);
                    if (this.singleStep) {
                        this.stepper.step();
                    }
                    this.stats.stepTaken();
                    step.run();
                }
                catch (Poison poison) {
                    Debug.noteln(Context.getContext(), (Object)poison);
                    this.nextStep = this.pickAlternative(poison);
                }
                if (this.stats.numberStepsTaken >= this.hardStepLimit) {
                    this.stepLimitReached(true);
                }
                if (this.stats.numberStepsTaken % this.stepLimit != 0) continue;
                this.stepLimitReached(false);
            }
        }
        catch (HavePlanException havePlanException) {
            this.createPlanContext();
            this.finishedPlanning(true);
        }
        catch (NoPlanException noPlanException) {
            this.finishedPlanning(false);
            throw noPlanException;
        }
        catch (Throwable throwable) {
            Debug.noteException(throwable);
            this.finishedPlanning(false);
            throw new RethrownException(throwable);
        }
    }

    void stepLimitReached(boolean bl) {
        if (!bl && Parameters.isInteractive() && Util.dialogConfirms(IPlan.displayFrame(), new String[]{"The planner has not found a plan after " + this.stats.numberStepsTaken + " planning steps.", "Do you want to continue for another " + this.stepLimit + " steps?"})) {
            return;
        }
        throw new StepLimitException("Step limit exceeded after " + this.stats.numberStepsTaken + " planning steps.");
    }

    void finishedPlanning(boolean bl) {
        Debug.noteln("Finished planning, success = " + bl);
        this.stats.fillInValues();
        if (bl) {
            Debug.expect(this.isWaiting.isEmpty(), "nonempty isWaiting map");
        }
        if (Debug.on) {
            Debug.noteln(bl ? "Plan found" : "No plan");
            Debug.noteln("Current context", (Object)Context.getContext());
            Context.printContextTree();
            this.stats.report(Debug.out);
            this.describeAlternatives();
            if (bl) {
                this.noteHistory();
            }
        }
    }

    void createPlanContext() {
        Context.pushContext();
        this.iplanMM.setWorldStateMap(this.savedInitialWorldState);
        this.computeProperStatusValues();
        this.recordInputsAndOutputs();
        for (ActivityItem activityItem : this.iplanMM.getNodes()) {
            if (!activityItem.isExpanded()) continue;
            activityItem.recordExpansionRefinementName();
        }
    }

    void postAlternative(Alternative alternative) {
        alternative.setCost(this);
        Debug.noteln("Posting", (Object)alternative);
        this.stats.altPosted();
        this.alternatives.pushElement(alternative);
        Context.pushContext();
    }

    Alternative pickAlternative(Object object) {
        boolean bl;
        if (this.alternatives.isEmpty()) {
            throw new NoPlanException();
        }
        Iterator iterator = this.alternatives.iterator();
        Alternative alternative = (Alternative)iterator.next();
        boolean bl2 = bl = this.pickAlternativesDepthFirst || alternative.isLocalChoice();
        if (!iterator.hasNext()) {
            Debug.noteln("Only one alternative, depth-first = " + bl);
        } else if (bl) {
            Debug.noteln("Picking alternative depth-first");
        } else {
            double d = alternative.getCost();
            while (iterator.hasNext()) {
                Alternative alternative2 = (Alternative)iterator.next();
                double d2 = alternative2.getCost();
                if (!(d2 < d)) continue;
                alternative = alternative2;
                d = d2;
            }
        }
        Debug.noteln("Picking", (Object)alternative);
        this.stats.altPicked();
        this.alternatives.deleteElement(alternative);
        Context context = alternative.getContext();
        Context.setContext(context);
        Debug.expect(this.contextIsPoisoned.isFalse(), "context is poisoned", context);
        Context.pushContext();
        this.history("Picked", alternative, "because", object);
        alternative.whenPicked();
        return alternative;
    }

    Poison poison(Object object) {
        this.contextIsPoisoned.set(true);
        return new Poison(object);
    }

    void history(Object ... objectArray) {
        this.history.add(objectArray);
    }

    void noteHistory() {
        Debug.noteln("Route to this plan:");
        for (Object[] objectArray : this.history) {
            Debug.note("-->");
            for (Object object : objectArray) {
                Debug.note(" ");
                Debug.note(object.toString());
            }
            Debug.noteln("");
        }
        Debug.noteln("");
    }

    boolean domainSays(String string) {
        return this.domain.getAnnotation(Symbol.intern(string)) == S_TRUE;
    }

    boolean preferDepthFirst() {
        return this.domain.getAnnotation(SEARCH_PREFERENCE) == DEPTH_FIRST;
    }

    static boolean isAchievableCond(LList lList, Annotated annotated) {
        Object object = annotated.getAnnotation(S_ACHIEVABLE_CONDS);
        return object == null ? true : (object == K_ALL ? true : (object == K_NONE ? false : ((List)object).contains(lList.get(0))));
    }

    static boolean canBeUsedForEffect(LList lList, Refinement refinement) {
        Object object = refinement.getAnnotation(S_USE_FOR_EFFECTS);
        return object == null ? true : (object == K_ALL ? true : (object == K_NONE ? false : ((List)object).contains(lList.get(0))));
    }

    void testStatusPropagation() {
        while (!this.planIsComplete()) {
            PNodeEnd pNodeEnd = this.findExecutable();
            Debug.expect(pNodeEnd != null, "nothing to execute");
            Debug.noteln("Executing:", (Object)pNodeEnd);
            this.setStatus(pNodeEnd, Status.COMPLETE);
        }
    }

    PNodeEnd findExecutable() {
        return this.findExecutable(this.iplanMM.getNodeEnds().iterator());
    }

    PNodeEnd findExecutable(Iterator iterator) {
        while (iterator.hasNext()) {
            PNodeEnd pNodeEnd = (PNodeEnd)iterator.next();
            if (this.getStatus(pNodeEnd) != Status.POSSIBLE) continue;
            return pNodeEnd;
        }
        return null;
    }

    boolean planIsComplete() {
        return this.allHaveStatus(this.iplanMM.getNodeEnds(), Status.COMPLETE);
    }

    Status getStatus(PNodeEnd pNodeEnd) {
        Status status = (Status)this.nodeEndStatusMap.get(pNodeEnd);
        return status != null ? status : Status.BLANK;
    }

    void setStatus(PNodeEnd pNodeEnd, Status status) {
        if (status == Status.COMPLETE) {
            this.history(status, pNodeEnd);
        }
        this.nodeEndStatusMap.put(pNodeEnd, status);
        this.allComputeStatus(pNodeEnd.getSuccessors());
    }

    void computeStatus(PNodeEnd pNodeEnd) {
        if (this.getStatus(pNodeEnd) == Status.BLANK && this.allHaveStatus(pNodeEnd.getPredecessors(), Status.COMPLETE)) {
            this.setStatus(pNodeEnd, Status.POSSIBLE);
        }
    }

    void allComputeStatus(List list) {
        for (PNodeEnd pNodeEnd : list) {
            this.computeStatus(pNodeEnd);
        }
    }

    boolean allHaveStatus(List list, Status status) {
        for (PNodeEnd pNodeEnd : list) {
            if (this.getStatus(pNodeEnd) == status) continue;
            return false;
        }
        return true;
    }

    void initStatusTable() {
        for (PNodeEnd pNodeEnd : this.iplanMM.getNodeEnds()) {
            this.nodeEndStatusMap.put(pNodeEnd, pNodeEnd.getStatus());
        }
    }

    void computeProperStatusValues() {
        for (PNodeEnd object : this.iplanMM.getNodeEnds()) {
            this.computeProperStatus(object);
        }
        for (PNode pNode : this.iplanMM.getNodes()) {
            this.setProperStatus(pNode);
        }
    }

    void computeProperStatus(PNodeEnd pNodeEnd) {
        Status status = pNodeEnd.getStatus();
        if (status == Status.BLANK) {
            if (PNode.allHaveStatus(pNodeEnd.getPredecessors(), Status.COMPLETE)) {
                this.setProperStatus(pNodeEnd, Status.POSSIBLE);
            }
        } else if (status == Status.POSSIBLE) {
            if (!PNode.allHaveStatus(pNodeEnd.getPredecessors(), Status.COMPLETE)) {
                this.setProperStatus(pNodeEnd, Status.BLANK);
            }
        } else if (status != Status.COMPLETE) {
            throw new IllegalArgumentException("Cannot handle status " + status + " for " + pNodeEnd);
        }
    }

    void setProperStatus(PNodeEnd pNodeEnd, Status status) {
        Debug.noteln("Setting proper status of " + pNodeEnd + " from " + pNodeEnd.getStatus() + " to " + status);
        pNodeEnd.setStatus(status);
        Debug.noteln("Status is now", (Object)pNodeEnd.getStatus());
    }

    void setProperStatus(PNode pNode) {
        Status status;
        Status status2 = pNode.getStatus();
        if (status2 != (status = pNode.statusFromNodeEnds())) {
            Debug.noteln("Setting proper status of " + pNode + " from " + status2 + " to " + status);
            pNode.setStatus(status);
            Debug.noteln("Node status is now", (Object)pNode.getStatus());
        }
    }

    boolean canExecBegin(PNodeEnd pNodeEnd) {
        Debug.expectSame(End.BEGIN, pNodeEnd.getEnd());
        PNode pNode = pNodeEnd.getNode();
        List list = this.iplanMM.getNodeTimeConstraints(pNode);
        List<Constraint> list2 = this.iplanMM.getOtherNodeConstraints(pNode);
        return Variable.isFullyBoundEverywhere(list) && Variable.isFullyBoundEverywhere(list2);
    }

    void execBegin(PNodeEnd pNodeEnd) {
        Debug.noteln("execBegin", (Object)pNodeEnd);
        Debug.expectSame(End.BEGIN, pNodeEnd.getEnd());
        Debug.expect(this.canExecBegin(pNodeEnd));
        PNode pNode = pNodeEnd.getNode();
        List<Constraint> list = this.iplanMM.getOtherNodeConstraints(pNode);
        Debug.noteln("Other constraints", list);
        if (list != null) {
            try {
                this.iplanMM.evalAtBegin(pNodeEnd, list);
            }
            catch (FailureException failureException) {
                throw this.poison(failureException);
            }
        }
        this.releaseWaitingEnds(pNodeEnd);
        this.setStatus(pNodeEnd, Status.COMPLETE);
    }

    boolean canExecEnd(PNodeEnd pNodeEnd) {
        Debug.expectSame(End.END, pNodeEnd.getEnd());
        PNode pNode = pNodeEnd.getNode();
        List list = this.iplanMM.getNodeEffects(pNode);
        return Variable.isFullyBoundEverywhere(list);
    }

    void execEnd(PNodeEnd pNodeEnd) {
        Debug.noteln("execEnd", (Object)pNodeEnd);
        Debug.expectSame(End.END, pNodeEnd.getEnd());
        PNode pNode = pNodeEnd.getNode();
        List list = this.iplanMM.getNodeEffects(pNode);
        List<Constraint> list2 = this.iplanMM.getOtherNodeConstraints(pNode);
        Debug.noteln("Effects", (Object)list);
        Debug.noteln("Other constraints", list2);
        try {
            if (list != null) {
                this.iplanMM.handleEffects(pNode, list);
            }
            if (list2 != null) {
                this.iplanMM.evalAtEnd(pNodeEnd, list2);
            }
        }
        catch (FailureException failureException) {
            throw this.poison(failureException);
        }
        this.releaseWaitingEnds(pNodeEnd);
        this.setStatus(pNodeEnd, Status.COMPLETE);
    }

    void releaseWaitingEnds(PNodeEnd pNodeEnd) {
        List list = (List)this.unwaitTable.get(pNodeEnd);
        if (list != null) {
            for (PNodeEnd pNodeEnd2 : list) {
                this.isWaiting.remove(pNodeEnd2);
            }
        }
    }

    void recordInputsAndOutputs() {
        for (AgendaItem agendaItem : this.iplanMM.getNodes()) {
            Activity activity = (Activity)agendaItem.getAbout();
            if (activity.getAnnotation(S_INPUTS) != null || activity.getAnnotation(S_OUTPUTS) != null) continue;
            this.recordInputsAndOutputs(activity);
        }
    }

    void recordInputsAndOutputs(Activity activity) {
        List list;
        String string = activity.getPattern().car().toString();
        Refinement refinement = this.domain.getNamedRefinement(string);
        if (refinement == null) {
            return;
        }
        Debug.expect(Variable.isFullyBound(activity.getPattern()), "Not fully bound", activity.getPattern());
        MatchEnv matchEnv = Matcher.match(refinement.getPattern(), activity.getPattern());
        if (matchEnv == null) {
            return;
        }
        ListOfPatternAssignment listOfPatternAssignment = refinement.getConditions();
        ListOfPatternAssignment listOfPatternAssignment2 = refinement.getEffects();
        if (!listOfPatternAssignment.isEmpty() && !(list = this.makeParameters(listOfPatternAssignment, matchEnv, this.makeInput)).isEmpty()) {
            activity.setAnnotation(S_INPUTS, list);
        }
        if (!listOfPatternAssignment2.isEmpty() && !(list = this.makeParameters(listOfPatternAssignment2, matchEnv, this.makeOutput)).isEmpty()) {
            activity.setAnnotation(S_OUTPUTS, list);
        }
    }

    List makeParameters(List list, MatchEnv matchEnv, ParameterMaker parameterMaker) {
        LinkedList<ProcessParameter> linkedList = new LinkedList<ProcessParameter>();
        for (PatternAssignment patternAssignment : list) {
            ItemVar itemVar;
            LList lList = patternAssignment.getPattern();
            if (lList.length() != 2 || lList.get(0) != S_TYPE || !(lList.get(1) instanceof ItemVar) || !(patternAssignment.getValue() instanceof Symbol)) continue;
            ItemVar itemVar2 = itemVar = (ItemVar)lList.get(1);
            Symbol symbol = (Symbol)patternAssignment.getValue();
            Symbol symbol2 = (Symbol)matchEnv.get(itemVar);
            linkedList.add(parameterMaker.makeParameter(itemVar2, symbol, symbol2));
        }
        return linkedList;
    }

    boolean isGoalNode(PNodeEnd pNodeEnd) {
        LList lList = pNodeEnd.getNode().getPattern();
        return lList.car() == S_ACHIEVE_GOAL;
    }

    boolean isGoalNode(PNode pNode) {
        LList lList = pNode.getPattern();
        return lList.car() == S_ACHIEVE_GOAL;
    }

    PatternAssignment getGoalCond(PNodeEnd pNodeEnd) {
        ActivityItem activityItem = (ActivityItem)pNodeEnd.getNode();
        Activity activity = (Activity)activityItem.getAbout();
        PatternAssignment patternAssignment = (PatternAssignment)activity.getAnnotation(S_ACHIEVE_PV);
        Debug.expect(patternAssignment != null, "no goal cond for", activity);
        return patternAssignment;
    }

    ActivityItem makeGoalNode(PatternAssignment patternAssignment, List list, PNodeEnd pNodeEnd) {
        Cons cons = Lisp.list(S_ACHIEVE_GOAL, patternAssignment.getPattern(), S_EQL, patternAssignment.getValue());
        Activity activity = new Activity(cons);
        ActivityItem activityItem = new ActivityItem(activity);
        activity.setAnnotation(S_ACHIEVE_PV, patternAssignment);
        activity.setAnnotation(S_ACHIEVE_GOAL, list);
        activity.setAnnotation(S_AT_END, pNodeEnd);
        return activityItem;
    }

    List getGoalAchievers(PNode pNode) {
        Debug.expectSame(S_ACHIEVE_GOAL, pNode.getPattern().get(0));
        ActivityItem activityItem = (ActivityItem)pNode;
        List list = (List)activityItem.getAbout().getAnnotation(S_ACHIEVE_GOAL);
        Debug.expect(list != null, "no achievers for", pNode);
        return list;
    }

    PNodeEnd getAtEndForGoal(PNodeEnd pNodeEnd) {
        return this.getAtEndForGoal((ActivityItem)pNodeEnd.getNode());
    }

    PNodeEnd getAtEndForGoal(ActivityItem activityItem) {
        Debug.expectSame(S_ACHIEVE_GOAL, activityItem.getPattern().get(0));
        PNodeEnd pNodeEnd = (PNodeEnd)activityItem.getAbout().getAnnotation(S_AT_END);
        Debug.expect(pNodeEnd != null, "no at-end for", activityItem);
        return pNodeEnd;
    }

    void normalizeGoalNode(ActivityItem activityItem) {
        Refinement refinement = activityItem.getRefinement();
        PNodeEnd pNodeEnd = this.getAtEndForGoal(activityItem);
        LList lList = refinement.getPattern();
        Activity activity = new Activity(lList);
        activity.setAnnotation(S_ACHIEVE_GOAL, this.getGoalCond(activityItem.getBegin()));
        activityItem.setAbout(activity);
        activityItem.setRefinement(refinement);
        TimePointNet timePointNet = this.iplanMM.getTPNManager();
        timePointNet.addTimeConstraintElseFail(activityItem.getBegin(), activityItem.getEnd());
        timePointNet.addTimeConstraintElseFail(activityItem.getEnd(), pNodeEnd);
    }

    void recordAsWaitingForAchieve(PNode pNode) {
        this.waitingForAchieveTable.put(pNode, pNode);
    }

    boolean isWaitingForAchieve(PNode pNode) {
        return this.waitingForAchieveTable.get(pNode) == pNode;
    }

    List getAchieversForCond(PatternAssignment patternAssignment) {
        VariableManager variableManager = this.iplanMM.getVariableManager();
        AdviceManager adviceManager = this.iplanMM.getAdviceManager();
        LinkedList<SlipAchiever> linkedList = new LinkedList<SlipAchiever>();
        LList lList = patternAssignment.getPattern();
        Object object = patternAssignment.getValue();
        if (!Slip.isAchievableCond(lList, this.domain)) {
            return linkedList;
        }
        for (Refinement refinement : this.getDomain().getRefinements()) {
            ListOfConstraint listOfConstraint = refinement.getConstraints();
            if (listOfConstraint == null || !adviceManager.isUsableRefinement(refinement)) continue;
            for (Constraint constraint : listOfConstraint) {
                MatchEnv matchEnv;
                if (constraint.getType() != Refinement.S_WORLD_STATE) continue;
                if (constraint.getRelation() != Refinement.S_EFFECT) continue;
                Constraint constraint2 = constraint;
                PatternAssignment patternAssignment2 = (PatternAssignment)constraint2.getParameter(0);
                LList lList2 = patternAssignment2.getPattern();
                if (lList.car() != lList2.car() || !Slip.canBeUsedForEffect(lList2, refinement)) continue;
                Object object2 = patternAssignment2.getValue();
                MatchEnv matchEnv2 = Matcher.match(lList, lList2);
                if (matchEnv2 == null || (matchEnv = Matcher.match(object, object2, matchEnv2)) == null || !variableManager.consistentBindings(matchEnv)) continue;
                linkedList.add(new SlipAchiever(patternAssignment, refinement, patternAssignment2, matchEnv));
            }
        }
        return linkedList;
    }

    boolean existsAchieversForCond(PatternAssignment patternAssignment) {
        VariableManager variableManager = this.iplanMM.getVariableManager();
        AdviceManager adviceManager = this.iplanMM.getAdviceManager();
        LList lList = patternAssignment.getPattern();
        Object object = patternAssignment.getValue();
        if (!Slip.isAchievableCond(lList, this.domain)) {
            return false;
        }
        for (Refinement refinement : this.getDomain().getRefinements()) {
            ListOfConstraint listOfConstraint = refinement.getConstraints();
            if (listOfConstraint == null || !adviceManager.isUsableRefinement(refinement)) continue;
            for (Constraint constraint : listOfConstraint) {
                MatchEnv matchEnv;
                if (constraint.getType() != Refinement.S_WORLD_STATE) continue;
                if (constraint.getRelation() != Refinement.S_EFFECT) continue;
                Constraint constraint2 = constraint;
                PatternAssignment patternAssignment2 = (PatternAssignment)constraint2.getParameter(0);
                LList lList2 = patternAssignment2.getPattern();
                if (lList.car() != lList2.car() || !Slip.canBeUsedForEffect(lList2, refinement)) continue;
                Object object2 = patternAssignment2.getValue();
                MatchEnv matchEnv2 = Matcher.match(lList, lList2);
                if (matchEnv2 == null || (matchEnv = Matcher.match(object, object2, matchEnv2)) == null || !variableManager.consistentBindings(matchEnv)) continue;
                return true;
            }
        }
        return false;
    }

    Set getPossibleConditions(PNodeEnd pNodeEnd) {
        return this.possibleCondFinder.getPossibles(pNodeEnd);
    }

    Set getPossibleEffects(PNodeEnd pNodeEnd) {
        return this.possibleEffectFinder.getPossibles(pNodeEnd);
    }

    Set getPossibleOtherConstraints(PNodeEnd pNodeEnd) {
        return this.possibleConstraintFinder.getPossibles(pNodeEnd);
    }

    private List<PatternAssignment> constraintsToPVs(List list) {
        if (list == null) {
            return Collections.emptyList();
        }
        LinkedList<PatternAssignment> linkedList = new LinkedList<PatternAssignment>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            linkedList.add(((Constraint)iterator.next()).getPatternAssignment());
        }
        return linkedList;
    }

    void describeAlternatives() {
        Debug.noteln("Alternatives:");
        if (this.alternatives.isEmpty()) {
            Debug.noteln("None");
        } else {
            for (Alternative alternative : this.alternatives) {
                this.describeAlternative(alternative);
            }
        }
    }

    void describeAlternative(Alternative alternative) {
        Debug.noteln("   " + alternative);
    }

    void describeNodeEnds() {
        this.describeNodeEnds(this.iplanMM.getNodeEnds());
    }

    void describeNodeEnds(List list) {
        for (PNodeEnd pNodeEnd : list) {
            this.describeNodeEnd(pNodeEnd);
        }
    }

    void describeNodeEnd(PNodeEnd pNodeEnd) {
        Debug.noteln(this.getStatus(pNodeEnd) + " " + pNodeEnd);
        this.describeLinks(pNodeEnd, "after", pNodeEnd.getPredecessors());
        this.describeLinks(pNodeEnd, "before", pNodeEnd.getSuccessors());
    }

    void describeLinks(PNodeEnd pNodeEnd, String string, List list) {
        if (list.isEmpty()) {
            Debug.noteln("  No " + string + " links");
        } else {
            Debug.noteln("  Linked " + string + ":");
            for (PNodeEnd pNodeEnd2 : list) {
                if (pNodeEnd2.getNode() == pNodeEnd.getNode()) {
                    Debug.noteln("     " + pNodeEnd2.getEnd() + " of self");
                    continue;
                }
                Debug.noteln("    ", (Object)pNodeEnd2);
            }
        }
    }

    abstract class PossiblesFinder {
        PossiblesFinder() {
        }

        Set getPossibles(PNodeEnd pNodeEnd) {
            if (Slip.this.isGoalNode(pNodeEnd)) {
                return this.getForGoalNode(pNodeEnd);
            }
            PNode pNode = pNodeEnd.getNode();
            List list = this.getInstalled(pNode);
            if (pNode.isExpanded()) {
                return list == null ? Collections.emptySet() : new HashSet(list);
            }
            Set set = this.getForPattern(pNode.getPattern());
            if (list != null) {
                set.addAll(list);
            }
            return set;
        }

        abstract List getInstalled(PNode var1);

        abstract Set getForPattern(LList var1);

        void addExtraForAchiever(SlipAchiever slipAchiever, Set set) {
        }

        Set getForGoalNode(PNodeEnd pNodeEnd) {
            Debug.expect(!pNodeEnd.getNode().isExpanded());
            HashSet hashSet = new HashSet();
            List list = Slip.this.getGoalAchievers(pNodeEnd.getNode());
            for (SlipAchiever slipAchiever : list) {
                LList lList = slipAchiever.refinement.getPattern();
                hashSet.addAll(this.getForPattern(lList));
                this.addExtraForAchiever(slipAchiever, hashSet);
            }
            return hashSet;
        }
    }

    class PossibleConstraintFinder
    extends PossiblesFinder {
        PossibleConstraintFinder() {
        }

        List getInstalled(PNode pNode) {
            return Slip.this.iplanMM.getOtherNodeConstraints(pNode);
        }

        Set getForPattern(LList lList) {
            return Slip.this.analysis.getPossibleConstraints(lList);
        }
    }

    class PossibleEffectFinder
    extends PossiblesFinder {
        PossibleEffectFinder() {
        }

        List getInstalled(PNode pNode) {
            return Slip.this.iplanMM.getNodeEffects(pNode);
        }

        Set getForPattern(LList lList) {
            return Slip.this.analysis.getPossibleEffects(lList);
        }

        void addExtraForAchiever(SlipAchiever slipAchiever, Set set) {
            Debug.expect(Slip.this.analysis.haveCommonPatterns(set, new HashSet(Lisp.list(slipAchiever.cond))));
        }
    }

    class PossibleConditionFinder
    extends PossiblesFinder {
        PossibleConditionFinder() {
        }

        List getInstalled(PNode pNode) {
            return Slip.this.constraintsToPVs(Slip.this.iplanMM.getNodeConditions(pNode));
        }

        Set getForPattern(LList lList) {
            return Slip.this.analysis.getPossibleConditions(lList);
        }

        void addExtraForAchiever(SlipAchiever slipAchiever, Set set) {
            set.add(slipAchiever.cond);
        }
    }

    static interface ParameterMaker {
        public ProcessParameter makeParameter(Symbol var1, Symbol var2, Symbol var3);
    }

    static class StepLimitException
    extends RuntimeException {
        public StepLimitException(String string) {
            super(string);
        }
    }

    static class HavePlanException
    extends RuntimeException {
        HavePlanException() {
        }
    }

    class ReplanStep
    implements Step {
        ReplanStep() {
        }

        public void run() {
            Slip.this.nextStep = Slip.this.pickAlternative("Replan");
        }
    }

    static interface Step
    extends Runnable {
    }
}

