/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.process.PNodeEnd;
import ix.iplan.PlanStats;
import ix.iplan.Slip;
import ix.util.AbstractDirectedGraph;
import ix.util.BoundedGraph;
import ix.util.Debug;
import ix.util.Graphs;
import ix.util.IntRef;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SlipStats
implements PlanStats {
    Slip slip;
    boolean filledInValues = false;
    int numberStepsTaken = 0;
    int numberAltsPosted = 0;
    int numberAltsPicked = 0;
    int numberAltsLeft = -1;
    int numberNodes = -1;
    int longestPathLength = -1;
    Map otherStats = null;

    public SlipStats(Slip slip) {
        this.slip = slip;
    }

    public void stepTaken() {
        ++this.numberStepsTaken;
    }

    public void altPosted() {
        ++this.numberAltsPosted;
    }

    public void altPicked() {
        ++this.numberAltsPicked;
    }

    public void recordStat(String string, Object object) {
        if (this.otherStats == null) {
            this.otherStats = new TreeMap();
        }
        this.otherStats.put(string, object);
    }

    public void incrementStat(String string) {
        Integer n;
        if (this.otherStats != null && (n = (Integer)this.otherStats.get(string)) != null) {
            this.otherStats.put(string, new Integer(n + 1));
            return;
        }
        this.recordStat(string, new Integer(1));
    }

    public void addStats(PlanStats planStats) {
        SlipStats slipStats = (SlipStats)planStats;
        if (!this.filledInValues) {
            this.numberAltsLeft = 0;
            this.numberNodes = 0;
            this.longestPathLength = 0;
            this.filledInValues = true;
        }
        this.numberStepsTaken += slipStats.numberStepsTaken;
        this.numberAltsPosted += slipStats.numberAltsPosted;
        this.numberAltsPicked += slipStats.numberAltsPicked;
        this.numberAltsLeft += slipStats.numberAltsPosted - slipStats.numberAltsPicked;
        this.numberNodes += slipStats.numberNodes;
        this.longestPathLength += slipStats.longestPathLength;
        if (slipStats.otherStats != null) {
            for (Map.Entry entry : slipStats.otherStats.entrySet()) {
                String string = (String)entry.getKey();
                Integer n = (Integer)entry.getValue();
                Integer n2 = (Integer)this.otherStats.get(string);
                if (n2 == null) {
                    this.otherStats.put(string, n);
                    continue;
                }
                this.otherStats.put(string, new Integer(n2 + n));
            }
        }
    }

    void fillInValues() {
        this.numberAltsLeft = this.slip.alternatives.size();
        this.numberNodes = this.slip.MM().getNodes().size();
        this.longestPathLength = this.calcLongestPathLength();
        this.filledInValues = true;
    }

    public void report(PrintStream printStream) {
        Debug.expect(this.filledInValues, "missing values for stats");
        printStream.println("Planning statistics:");
        printStream.println("Steps taken = " + this.numberStepsTaken);
        printStream.println("Alternatives posted = " + this.numberAltsPosted);
        printStream.println("Alternatives picked = " + this.numberAltsPicked);
        printStream.println("Alternatives remaining = " + this.numberAltsLeft);
        printStream.println("Number of nodes = " + this.numberNodes);
        printStream.println("Longest node-end path length = " + this.longestPathLength);
        if (this.otherStats != null) {
            for (Map.Entry entry : this.otherStats.entrySet()) {
                printStream.println(entry.getKey() + " = " + entry.getValue());
            }
        }
    }

    public int calcLongestPathLength() {
        return this.calcLongestPathLength(this.slip.MM().getNodeEnds());
    }

    public int calcLongestPathLength(final List list) {
        AbstractDirectedGraph abstractDirectedGraph = new AbstractDirectedGraph(){

            public Collection getAllNodes() {
                return list;
            }

            public Collection getRoots() {
                return list;
            }

            public Collection getSuccessors(Object object) {
                return ((PNodeEnd)object).getSuccessors();
            }

            public String toString() {
                return "DirectedGraph[" + this.getAllNodes() + "]";
            }
        };
        BoundedGraph boundedGraph = Graphs.makeBoundedGraph(abstractDirectedGraph);
        Map map = Graphs.findLongestPathLengths(boundedGraph);
        IntRef intRef = (IntRef)map.get(boundedGraph.getFinishNode());
        return intRef.get() - 2;
    }
}

