/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.ConstraintManager;
import ix.icore.ConstraintManagerRegistry;
import ix.icore.domain.Constraint;
import ix.icore.domain.Ordering;
import ix.icore.domain.TimeWindow;
import ix.icore.process.PNode;
import ix.icore.process.PNodeEnd;
import ix.icore.process.TimePoint;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.FailureException;
import ix.util.Inf;
import ix.util.context.ContextHashMap;
import ix.util.context.ContextInt;
import ix.util.context.ContextMap;
import ix.util.lisp.Lisp;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TimePointNet
implements ConstraintManager {
    protected ContextMap knownPoints = new ContextHashMap();
    protected ContextInt numberOfPoints = new ContextInt(0);
    protected TimePoint timePointAtZero = null;
    private int mark = 0;
    private int baseMark = 0;
    private List changeHistory;
    private List changedPoints;

    protected int getNumberOfPoints() {
        return this.numberOfPoints.get();
    }

    public void registerWith(ConstraintManagerRegistry constraintManagerRegistry) {
        throw new UnsupportedOperationException("TimePointNet does not support the registerWith method.");
    }

    public void reset() {
        this.knownPoints = new ContextHashMap();
        this.numberOfPoints = new ContextInt(0);
        this.timePointAtZero = null;
    }

    public void clear() {
        this.knownPoints.clear();
        this.numberOfPoints.set(0);
    }

    public void addConstraint(Constraint constraint) {
        throw new UnsupportedOperationException("Method addConstraint(Constraint) is not supported by TimePointNet.");
    }

    public void addOrdering(Map map, Ordering ordering) {
        PNodeEnd pNodeEnd = PNodeEnd.fromRef(map, ordering.getFrom());
        PNodeEnd pNodeEnd2 = PNodeEnd.fromRef(map, ordering.getTo());
        this.addTimeConstraintElseFail(pNodeEnd, pNodeEnd2);
    }

    public void addConstraint(PNode pNode, Constraint constraint) {
        Debug.noteln("Adding time constraint", (Object)constraint);
        Debug.expectEquals("duration", constraint.getRelation().toString());
        Debug.expect(constraint.getParameters().size() == 2);
        Debug.expectEquals("self", constraint.getParameters().get(0).toString());
        PNodeEnd pNodeEnd = pNode.getBegin();
        PNodeEnd pNodeEnd2 = pNode.getEnd();
        TimeWindow timeWindow = (TimeWindow)constraint.getParameters().get(1);
        long l = timeWindow.getMin().asMilliseconds();
        long l2 = timeWindow.getMax() == null ? Long.MAX_VALUE : timeWindow.getMax().asMilliseconds();
        this.addTimePoint(pNodeEnd);
        this.addTimePoint(pNodeEnd2);
        if (!this.addTimeConstraint(pNodeEnd, pNodeEnd2, l, l2)) {
            throw new FailureException("Cannot add " + constraint);
        }
    }

    public void evalAtBegin(PNodeEnd pNodeEnd, Constraint constraint) {
        throw new UnsupportedOperationException("Method evalAtBegin is not supported by TimePointNet.");
    }

    public void evalAtEnd(PNodeEnd pNodeEnd, Constraint constraint) {
        throw new UnsupportedOperationException("Method evalAtEnd is not supported by TimePointNet.");
    }

    public boolean mightInteract(Constraint constraint, Constraint constraint2) {
        throw new UnsupportedOperationException("Method mightInteract is not supported by TimePointNet.");
    }

    public TimePoint addTimePoint(long l, long l2) {
        Debug.expect(l2 == Long.MAX_VALUE || l <= l2);
        this.numberOfPoints.add(1);
        return new TimePoint(l, l2);
    }

    public TimePoint addTimePoint(TimePoint timePoint) {
        if (this.knownPoints.get(timePoint) != Boolean.TRUE) {
            this.knownPoints.put(timePoint, Boolean.TRUE);
            this.numberOfPoints.add(1);
        }
        return timePoint;
    }

    public void makeTimePointAtZero() {
        this.timePointAtZero = this.addTimePoint(0L, 0L);
    }

    public void addTimeConstraintElseFail(TimePoint timePoint, TimePoint timePoint2) {
        this.addTimePoint(timePoint);
        this.addTimePoint(timePoint2);
        if (!this.addTimeConstraint(timePoint, timePoint2, 0L, Long.MAX_VALUE)) {
            throw new FailureException("Cannot add " + timePoint + " -- 0..inf --> " + timePoint2);
        }
    }

    public boolean addTimeConstraint(TimePoint timePoint, TimePoint timePoint2, long l, long l2) {
        Debug.expect(l2 == Long.MAX_VALUE || l <= l2);
        TimeConstraint timeConstraint = new TimeConstraint(timePoint, timePoint2, l, l2);
        timePoint.addPostConstraint(timeConstraint);
        timePoint2.addPreConstraint(timeConstraint);
        if (this.propagateAfterAdding(timeConstraint)) {
            Debug.noteln("Added", (Object)timeConstraint);
            return true;
        }
        this.deleteTimeConstraint(timeConstraint);
        Debug.noteln("Failed to add", (Object)timeConstraint);
        return false;
    }

    protected void deleteTimeConstraint(TimeConstraint timeConstraint) {
        timeConstraint.getPrePoint().removePostConstraint(timeConstraint);
        timeConstraint.getPostPoint().removePreConstraint(timeConstraint);
    }

    public void describeTPN(PrintStream printStream) {
        printStream.println("Time Point Net");
        for (TimePoint timePoint : this.knownPoints.keySet()) {
            printStream.println(timePoint);
            printStream.println(timePoint.getMinTime() + ".." + Inf.asString(timePoint.getMaxTime()));
            for (TimeConstraint timeConstraint : timePoint.getPostConstraints()) {
                printStream.println("   " + timeConstraint);
            }
            printStream.println("");
        }
    }

    protected boolean propagateAfterAdding(TimeConstraint timeConstraint) {
        TimePoint timePoint = timeConstraint.getPrePoint();
        TimePoint timePoint2 = timeConstraint.getPostPoint();
        long l = timeConstraint.getMin();
        long l2 = timeConstraint.getMax();
        long l3 = timePoint.getMinTime();
        long l4 = timePoint2.getMinTime();
        long l5 = timePoint.getMaxTime();
        long l6 = timePoint2.getMaxTime();
        if (l3 + l > l4 || l2 != Long.MAX_VALUE && l4 - l2 > l3 || Inf.isLess(Inf.diff(l6, l), l5) || Inf.isLess(Inf.add(l5, l2), l6)) {
            return this.updateTimeWindows(Lisp.list(timePoint, timePoint2));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateTimeWindows(List list) {
        try {
            this.changeHistory = new LinkedList();
            if (this.findMinValues(list)) {
                if (this.findMaxValues(list)) {
                    boolean bl = true;
                    return bl;
                }
                throw new ConsistencyException("Can't find max values.");
            }
            this.undoTpnChanges(this.changeHistory);
            boolean bl = false;
            return bl;
        }
        finally {
            this.changeHistory = null;
            this.changedPoints = null;
        }
    }

    boolean findMinValues(List list) {
        List list2 = list;
        this.changedPoints = new LinkedList();
        int n = this.getNumberOfPoints();
        this.baseMark = this.mark;
        for (int i = 0; !list2.isEmpty() && i <= n; ++i) {
            this.mark = this.newMark();
            for (TimePoint timePoint : list2) {
                if (timePoint.getMaxTime() != Long.MAX_VALUE && timePoint.getMaxTime() < timePoint.getMinTime()) {
                    return false;
                }
                for (TimeConstraint timeConstraint : timePoint.getPostConstraints()) {
                    Debug.expectSame(timePoint, timeConstraint.getPrePoint());
                    this.constrainMin(timePoint, timeConstraint.getPostPoint(), timeConstraint.getMin());
                }
                for (TimeConstraint timeConstraint : timePoint.getPreConstraints()) {
                    Debug.expectSame(timePoint, timeConstraint.getPostPoint());
                    this.constrainMin(timePoint, timeConstraint.getPrePoint(), -timeConstraint.getMax());
                }
            }
            list2 = this.changedPoints;
            this.changedPoints = new LinkedList();
        }
        return list2.isEmpty();
    }

    void constrainMin(TimePoint timePoint, TimePoint timePoint2, long l) {
        long l2 = timePoint.getMinTime() + l;
        if (l2 > timePoint2.getMinTime()) {
            if (timePoint2.tpn_mark <= this.baseMark) {
                this.changeHistory.add(new Change(timePoint2));
            }
            timePoint2.setMinTime(l2);
            if (timePoint2.tpn_mark != this.mark) {
                timePoint2.tpn_mark = this.mark;
                this.changedPoints.add(timePoint2);
            }
        }
    }

    void undoTpnChanges(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((Change)iterator.next()).undo();
        }
    }

    private int newMark() {
        Debug.expect(this.mark < Integer.MAX_VALUE);
        return this.mark + 1;
    }

    boolean findMaxValues(List list) {
        List list2 = list;
        this.changedPoints = new LinkedList();
        int n = this.getNumberOfPoints();
        int n2 = 0;
        while (!list2.isEmpty()) {
            Debug.expect(n2 < n);
            this.mark = this.newMark();
            for (TimePoint timePoint : list2) {
                for (TimeConstraint timeConstraint : timePoint.getPreConstraints()) {
                    Debug.expectSame(timePoint, timeConstraint.getPostPoint());
                    this.constrainMax(timeConstraint.getPrePoint(), timePoint, timeConstraint.getMin());
                }
                for (TimeConstraint timeConstraint : timePoint.getPostConstraints()) {
                    Debug.expectSame(timePoint, timeConstraint.getPrePoint());
                    if (timeConstraint.getMax() == Long.MAX_VALUE) continue;
                    this.constrainMax(timeConstraint.getPostPoint(), timePoint, -timeConstraint.getMax());
                }
            }
            list2 = this.changedPoints;
            this.changedPoints = new LinkedList();
            ++n2;
        }
        return true;
    }

    void constrainMax(TimePoint timePoint, TimePoint timePoint2, long l) {
        if (timePoint2.getMaxTime() != Long.MAX_VALUE) {
            long l2 = timePoint2.getMaxTime() - l;
            long l3 = timePoint.getMaxTime();
            if (l3 == Long.MAX_VALUE || l2 < l3) {
                timePoint.setMaxTime(l2);
                if (timePoint.tpn_mark != this.mark) {
                    timePoint.tpn_mark = this.mark;
                    this.changedPoints.add(timePoint);
                }
            }
        }
    }

    static class Change {
        TimePoint point;
        long oldMin;

        Change(TimePoint timePoint) {
            this.point = timePoint;
            this.oldMin = timePoint.getMinTime();
        }

        void undo() {
            this.point.setMinTime(this.oldMin);
        }
    }

    public static class TimeConstraint {
        protected final TimePoint pre;
        protected final TimePoint post;
        protected final long min;
        protected final long max;

        public TimeConstraint(TimePoint timePoint, TimePoint timePoint2, long l, long l2) {
            this.pre = timePoint;
            this.post = timePoint2;
            this.min = l;
            this.max = l2;
        }

        public TimePoint getPrePoint() {
            return this.pre;
        }

        public TimePoint getPostPoint() {
            return this.post;
        }

        public long getMin() {
            return this.min;
        }

        public long getMax() {
            return this.max;
        }

        public String toString() {
            return "TimeConstraint[" + this.pre + this.arrow() + this.post + "]";
        }

        private String arrow() {
            return "-- " + this.min + ".." + Inf.asString(this.max) + " -->";
        }
    }
}

