/*
 * Decompiled with CFR 0.152.
 */
package ix.iserve.ipc;

import ix.icore.IXAgent;
import ix.iface.util.Reporting;
import ix.ip2.Ip2;
import ix.iserve.ipc.IServeCommunicationTool;
import ix.iserve.ipc.MessageMemory;
import ix.iserve.ipc.MessageWrapper;
import ix.util.Debug;
import ix.util.IPC;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.RethrownIOException;
import ix.util.Util;
import ix.util.http.HttpObjectClient;
import ix.util.http.HttpUtilities;
import ix.util.ipc.ServiceAddress;
import java.net.URL;
import java.util.Date;
import javax.swing.SwingUtilities;

public class IServeCommunicationStrategy
implements IPC.CommunicationStrategy {
    IServeCommunicationTool tool;
    boolean ableToSend = false;
    volatile int expectedSeqNo = 0;
    MessageMemory messageMap = new MessageMemory();
    HttpObjectClient http = new HttpObjectClient();
    HttpUtilities httpUtil = new HttpUtilities();
    Ip2 agent;
    ServiceAddress serverAddr;
    URL messageUrl;
    IPC.MessageListener messageListener;

    void setTool(IServeCommunicationTool iServeCommunicationTool) {
        this.tool = iServeCommunicationTool;
    }

    String getAgentName() {
        return this.agent.getAgentSymbolName();
    }

    synchronized boolean isAbleToSend() {
        return this.ableToSend;
    }

    synchronized void setIsAbleToSend(boolean bl) {
        this.ableToSend = bl;
    }

    synchronized URL getMessageUrl() {
        return this.messageUrl;
    }

    public synchronized void setupServer(Object object, IPC.MessageListener messageListener) {
        Debug.noteln("Setting up IServeCommunicationStrategy server.");
        this.messageListener = messageListener;
        this.agent = (Ip2)IXAgent.getAgent();
        String string = Parameters.getParameter("ipc-server");
        if (string == null) {
            Util.displayAndWait(null, "No ipc-server was given for the I-Serve communication strategy");
            return;
        }
        this.serverAddr = new ServiceAddress(string);
        this.messageUrl = this.httpUtil.makeMessageURL(this.serverAddr, "/iscs-message");
        this.agent.addTool(new IServeCommunicationTool.Controller(this));
    }

    void registerAs(String string) {
        Debug.expect(SwingUtilities.isEventDispatchThread(), "not in Swing");
        Debug.expect(!this.isAbleToSend(), "Registering when already registered");
        Debug.noteln("Trying to register as", (Object)string);
        MessageWrapper messageWrapper = new MessageWrapper(this.getAgentName(), "register-as", string);
        messageWrapper.setSeqNo(this.expectedSeqNo - 1);
        Object object = this.requestObject(messageWrapper);
        if (!object.equals("ok")) {
            throw new IPC.IPCException(object.toString());
        }
        this.transcript("Registered as " + string);
        this.agent.setAgentSymbolName(string);
        this.setIsAbleToSend(true);
        new ReceiveThread().start();
    }

    void serverUnavailable() {
        Util.swingAndWait(new Runnable(){

            public void run() {
                IServeCommunicationStrategy.this.tool.needToReregister();
            }
        });
    }

    protected void transcript(final String string) {
        Debug.noteln("Transcript:", (Object)string);
        Util.swingAndWait(new Runnable(){

            public void run() {
                IServeCommunicationStrategy.this.do_transcript(Reporting.dateString() + " " + string);
            }
        });
    }

    protected void do_transcript(String string) {
        this.tool.transcript(string);
    }

    public synchronized void sendObject(Object object, Object object2) {
        if (!this.isAbleToSend()) {
            throw new UnsupportedOperationException("Cannot send to " + object + " until you have registered with the message server.");
        }
        this.transcript("Sending to " + object + ": " + Reporting.description(object2));
        MessageWrapper messageWrapper = new MessageWrapper(this.getAgentName(), "send-to", object, object2);
        messageWrapper.setSendDate(new Date());
        try {
            Object object3 = this.requestObject(messageWrapper);
            Debug.noteln("Received", object3);
            if (!object3.equals("ok")) {
                throw new IPC.IPCException("Unexpected reply from message-server: " + object3);
            }
        }
        catch (RuntimeException runtimeException) {
            Debug.noteln("sendObject rethrowing", (Object)Debug.describeException(runtimeException));
            throw runtimeException;
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw new RethrownException(exception);
        }
    }

    protected Object requestObject(MessageWrapper messageWrapper) {
        try {
            return this.http.sendRequest(this.messageUrl, messageWrapper);
        }
        catch (RethrownIOException rethrownIOException) {
            Debug.noteException(rethrownIOException);
            throw this.interpretRequestException(rethrownIOException);
        }
    }

    RuntimeException interpretRequestException(RethrownIOException rethrownIOException) {
        return rethrownIOException;
    }

    static class ConnectFailure
    extends IPC.IPCException {
        ConnectFailure(String string) {
            super(string);
        }
    }

    class ReceiveThread
    extends Thread {
        String ourName;

        ReceiveThread() {
            this.ourName = IServeCommunicationStrategy.this.getAgentName();
        }

        public void run() {
            MessageWrapper messageWrapper = null;
            while (true) {
                try {
                    messageWrapper = this.nextMessage(messageWrapper);
                }
                catch (IPC.BrokenConnectionException brokenConnectionException) {
                    IServeCommunicationStrategy.this.transcript("Connection problem: " + Debug.describeException(brokenConnectionException));
                    Debug.displayException("Exception while waiting for input.  Probably means the message server has exited.  Another exception may follow.  This exception was", brokenConnectionException);
                    continue;
                }
                catch (ConnectFailure connectFailure) {
                    IServeCommunicationStrategy.this.setIsAbleToSend(false);
                    IServeCommunicationStrategy.this.transcript("Connection problem: " + Debug.describeException(connectFailure));
                    Debug.displayException(connectFailure);
                    IServeCommunicationStrategy.this.serverUnavailable();
                    return;
                }
                catch (Throwable throwable) {
                    IServeCommunicationStrategy.this.transcript("Receive failure: " + Debug.describeException(throwable));
                    Debug.displayException("Exception while waiting for input.  Probably a timeout that can be ignored.  The exception was", throwable);
                    continue;
                }
                try {
                    this.handleMessage(messageWrapper);
                    continue;
                }
                catch (Throwable throwable) {
                    IServeCommunicationStrategy.this.transcript(Debug.describeException(throwable));
                    Debug.displayException(throwable);
                    continue;
                }
                break;
            }
        }

        MessageWrapper nextMessage(MessageWrapper messageWrapper) {
            Object object;
            IServeCommunicationStrategy.this.transcript("Waiting for next message ...");
            MessageWrapper messageWrapper2 = new MessageWrapper(IServeCommunicationStrategy.this.getAgentName(), "get-message");
            if (messageWrapper != null) {
                messageWrapper2.setSeqNo(messageWrapper.getSeqNo());
            }
            if (!((object = IServeCommunicationStrategy.this.requestObject(messageWrapper2)) instanceof MessageWrapper)) {
                throw new ClassCastException("Received an instance of " + object.getClass().getName() + " instead of a MessageWrapper.");
            }
            MessageWrapper messageWrapper3 = (MessageWrapper)object;
            Debug.expect(messageWrapper3.getCommand().equals("send-to"));
            Debug.expect(messageWrapper3.getArg(0).equals(this.ourName));
            return messageWrapper3;
        }

        void handleMessage(MessageWrapper messageWrapper) {
            Integer n = messageWrapper.getSequenceNumber();
            int n2 = messageWrapper.getSeqNo();
            Debug.expect(n2 == n);
            if (n2 == IServeCommunicationStrategy.this.expectedSeqNo) {
                Debug.expect(!IServeCommunicationStrategy.this.messageMap.containsKey(n));
                ++IServeCommunicationStrategy.this.expectedSeqNo;
            } else if (n2 > IServeCommunicationStrategy.this.expectedSeqNo) {
                Debug.noteln("Missing messages between " + IServeCommunicationStrategy.this.expectedSeqNo + " and " + n2);
                IServeCommunicationStrategy.this.expectedSeqNo = n2 + 1;
            } else {
                Debug.expect(n2 < IServeCommunicationStrategy.this.expectedSeqNo);
                if (IServeCommunicationStrategy.this.messageMap.containsKey(n)) {
                    IServeCommunicationStrategy.this.transcript("Received " + n2 + " again");
                    return;
                }
                Debug.noteln("Received gap message", n2);
            }
            Object object = messageWrapper.getArg(1);
            IServeCommunicationStrategy.this.transcript("Received " + n2 + ": " + Reporting.description(object));
            IServeCommunicationStrategy.this.messageMap.remember(messageWrapper);
            IServeCommunicationStrategy.this.messageListener.messageReceived(new IPC.BasicInputMessage(object));
        }
    }
}

