/*
 * Decompiled with CFR 0.152.
 */
package ix.iserve.ipc;

import ix.iserve.ipc.MessageWrapper;
import ix.util.Debug;
import ix.util.Proc;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class MessageMemory {
    protected SortedMap seqNoToMessageMap = new TreeMap();

    public int size() {
        return this.seqNoToMessageMap.size();
    }

    public void remember(MessageWrapper messageWrapper) {
        Integer n = messageWrapper.getSequenceNumber();
        Debug.expect(!this.seqNoToMessageMap.containsKey(n));
        this.seqNoToMessageMap.put(n, messageWrapper);
    }

    public void forget(MessageWrapper messageWrapper) {
        this.forgetKey(messageWrapper.getSequenceNumber());
    }

    public void forgetKey(Integer n) {
        Debug.expect(this.seqNoToMessageMap.containsKey(n));
        this.seqNoToMessageMap.remove(n);
    }

    public boolean containsKey(Object object) {
        return this.seqNoToMessageMap.containsKey(object);
    }

    public Object firstKey() {
        return this.seqNoToMessageMap.firstKey();
    }

    public Object lastKey() {
        return this.seqNoToMessageMap.lastKey();
    }

    public MessageWrapper getFirstRemainingMessage() {
        return this.seqNoToMessageMap.isEmpty() ? null : (MessageWrapper)this.seqNoToMessageMap.get(this.seqNoToMessageMap.firstKey());
    }

    public void walkContents(Proc proc) {
        for (Map.Entry entry : this.seqNoToMessageMap.entrySet()) {
            proc.call(entry.getKey(), entry.getValue());
        }
    }
}

