/*
 * Decompiled with CFR 0.152.
 */
package ix.isim;

import ix.icore.IXAgent;
import ix.iface.util.ToolFrame;
import ix.isim.EventsTableModel;
import ix.isim.ISimEngine;
import ix.isim.ISimEventsFrame_clearMenuItem_actionAdapter;
import ix.isim.ISimEventsFrame_closeMenuItem_actionAdapter;
import ix.isim.ISimEventsFrame_loadMenuItem_actionAdapter;
import ix.isim.ISimEventsFrame_nextMenuItem_actionAdapter;
import ix.isim.ISimEventsFrame_pauseMenuItem_actionAdapter;
import ix.isim.ISimEventsFrame_resumeMenuItem_actionAdapter;
import ix.isim.ISimEventsFrame_startMenuItem_actionAdapter;
import ix.isim.StartSimDialog;
import ix.isim.util.LongPriorityQueue;
import ix.util.Debug;
import ix.util.FileExtensionFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;

public class ISimEventsFrame
extends ToolFrame {
    protected static JFileChooser fileSelect = new JFileChooser();
    protected ISimEngine simulator;
    JMenuBar mainMenu = new JMenuBar();
    JMenu fileMenu = new JMenu();
    JMenuItem loadMenuItem = new JMenuItem();
    JMenuItem closeMenuItem = new JMenuItem();
    JMenu simulationMenu = new JMenu();
    JMenuItem startMenuItem = new JMenuItem();
    JMenuItem pauseMenuItem = new JMenuItem();
    JMenuItem resumeMenuItem = new JMenuItem();
    JMenu eventsMenu = new JMenu();
    JMenuItem clearMenuItem = new JMenuItem();
    JMenuItem nextMenuItem = new JMenuItem();
    BorderLayout UILayout = new BorderLayout();
    JScrollPane tableScrollPane = new JScrollPane();
    JTable eventsTable = new JTable();
    EventsTableModel eventsTableModel;

    public ISimEventsFrame(ISimEngine iSimEngine) {
        this.simulator = iSimEngine;
        this.eventsTableModel = new EventsTableModel(iSimEngine);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle(IXAgent.getAgent().getAgentDisplayName() + " I-Sim Control");
        this.setSize(new Dimension(750, 600));
        this.loadMenuItem.setText("Load Timed Events ...");
        this.loadMenuItem.addActionListener(new ISimEventsFrame_loadMenuItem_actionAdapter(this));
        this.closeMenuItem.setText("Close");
        this.closeMenuItem.addActionListener(new ISimEventsFrame_closeMenuItem_actionAdapter(this));
        this.fileMenu.setText("File");
        this.fileMenu.add(this.loadMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.closeMenuItem);
        this.startMenuItem.setText("Start Simulation ...");
        this.startMenuItem.addActionListener(new ISimEventsFrame_startMenuItem_actionAdapter(this));
        this.pauseMenuItem.setText("Pause Simulation");
        this.pauseMenuItem.setEnabled(false);
        this.pauseMenuItem.addActionListener(new ISimEventsFrame_pauseMenuItem_actionAdapter(this));
        this.resumeMenuItem.setText("Resume Simulation");
        this.resumeMenuItem.setEnabled(false);
        this.resumeMenuItem.addActionListener(new ISimEventsFrame_resumeMenuItem_actionAdapter(this));
        this.simulationMenu.setText("Simulation");
        this.simulationMenu.add(this.startMenuItem);
        this.simulationMenu.add(this.pauseMenuItem);
        this.simulationMenu.add(this.resumeMenuItem);
        this.clearMenuItem.setText("Clear All Waiting");
        this.clearMenuItem.addActionListener(new ISimEventsFrame_clearMenuItem_actionAdapter(this));
        this.nextMenuItem.setText("Execute Next Now");
        this.nextMenuItem.addActionListener(new ISimEventsFrame_nextMenuItem_actionAdapter(this));
        this.eventsMenu.setText("Events");
        this.eventsMenu.add(this.clearMenuItem);
        this.eventsMenu.add(this.nextMenuItem);
        this.mainMenu.add(this.fileMenu);
        this.mainMenu.add(this.simulationMenu);
        this.mainMenu.add(this.eventsMenu);
        this.setJMenuBar(this.mainMenu);
        this.getContentPane().setLayout(this.UILayout);
        this.eventsTable.setModel(this.eventsTableModel);
        this.eventsTable.setAutoCreateColumnsFromModel(true);
        this.eventsTable.setAutoResizeMode(0);
        this.eventsTable.setRowHeight(16);
        this.eventsTable.setCellSelectionEnabled(false);
        this.eventsTable.setColumnSelectionAllowed(false);
        this.eventsTable.setRowSelectionAllowed(true);
        TableColumnModel tableColumnModel = this.eventsTable.getColumnModel();
        tableColumnModel.getColumn(0).setMinWidth(100);
        tableColumnModel.getColumn(0).setMaxWidth(100);
        tableColumnModel.getColumn(1).setMinWidth(100);
        tableColumnModel.getColumn(1).setMaxWidth(100);
        tableColumnModel.getColumn(2).setMinWidth(100);
        tableColumnModel.getColumn(3).setMinWidth(750);
        this.tableScrollPane.getViewport().setBackground(Color.white);
        this.tableScrollPane.getViewport().add(this.eventsTable);
        this.getContentPane().add((Component)this.tableScrollPane, "Center");
    }

    public void loadMenuItem_actionPerformed(ActionEvent actionEvent) {
        Debug.noteln("ISim action:", (Object)actionEvent.getActionCommand());
        if (fileSelect.showDialog(this, "Load") == 0) {
            this.simulator.loadTimedEvents(fileSelect.getSelectedFiles());
            Thread.currentThread();
            Thread.yield();
        }
    }

    public void closeMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public void startMenuItem_actionPerformed(ActionEvent actionEvent) {
        Debug.noteln("ISim action:", (Object)actionEvent.getActionCommand());
        StartSimDialog startSimDialog = new StartSimDialog(this, "Start Simulation", true);
        startSimDialog.show();
        if (startSimDialog.startSelected) {
            this.startMenuItem.setEnabled(false);
            this.simulator.startSimulation(startSimDialog.startTime, startSimDialog.acceleration);
            Thread.currentThread();
            Thread.yield();
            this.pauseMenuItem.setEnabled(true);
        }
    }

    public void pauseMenuItem_actionPerformed(ActionEvent actionEvent) {
        Debug.noteln("ISim action:", (Object)actionEvent.getActionCommand());
        this.pauseMenuItem.setEnabled(false);
        this.simulator.pauseSimulation();
        this.simulator.theISim.getISimTimer().pause();
        Thread.currentThread();
        Thread.yield();
        this.resumeMenuItem.setEnabled(true);
    }

    public void resumeMenuItem_actionPerformed(ActionEvent actionEvent) {
        Debug.noteln("ISim action:", (Object)actionEvent.getActionCommand());
        this.resumeMenuItem.setEnabled(false);
        this.simulator.theISim.getISimTimer().resume();
        this.simulator.resumeSimulation();
        Thread.currentThread();
        Thread.yield();
        this.pauseMenuItem.setEnabled(true);
    }

    public void clearMenuItem_actionPerformed(ActionEvent actionEvent) {
        Debug.noteln("ISim action:", (Object)actionEvent.getActionCommand());
        this.simulator.clearAllWaitingEvents();
    }

    public void nextMenuItem_actionPerformed(ActionEvent actionEvent) {
        Debug.noteln("ISim action:", (Object)actionEvent.getActionCommand());
        this.simulator.executeNextEvent();
    }

    public void makeRowsFromQueue(List list, List list2, LongPriorityQueue longPriorityQueue) {
        ((EventsTableModel)this.eventsTable.getModel()).makeRowsFromQueue(list, list2, longPriorityQueue);
        Thread.currentThread();
        Thread.yield();
    }

    static {
        fileSelect.setDialogTitle("Select events files");
        fileSelect.setCurrentDirectory(new File("./scenarios"));
        fileSelect.setFileFilter(new FileExtensionFileFilter("lsp"));
        fileSelect.setAcceptAllFileFilterUsed(false);
        fileSelect.setFileSelectionMode(0);
        fileSelect.setMultiSelectionEnabled(true);
    }
}

