/*
 * Decompiled with CFR 0.152.
 */
package ix.isim.actions;

import ix.ichat.ChatMessage;
import ix.icore.AbstractAnnotatedObject;
import ix.icore.Activity;
import ix.icore.Issue;
import ix.icore.Report;
import ix.icore.ReportType;
import ix.icore.domain.Constraint;
import ix.isim.ExecutableAction;
import ix.isim.SimulationException;
import ix.util.IPC;
import ix.util.Name;
import ix.util.lisp.LList;
import ix.util.lisp.Symbol;
import ix.util.match.MatchEnv;
import java.util.Iterator;
import java.util.List;

public class SendMessage
extends ExecutableAction {
    static final Symbol sendMessageSy = Symbol.intern("send-message");
    static final Symbol issueSy = Symbol.intern("issue");
    static final Symbol activitySy = Symbol.intern("activity");
    static final Symbol constraintSy = Symbol.intern("constraint");
    static final Symbol messageSy = Symbol.intern("message");
    static final Symbol reportSy = Symbol.intern("report");

    public void executeAction(MatchEnv matchEnv) throws SimulationException {
        if (!this.action.getActivity().getVerb().equals(sendMessageSy)) {
            throw new SimulationException("Activity verb must be " + sendMessageSy + ", not " + this.action.getActivity().getVerb());
        }
        Iterator iterator = this.action.getActivity().getParameters().iterator();
        Symbol symbol = (Symbol)iterator.next();
        Name name = Name.valueOf(iterator.next());
        String string = iterator.next().toString();
        AbstractAnnotatedObject abstractAnnotatedObject = null;
        if (symbol.equals(issueSy)) {
            abstractAnnotatedObject = new Issue((LList)iterator.next());
        } else if (symbol.equals(activitySy)) {
            abstractAnnotatedObject = new Activity((LList)iterator.next());
        } else if (symbol.equals(constraintSy)) {
            abstractAnnotatedObject = new Constraint((Symbol)iterator.next(), (Symbol)iterator.next(), (List)((LList)iterator.next()));
        } else if (symbol.equals(messageSy)) {
            abstractAnnotatedObject = new ChatMessage(iterator.next().toString(), name.toString());
        } else if (symbol.equals(reportSy)) {
            abstractAnnotatedObject = new Report(ReportType.valueOf(iterator.next().toString()), iterator.next().toString());
        }
        abstractAnnotatedObject.setSenderId(name);
        try {
            IPC.getCommunicationStrategy().sendObject(string, abstractAnnotatedObject);
        }
        catch (Exception exception) {
            throw new SimulationException("Unable to send message.");
        }
    }
}

