/*
 * Decompiled with CFR 0.152.
 */
package ix.isim.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class LongKeyTreeMap {
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    protected Entry root = null;
    private int size = 0;
    private int modCount = 0;

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int size() {
        return this.size;
    }

    public boolean containsKey(long l) {
        return this.getEntry(l) != null;
    }

    public Object get(long l) {
        Entry entry = this.getEntry(l);
        return entry == null ? null : entry.value;
    }

    public long firstKey() throws NoSuchElementException {
        if (this.root == null) {
            throw new NoSuchElementException();
        }
        return this.firstEntry().key;
    }

    public long lastKey() throws NoSuchElementException {
        if (this.root == null) {
            throw new NoSuchElementException();
        }
        return this.lastEntry().key;
    }

    public Object put(long l, Object object) {
        Entry entry = this.root;
        if (entry == null) {
            this.incrementSize();
            this.root = new Entry(l, object, null);
            return null;
        }
        while (true) {
            if (l == entry.key) {
                return entry.setValue(object);
            }
            if (l < entry.key) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                this.incrementSize();
                entry.left = new Entry(l, object, entry);
                this.fixAfterInsertion(entry.left);
                return null;
            }
            if (entry.right == null) break;
            entry = entry.right;
        }
        this.incrementSize();
        entry.right = new Entry(l, object, entry);
        this.fixAfterInsertion(entry.right);
        return null;
    }

    public Object remove(long l) {
        Entry entry = this.getEntry(l);
        if (entry == null) {
            return null;
        }
        Object object = entry.value;
        this.deleteEntry(entry);
        return object;
    }

    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = null;
    }

    public Iterator values() {
        return new LongKeyTreeMapIterator();
    }

    private void incrementSize() {
        ++this.modCount;
        ++this.size;
    }

    private void decrementSize() {
        ++this.modCount;
        --this.size;
    }

    private Entry getEntry(long l) {
        Entry entry = this.root;
        while (entry != null) {
            if (l == entry.key) {
                return entry;
            }
            entry = l < entry.key ? entry.left : entry.right;
        }
        return null;
    }

    private Entry firstEntry() {
        Entry entry = this.root;
        if (entry != null) {
            while (entry.left != null) {
                entry = entry.left;
            }
        }
        return entry;
    }

    private Entry lastEntry() {
        Entry entry = this.root;
        if (entry != null) {
            while (entry.right != null) {
                entry = entry.right;
            }
        }
        return entry;
    }

    private void deleteEntry(Entry entry) {
        Entry entry2;
        this.decrementSize();
        if (entry.left != null && entry.right != null) {
            entry2 = LongKeyTreeMap.successor(entry);
            this.swapPosition(entry2, entry);
        }
        Entry entry3 = entry2 = entry.left != null ? entry.left : entry.right;
        if (entry2 != null) {
            entry2.parent = entry.parent;
            if (entry.parent == null) {
                this.root = entry2;
            } else if (entry == entry.parent.left) {
                entry.parent.left = entry2;
            } else {
                entry.parent.right = entry2;
            }
            entry.parent = null;
            entry.right = null;
            entry.left = null;
            if (entry.color) {
                this.fixAfterDeletion(entry2);
            }
        } else if (entry.parent == null) {
            this.root = null;
        } else {
            if (entry.color) {
                this.fixAfterDeletion(entry);
            }
            if (entry.parent != null) {
                if (entry == entry.parent.left) {
                    entry.parent.left = null;
                } else if (entry == entry.parent.right) {
                    entry.parent.right = null;
                }
                entry.parent = null;
            }
        }
    }

    private void swapPosition(Entry entry, Entry entry2) {
        boolean bl;
        Entry entry3 = entry.parent;
        Entry entry4 = entry.left;
        Entry entry5 = entry.right;
        Entry entry6 = entry2.parent;
        Entry entry7 = entry2.left;
        Entry entry8 = entry2.right;
        boolean bl2 = entry3 != null && entry == entry3.left;
        boolean bl3 = bl = entry6 != null && entry2 == entry6.left;
        if (entry == entry6) {
            entry.parent = entry2;
            if (bl) {
                entry2.left = entry;
                entry2.right = entry5;
            } else {
                entry2.right = entry;
                entry2.left = entry4;
            }
        } else {
            entry.parent = entry6;
            if (entry6 != null) {
                if (bl) {
                    entry6.left = entry;
                } else {
                    entry6.right = entry;
                }
            }
            entry2.left = entry4;
            entry2.right = entry5;
        }
        if (entry2 == entry3) {
            entry2.parent = entry;
            if (bl2) {
                entry.left = entry2;
                entry.right = entry8;
            } else {
                entry.right = entry2;
                entry.left = entry7;
            }
        } else {
            entry2.parent = entry3;
            if (entry3 != null) {
                if (bl2) {
                    entry3.left = entry2;
                } else {
                    entry3.right = entry2;
                }
            }
            entry.left = entry7;
            entry.right = entry8;
        }
        if (entry.left != null) {
            entry.left.parent = entry;
        }
        if (entry.right != null) {
            entry.right.parent = entry;
        }
        if (entry2.left != null) {
            entry2.left.parent = entry2;
        }
        if (entry2.right != null) {
            entry2.right.parent = entry2;
        }
        boolean bl4 = entry.color;
        entry.color = entry2.color;
        entry2.color = bl4;
        if (this.root == entry) {
            this.root = entry2;
        } else if (this.root == entry2) {
            this.root = entry;
        }
    }

    private void rotateLeft(Entry entry) {
        Entry entry2 = entry.right;
        entry.right = entry2.left;
        if (entry2.left != null) {
            entry2.left.parent = entry;
        }
        entry2.parent = entry.parent;
        if (entry.parent == null) {
            this.root = entry2;
        } else if (entry.parent.left == entry) {
            entry.parent.left = entry2;
        } else {
            entry.parent.right = entry2;
        }
        entry2.left = entry;
        entry.parent = entry2;
    }

    private void rotateRight(Entry entry) {
        Entry entry2 = entry.left;
        entry.left = entry2.right;
        if (entry2.right != null) {
            entry2.right.parent = entry;
        }
        entry2.parent = entry.parent;
        if (entry.parent == null) {
            this.root = entry2;
        } else if (entry.parent.right == entry) {
            entry.parent.right = entry2;
        } else {
            entry.parent.left = entry2;
        }
        entry2.right = entry;
        entry.parent = entry2;
    }

    private void fixAfterInsertion(Entry entry) {
        entry.color = false;
        while (entry != null && entry != this.root && !entry.parent.color) {
            Entry entry2;
            if (LongKeyTreeMap.parentOf(entry) == LongKeyTreeMap.leftOf(LongKeyTreeMap.parentOf(LongKeyTreeMap.parentOf(entry)))) {
                entry2 = LongKeyTreeMap.rightOf(LongKeyTreeMap.parentOf(LongKeyTreeMap.parentOf(entry)));
                if (!LongKeyTreeMap.colorOf(entry2)) {
                    LongKeyTreeMap.setColor(LongKeyTreeMap.parentOf(entry), true);
                    LongKeyTreeMap.setColor(entry2, true);
                    LongKeyTreeMap.setColor(LongKeyTreeMap.parentOf(LongKeyTreeMap.parentOf(entry)), false);
                    entry = LongKeyTreeMap.parentOf(LongKeyTreeMap.parentOf(entry));
                    continue;
                }
                if (entry == LongKeyTreeMap.rightOf(LongKeyTreeMap.parentOf(entry))) {
                    entry = LongKeyTreeMap.parentOf(entry);
                    this.rotateLeft(entry);
                }
                LongKeyTreeMap.setColor(LongKeyTreeMap.parentOf(entry), true);
                LongKeyTreeMap.setColor(LongKeyTreeMap.parentOf(LongKeyTreeMap.parentOf(entry)), false);
                if (LongKeyTreeMap.parentOf(LongKeyTreeMap.parentOf(entry)) == null) continue;
                this.rotateRight(LongKeyTreeMap.parentOf(LongKeyTreeMap.parentOf(entry)));
                continue;
            }
            entry2 = LongKeyTreeMap.leftOf(LongKeyTreeMap.parentOf(LongKeyTreeMap.parentOf(entry)));
            if (!LongKeyTreeMap.colorOf(entry2)) {
                LongKeyTreeMap.setColor(LongKeyTreeMap.parentOf(entry), true);
                LongKeyTreeMap.setColor(entry2, true);
                LongKeyTreeMap.setColor(LongKeyTreeMap.parentOf(LongKeyTreeMap.parentOf(entry)), false);
                entry = LongKeyTreeMap.parentOf(LongKeyTreeMap.parentOf(entry));
                continue;
            }
            if (entry == LongKeyTreeMap.leftOf(LongKeyTreeMap.parentOf(entry))) {
                entry = LongKeyTreeMap.parentOf(entry);
                this.rotateRight(entry);
            }
            LongKeyTreeMap.setColor(LongKeyTreeMap.parentOf(entry), true);
            LongKeyTreeMap.setColor(LongKeyTreeMap.parentOf(LongKeyTreeMap.parentOf(entry)), false);
            if (LongKeyTreeMap.parentOf(LongKeyTreeMap.parentOf(entry)) == null) continue;
            this.rotateLeft(LongKeyTreeMap.parentOf(LongKeyTreeMap.parentOf(entry)));
        }
        this.root.color = true;
    }

    private void fixAfterDeletion(Entry entry) {
        while (entry != this.root && LongKeyTreeMap.colorOf(entry)) {
            Entry entry2;
            if (entry == LongKeyTreeMap.leftOf(LongKeyTreeMap.parentOf(entry))) {
                entry2 = LongKeyTreeMap.rightOf(LongKeyTreeMap.parentOf(entry));
                if (!LongKeyTreeMap.colorOf(entry2)) {
                    LongKeyTreeMap.setColor(entry2, true);
                    LongKeyTreeMap.setColor(LongKeyTreeMap.parentOf(entry), false);
                    this.rotateLeft(LongKeyTreeMap.parentOf(entry));
                    entry2 = LongKeyTreeMap.rightOf(LongKeyTreeMap.parentOf(entry));
                }
                if (LongKeyTreeMap.colorOf(LongKeyTreeMap.leftOf(entry2)) && LongKeyTreeMap.colorOf(LongKeyTreeMap.rightOf(entry2))) {
                    LongKeyTreeMap.setColor(entry2, false);
                    entry = LongKeyTreeMap.parentOf(entry);
                    continue;
                }
                if (LongKeyTreeMap.colorOf(LongKeyTreeMap.rightOf(entry2))) {
                    LongKeyTreeMap.setColor(LongKeyTreeMap.leftOf(entry2), true);
                    LongKeyTreeMap.setColor(entry2, false);
                    this.rotateRight(entry2);
                    entry2 = LongKeyTreeMap.rightOf(LongKeyTreeMap.parentOf(entry));
                }
                LongKeyTreeMap.setColor(entry2, LongKeyTreeMap.colorOf(LongKeyTreeMap.parentOf(entry)));
                LongKeyTreeMap.setColor(LongKeyTreeMap.parentOf(entry), true);
                LongKeyTreeMap.setColor(LongKeyTreeMap.rightOf(entry2), true);
                this.rotateLeft(LongKeyTreeMap.parentOf(entry));
                entry = this.root;
                continue;
            }
            entry2 = LongKeyTreeMap.leftOf(LongKeyTreeMap.parentOf(entry));
            if (!LongKeyTreeMap.colorOf(entry2)) {
                LongKeyTreeMap.setColor(entry2, true);
                LongKeyTreeMap.setColor(LongKeyTreeMap.parentOf(entry), false);
                this.rotateRight(LongKeyTreeMap.parentOf(entry));
                entry2 = LongKeyTreeMap.leftOf(LongKeyTreeMap.parentOf(entry));
            }
            if (LongKeyTreeMap.colorOf(LongKeyTreeMap.rightOf(entry2)) && LongKeyTreeMap.colorOf(LongKeyTreeMap.leftOf(entry2))) {
                LongKeyTreeMap.setColor(entry2, false);
                entry = LongKeyTreeMap.parentOf(entry);
                continue;
            }
            if (LongKeyTreeMap.colorOf(LongKeyTreeMap.leftOf(entry2))) {
                LongKeyTreeMap.setColor(LongKeyTreeMap.rightOf(entry2), true);
                LongKeyTreeMap.setColor(entry2, false);
                this.rotateLeft(entry2);
                entry2 = LongKeyTreeMap.leftOf(LongKeyTreeMap.parentOf(entry));
            }
            LongKeyTreeMap.setColor(entry2, LongKeyTreeMap.colorOf(LongKeyTreeMap.parentOf(entry)));
            LongKeyTreeMap.setColor(LongKeyTreeMap.parentOf(entry), true);
            LongKeyTreeMap.setColor(LongKeyTreeMap.leftOf(entry2), true);
            this.rotateRight(LongKeyTreeMap.parentOf(entry));
            entry = this.root;
        }
        LongKeyTreeMap.setColor(entry, true);
    }

    private static Entry successor(Entry entry) {
        if (entry == null) {
            return null;
        }
        if (entry.right != null) {
            Entry entry2 = entry.right;
            while (entry2.left != null) {
                entry2 = entry2.left;
            }
            return entry2;
        }
        Entry entry3 = entry.parent;
        Entry entry4 = entry;
        while (entry3 != null && entry4 == entry3.right) {
            entry4 = entry3;
            entry3 = entry3.parent;
        }
        return entry3;
    }

    private static boolean colorOf(Entry entry) {
        return entry == null ? true : entry.color;
    }

    private static Entry parentOf(Entry entry) {
        return entry == null ? null : entry.parent;
    }

    private static void setColor(Entry entry, boolean bl) {
        if (entry != null) {
            entry.color = bl;
        }
    }

    private static Entry leftOf(Entry entry) {
        return entry == null ? null : entry.left;
    }

    private static Entry rightOf(Entry entry) {
        return entry == null ? null : entry.right;
    }

    static class Entry {
        protected long key;
        protected Object value;
        protected Entry left = null;
        protected Entry right = null;
        protected Entry parent;
        protected boolean color = true;

        Entry(long l, Object object, Entry entry) {
            this.key = l;
            this.value = object;
            this.parent = entry;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            Entry entry = (Entry)object;
            return this.key == entry.key && (this.value == null ? entry.value == null : this.value.equals(entry.value));
        }

        public int hashCode() {
            int n = (int)this.key;
            int n2 = this.value == null ? 0 : this.value.hashCode();
            return n ^ n2;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    class LongKeyTreeMapIterator
    implements Iterator {
        protected Entry next;

        public LongKeyTreeMapIterator() {
            this.next = LongKeyTreeMap.this.firstEntry();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object object = this.next.value;
            this.next = LongKeyTreeMap.successor(this.next);
            return object;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

