/*
 * Decompiled with CFR 0.152.
 */
package ix.isim.util;

import ix.isim.util.LongKeyTreeMap;
import ix.isim.util.LongPriorityQueue;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class TreeOfListsLongPriorityQueue
implements LongPriorityQueue {
    protected LongKeyTreeMap pTree = new LongKeyTreeMap();
    private int size = 0;

    public TreeOfListsLongPriorityQueue() {
    }

    public TreeOfListsLongPriorityQueue(Object object, long l) {
        this.addElementAtEnd(object, l);
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public synchronized void addElementAtFront(Object object, long l) {
        this.addTreeList(l).addFirst(object);
        ++this.size;
    }

    public synchronized void addElementAtEnd(Object object, long l) {
        this.addTreeList(l).addLast(object);
        ++this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int length() {
        return this.size;
    }

    public boolean containsElementAt(Object object, long l) {
        throw new UnsupportedOperationException();
    }

    public Object getLowestFront() throws NoSuchElementException {
        if (this.size == 0) {
            throw new NoSuchElementException("Priority queue is empty!");
        }
        return ((LinkedList)this.pTree.get(this.pTree.firstKey())).getFirst();
    }

    public Object getLowestEnd() throws NoSuchElementException {
        if (this.size == 0) {
            throw new NoSuchElementException("Priority queue is empty!");
        }
        return ((LinkedList)this.pTree.get(this.pTree.firstKey())).getLast();
    }

    public Object getHighestFront() throws NoSuchElementException {
        if (this.size == 0) {
            throw new NoSuchElementException("Priority queue is empty!");
        }
        return ((LinkedList)this.pTree.get(this.pTree.lastKey())).getFirst();
    }

    public Object getHighestEnd() throws NoSuchElementException {
        if (this.size == 0) {
            throw new NoSuchElementException("Priority queue is empty!");
        }
        return ((LinkedList)this.pTree.get(this.pTree.lastKey())).getLast();
    }

    public synchronized Object removeLowestFront() throws NoSuchElementException {
        if (this.size == 0) {
            throw new NoSuchElementException("Priority queue is empty!");
        }
        --this.size;
        return this.removeLowestTreeList().removeFirst();
    }

    public synchronized Object removeLowestEnd() throws NoSuchElementException {
        if (this.size == 0) {
            throw new NoSuchElementException("Priority queue is empty!");
        }
        --this.size;
        return this.removeLowestTreeList().removeLast();
    }

    public synchronized Object removeHighestFront() throws NoSuchElementException {
        if (this.size == 0) {
            throw new NoSuchElementException("Priority queue is empty!");
        }
        --this.size;
        return this.removeHighestTreeList().removeFirst();
    }

    public synchronized Object removeHighestEnd() throws NoSuchElementException {
        if (this.size == 0) {
            throw new NoSuchElementException("Priority queue is empty!");
        }
        --this.size;
        return this.removeHighestTreeList().removeLast();
    }

    public boolean removeElementAt(Object object, long l) {
        throw new UnsupportedOperationException();
    }

    public Iterator elements() {
        return new TreeOfListsLongPriorityQueueIterator();
    }

    public String toString() {
        String string = "[";
        Iterator iterator = this.elements();
        if (iterator.hasNext()) {
            string = string + iterator.next().toString();
        }
        while (iterator.hasNext()) {
            string = string + " " + iterator.next().toString();
        }
        return string + "]";
    }

    public boolean equals(Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public int hashCode() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private LinkedList addTreeList(long l) {
        LinkedList linkedList = (LinkedList)this.pTree.get(l);
        if (linkedList == null) {
            linkedList = new LinkedList();
            this.pTree.put(l, linkedList);
        }
        return linkedList;
    }

    private LinkedList removeLowestTreeList() {
        long l = this.pTree.firstKey();
        LinkedList linkedList = (LinkedList)this.pTree.get(l);
        if (linkedList.size() == 1) {
            this.pTree.remove(l);
        }
        return linkedList;
    }

    private LinkedList removeHighestTreeList() {
        long l = this.pTree.lastKey();
        LinkedList linkedList = (LinkedList)this.pTree.get(l);
        if (linkedList.size() == 1) {
            this.pTree.remove(l);
        }
        return linkedList;
    }

    private class TreeOfListsLongPriorityQueueIterator
    implements Iterator {
        Iterator listElts;
        Iterator treeElts;

        TreeOfListsLongPriorityQueueIterator() {
            this.treeElts = TreeOfListsLongPriorityQueue.this.pTree.values();
            this.listElts = this.treeElts.hasNext() ? ((LinkedList)this.treeElts.next()).iterator() : null;
        }

        public boolean hasNext() {
            if (this.listElts == null) {
                return false;
            }
            return this.listElts.hasNext();
        }

        public Object next() throws NoSuchElementException {
            if (this.listElts == null) {
                throw new NoSuchElementException();
            }
            Object e = this.listElts.next();
            if (this.listElts.hasNext()) {
                return e;
            }
            if (this.treeElts.hasNext()) {
                this.listElts = ((LinkedList)this.treeElts.next()).iterator();
            }
            return e;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

