/*
 * Decompiled with CFR 0.152.
 */
package ix.itest;

import ix.ichat.ChatMessage;
import ix.icore.Annotated;
import ix.icore.IXAgent;
import ix.icore.Sendable;
import ix.iface.util.Reporting;
import ix.iface.util.TranscriptTextPane;
import ix.ispace.ContactManager;
import ix.util.IPC;
import ix.util.lisp.Symbol;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ReceivePanel
extends JPanel {
    private static Symbol MESSAGE_COLOR = Symbol.intern("message-color");
    IXAgent agent;
    ContactManager contactManager;
    TranscriptTextPane transcript = new TranscriptTextPane();

    public ReceivePanel(IXAgent iXAgent) {
        this.agent = iXAgent;
        this.contactManager = iXAgent.getContactManager();
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createTitledBorder("Transcript"));
        this.transcript.setPreferredSize(new Dimension(400, 150));
        this.add(new JScrollPane(this.transcript));
    }

    public void handleInput(IPC.InputMessage inputMessage) {
        this.transcript.appendLine(this.senderColor(inputMessage.getContents()), Reporting.messageDescription(inputMessage));
    }

    public void newMessage(ChatMessage chatMessage) {
        Color color = this.senderColor(chatMessage);
        this.transcript.appendLine(color, chatMessage.getSenderId() + " at " + Reporting.dateString() + ":");
        this.transcript.appendIndentedLines(3, color, chatMessage.getText());
    }

    protected Color senderColor(Object object) {
        Color color = Color.black;
        Color color2 = null;
        String string = null;
        if (object instanceof Annotated) {
            color2 = (Color)((Annotated)object).getAnnotation(MESSAGE_COLOR);
        }
        if (object instanceof Sendable) {
            string = ((Sendable)object).getSenderId().toString();
        }
        if (color2 != null) {
            if (string != null) {
                this.contactManager.setAgentColor(string, color2);
            }
            return color2;
        }
        if (string != null) {
            color2 = this.contactManager.getAgentColor(string);
        }
        return color2 != null ? color2 : color;
    }
}

