/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.IXObject;
import ix.icore.domain.Domain;
import ix.icore.domain.Named;
import ix.icore.domain.ObjectClass;
import ix.icore.domain.Refinement;
import ix.iface.ui.AbstractSetEditor;
import ix.iface.ui.EditableObject;
import ix.iview.DomainObjectManager;
import ix.iview.domain.DomainReferenceException;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UIObject;
import ix.iview.util.IVUtil;
import ix.util.Debug;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;

public abstract class AbstractUISetEditor
extends AbstractSetEditor {
    public AbstractUISetEditor(DomainObjectManager domainObjectManager, LinkedList linkedList) {
        super(domainObjectManager, linkedList);
    }

    public void setManager(DomainObjectManager domainObjectManager, LinkedList linkedList) {
        super.setManager(domainObjectManager, linkedList);
    }

    public void setObjects(LinkedList linkedList) {
        this.clear();
        this.members.clear();
        if (linkedList == null) {
            return;
        }
        for (Named named : linkedList) {
            this.members.put(named.getName(), named);
        }
    }

    public Domain getDomain() {
        return ((DomainObjectManager)this.manager).getDomain();
    }

    public UIDomain getUIDomain() {
        return ((DomainObjectManager)this.manager).getUIDomain();
    }

    public Object getOriginal(Object object) {
        if (object instanceof UIObject) {
            return ((UIObject)object).getOriginal();
        }
        return super.getOriginal(object);
    }

    public void setOriginal(Object object, Object object2) {
        super.setOriginal(object, object2);
        try {
            UIObject uIObject = (UIObject)object;
            uIObject.setBaseReference(this.getName(object2));
            uIObject.setBaseObject((IXObject)this.cloneConstruct(object2));
        }
        catch (Exception exception) {
            Debug.noteException(exception);
        }
    }

    public void rememberClear() {
        this.clear();
        this.members.clear();
        this.removed.addAll(this.getOriginals());
    }

    public String getName(Object object) {
        if (object instanceof Named) {
            return ((Named)object).getName();
        }
        return "";
    }

    public void setName(Object object, String string) {
        if (object instanceof EditableObject) {
            ((EditableObject)object).setValue("name", string);
        }
    }

    public Named getAnyNamedObject(String string) {
        if (string == "") {
            return null;
        }
        Named named = (Named)this.findOwnObject(string);
        if (named != null) {
            return named;
        }
        named = this.getStringOriginal(string);
        if (!this.isCurrentNamedObject(named)) {
            named = null;
        }
        return named;
    }

    public Named getNamedObject(String string) {
        if (string == "") {
            return null;
        }
        Named named = (Named)this.findOwnObject(string);
        if (named != null) {
            return named;
        }
        named = this.getStringOriginal(string);
        if (!this.isCurrentNamedObject(named) || !string.equals(named.getName())) {
            named = null;
        }
        return named;
    }

    public abstract Named getStringOriginal(String var1);

    public void loadOriginal(Object object) {
        super.loadOriginal(object);
        ((UIObject)object).setBaseReference(this.getName(object));
    }

    public boolean hasOriginal(Named named) {
        if (named instanceof UIObject) {
            return ((UIObject)named).hasOriginal();
        }
        return false;
    }

    public boolean isEmpty(Object object) {
        if (object instanceof UIObject) {
            return ((UIObject)object).isEmpty();
        }
        return false;
    }

    public boolean isUndefined(Object object) {
        if (object instanceof UIObject) {
            return ((UIObject)object).isUndefined();
        }
        return true;
    }

    public IXObject getBaseObject(Named named) {
        if (named instanceof UIObject) {
            return ((UIObject)named).getBaseObject();
        }
        return null;
    }

    public Object cloneConstruct(Object object) throws CloneNotSupportedException {
        if (object instanceof Refinement) {
            return ((Refinement)object).clone();
        }
        if (object instanceof ObjectClass) {
            return ((ObjectClass)object).clone();
        }
        return null;
    }

    public void saveToDomain(Domain domain) {
        String string = "";
        try {
            for (Object e : this.removed) {
                try {
                    if (e != null && e instanceof UIObject) {
                        ((UIObject)e).removeFromDomain(domain);
                        continue;
                    }
                    this.removeFromDomain(domain, e);
                }
                catch (Exception exception) {
                    Debug.noteException(exception);
                }
            }
            for (Object e : this.added) {
                if (!(e instanceof UIObject) || ((UIObject)e).isEmpty()) continue;
                ((UIObject)e).addToDomain(domain);
            }
            for (Object e : this.edited) {
                if (e == null || !(e instanceof UIObject)) continue;
                ((UIObject)e).updateInDomain(domain);
            }
        }
        catch (DomainReferenceException domainReferenceException) {
            Debug.noteln(Debug.foldException(domainReferenceException));
            string = Debug.foldException(domainReferenceException);
        }
        if (string != "") {
            JOptionPane.showMessageDialog(null, "Last exception saving to domain (there may be more): " + string);
        }
    }

    public void removeFromDomain(Domain domain, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Refinement) {
            domain.deleteNamedRefinement(((Refinement)object).getName());
        } else if (object instanceof ObjectClass) {
            domain.deleteNamedObjectClass(((ObjectClass)object).getName());
        }
    }

    public List collectConstructChanges() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.hasChangedConstructs()) {
            arrayList.add("Changes in " + this.label);
            if (!this.added.isEmpty()) {
                arrayList.add(" Added: " + IVUtil.namedListToDisplay(this.added));
            }
            if (!this.removed.isEmpty()) {
                arrayList.add(" Removed: " + IVUtil.namedListToDisplay(this.removed));
            }
            if (!this.edited.isEmpty()) {
                arrayList.add(" Edited: " + IVUtil.namedListToDisplay(this.edited));
            }
        }
        return arrayList;
    }

    public void fireConstructRemoved(Object object) {
        if (object instanceof UIObject) {
            this.manager.fireConstructRemoved(this, (UIObject)object);
        } else {
            Debug.noteln("UISE: Deleted object without UI version. Not firing.", object);
        }
    }
}

