/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.iface.ui.EditableObject;
import ix.iface.ui.GenericIFormModel;
import ix.iview.DomainEditorFrame;
import ix.iview.domain.UIRefinement;
import ix.iview.util.IDEUtil;
import ix.util.Debug;
import java.util.List;

public class ActionFormModel
extends GenericIFormModel {
    private static String miniC = "miniConstraints";
    private final DomainEditorFrame ideFrame;

    public ActionFormModel(DomainEditorFrame domainEditorFrame) {
        super(UIRefinement.class);
        this.ideFrame = domainEditorFrame;
    }

    public ActionFormModel(DomainEditorFrame domainEditorFrame, Class clazz) {
        super(clazz);
        this.ideFrame = domainEditorFrame;
    }

    public ActionFormModel(DomainEditorFrame domainEditorFrame, EditableObject editableObject) {
        super(editableObject);
        this.ideFrame = domainEditorFrame;
    }

    protected Class deriveClass(String string) {
        if (string.equals(miniC)) {
            return String.class;
        }
        if (string.equals("conditions")) {
            return super.deriveClass("constraints");
        }
        if (string.equals("constraints")) {
            return super.deriveClass("constraints");
        }
        return super.deriveClass(string);
    }

    protected String deriveName(String string) {
        if (string.equals(miniC)) {
            return "Orderings";
        }
        if (string.equals("conditions")) {
            return "Conditions/Effects";
        }
        if (string.equals("constraints")) {
            return "Other Constraints";
        }
        return super.deriveName(string);
    }

    protected List deriveDisplayFields() {
        List list = super.deriveDisplayFields();
        list.add(miniC);
        list.add("conditions");
        list.add("constraints");
        return list;
    }

    public Object getValue(String string) {
        if (this.baseObject == null) {
            Debug.noteln("Cannot get value for a null base object.");
            return null;
        }
        if (string.equals(miniC)) {
            UIRefinement uIRefinement = (UIRefinement)this.baseObject;
            return uIRefinement.getOrderingType();
        }
        if (string.equals("orderings") && this.isFieldShowing(miniC)) {
            UIRefinement uIRefinement = (UIRefinement)this.baseObject;
            return uIRefinement.getOrderingType();
        }
        if (string.equals("conditions")) {
            UIRefinement uIRefinement = (UIRefinement)this.baseObject;
            return uIRefinement.getConditions();
        }
        if (string.equals("constraints")) {
            UIRefinement uIRefinement = (UIRefinement)this.baseObject;
            return this.getOtherConstraints(uIRefinement);
        }
        return super.getValue(string);
    }

    public double getFieldWeight(String string) {
        if (string.equals(miniC) || string.equals("pattern")) {
            return 0.1;
        }
        return super.getFieldWeight(string);
    }

    public String getFieldName(String string) {
        if (string.equals("name")) {
            return "Name  ";
        }
        return super.getFieldName(string);
    }

    private List getOtherConstraints(UIRefinement uIRefinement) {
        if (IDEUtil.showConditions(this.ideFrame.preferredConstraints)) {
            return uIRefinement.getOtherConstraints();
        }
        return uIRefinement.getConstraints();
    }

    private void setOtherConstraints(UIRefinement uIRefinement, List list) {
        if (IDEUtil.showConditions(this.ideFrame.preferredConstraints)) {
            uIRefinement.setOtherConstraints(list);
        } else {
            uIRefinement.setConstraints(list);
        }
    }

    public boolean setValue(EditableObject editableObject, String string, Object object) {
        if (string.equals(miniC)) {
            try {
                List list = ((UIRefinement)editableObject).getOrderings();
                ((UIRefinement)editableObject).setOrderingType((String)object);
                List list2 = ((UIRefinement)editableObject).getOrderings();
                if (!((UIRefinement)editableObject).sameValue("orderings", list, list2)) {
                    this.fireDataChanged(string, editableObject, list, list2);
                }
                return true;
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                return false;
            }
        }
        if (string.equals("constraints")) {
            UIRefinement uIRefinement = (UIRefinement)editableObject;
            this.setOtherConstraints(uIRefinement, (List)object);
            return true;
        }
        return super.setValue(editableObject, string, object);
    }
}

