/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.IXAgent;
import ix.icore.IXObject;
import ix.icore.domain.Domain;
import ix.icore.domain.Refinement;
import ix.icore.domain.event.DomainListener;
import ix.icore.domain.event.RefinementEvent;
import ix.iface.domain.DomainParser;
import ix.iface.ui.JPropertiesManager;
import ix.iface.ui.PropertiesApplication;
import ix.iface.ui.util.UIUtil;
import ix.iview.DomainEditorFrame;
import ix.iview.IDEPropertiesManager;
import ix.iview.IDESymbols;
import ix.iview.InternalDomainEditor;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UIObject;
import ix.iview.util.IVUtil;
import ix.test.SimpleIXAgent;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.Strings;
import ix.util.xml.XML;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.JFrame;

public class DomainEditor
implements DomainListener,
PropertyChangeListener,
InternalDomainEditor,
IDESymbols,
PropertiesApplication {
    protected IXAgent agent;
    public DomainEditorFrame deFrame;
    protected JPropertiesManager propMan;
    private boolean standAlone = false;
    private boolean isEditable = true;
    public File directory = DomainParser.getLibraryDirectory();
    public UIDomain uiDomain = new UIDomain(new Domain(), this);
    private boolean adjustingDomain = false;
    private boolean adjustingMode = false;
    private boolean adjustingView = false;

    public DomainEditor() {
        this(false, true);
    }

    public DomainEditor(boolean bl, boolean bl2) {
        this(bl2);
        this.deFrame.setSimpleMode(bl);
        this.deFrame.activateUndo();
    }

    public DomainEditor(boolean bl) {
        this(new Domain(), bl);
    }

    public DomainEditor(Domain domain) {
        this(domain, true);
    }

    public DomainEditor(Domain domain, boolean bl) {
        IVUtil.printIDEReleaseGreeting();
        this.standAlone = bl;
        this.ensurePropertiesManager();
        this.propMan.initProperties();
        this.deFrame = new DomainEditorFrame(this, bl);
        this.deFrame.setupFrame();
        this.setDomain(domain);
        this.deFrame.postInitPanels();
    }

    public DomainEditor(IXAgent iXAgent, Domain domain) {
        this(domain, false);
        this.agent = iXAgent;
        this.deFrame.makeTitle(iXAgent);
    }

    public String getName() {
        if (this.deFrame == null) {
            return "I-DE";
        }
        return this.deFrame.getName();
    }

    public JFrame getFrame() {
        return this.deFrame;
    }

    public String getProperty(String string) {
        if (string == null || string == "") {
            return "";
        }
        if (string.equals("ideMode")) {
            if (this.deFrame != null && !this.deFrame.isSimple()) {
                return MODE_ADVANCED.toString();
            }
            return MODE_SIMPLE.toString();
        }
        if (string.equals("ideEditable")) {
            return new Boolean(this.isEditable).toString();
        }
        if (this.deFrame == null) {
            return null;
        }
        if (string.equals("idePanelStyle")) {
            return this.deFrame.preferredStyle;
        }
        if (string.equals("ideActivityView")) {
            return this.deFrame.preferredView.toString();
        }
        if (string.equals("ideShowButtonTexts")) {
            return new Boolean(this.deFrame.showButtonTexts).toString();
        }
        if (string.equals("ideNewCondEditor")) {
            return new Boolean(this.deFrame.useNewCondEd).toString();
        }
        if (string.equals("ideListsAsTexts")) {
            return new Boolean(this.deFrame.listsAsText).toString();
        }
        if (string.equals("ideConstraints")) {
            return this.deFrame.preferredConstraints.toString();
        }
        if (string.equals("ideX")) {
            return UIUtil.intToProperty(this.deFrame.getX());
        }
        if (string.equals("ideY")) {
            return UIUtil.intToProperty(this.deFrame.getY());
        }
        if (string.equals("ideWidth")) {
            return UIUtil.intToProperty(this.deFrame.getWidth());
        }
        if (string.equals("ideHeight")) {
            return UIUtil.intToProperty(this.deFrame.getHeight());
        }
        if (string.equals("ideBounds")) {
            return "";
        }
        Debug.noteln("****Warning**** IDE: cannot recognise property", (Object)string);
        return "";
    }

    public void setProperty(String string, String string2) {
        if (string == null || string == "") {
            return;
        }
        if (string.equals("ideEditable")) {
            this.isEditable = UIUtil.propertyToBoolean(string2);
            if (this.deFrame != null) {
                this.deFrame.setEditable(this.isEditable);
            }
        } else {
            if (this.deFrame == null) {
                return;
            }
            if (string.equals("idePanelStyle")) {
                this.deFrame.setPanelStyle(string2);
            } else if (string.equals("ideActivityView")) {
                this.deFrame.setActivityView(UIUtil.propertyToSymbol(string2));
            } else if (string.equals("ideShowButtonTexts")) {
                this.deFrame.updateToolbar(UIUtil.propertyToBoolean(string2));
            } else if (string.equals("ideNewCondEditor")) {
                this.deFrame.useNewCondEditor(UIUtil.propertyToBoolean(string2));
            } else if (string.equals("ideListsAsTexts")) {
                this.deFrame.showListsAsTexts(UIUtil.propertyToBoolean(string2));
            } else if (string.equals("ideConstraints")) {
                this.deFrame.setConstraintsView(UIUtil.propertyToSymbol(string2));
            } else if (string.equals("ideMode")) {
                this.deFrame.setMode(UIUtil.propertyToSymbol(string2));
            } else if (string.equals("ideBounds")) {
                this.deFrame.setBoundsFromProperties();
            } else if (!(string.equals("ideX") || string.equals("ideY") || string.equals("ideWidth") || string.equals("ideHeight"))) {
                Debug.noteln("****Warning**** IDE: cannot recognise property", (Object)string);
            }
        }
    }

    public void setEditable(boolean bl) {
        this.isEditable = bl;
    }

    public void setModelDirectory(File file) {
        this.directory = file;
    }

    public File getModelDirectory() {
        return this.directory;
    }

    public void saveExpansion(Refinement refinement) {
        this.setConstruct(refinement);
    }

    public void setConstruct(IXObject iXObject) {
        UIObject uIObject = this.uiDomain.getUIObject(iXObject);
        this.setUIConstruct(uIObject);
        if (!this.uiDomain.isCurrentObject(uIObject)) {
            this.uiDomain.addConstruct(uIObject);
        }
    }

    public void setUIConstruct(UIObject uIObject) {
        if (this.deFrame != null) {
            this.deFrame.setUIConstruct(uIObject);
        }
    }

    public void setDomain(Domain domain) {
        Debug.noteln("DE: setting domain from", (Object)this.getDomain());
        Debug.noteln("   to", (Object)domain);
        if (this.adjustingDomain) {
            return;
        }
        this.adjustingDomain = true;
        if (!domain.equals(this.getDomain())) {
            this.uiDomain.setDomain(domain);
        } else {
            Debug.noteln("DE: resetting same domain");
        }
        this.adjustingDomain = false;
    }

    public void setUIDomain(UIDomain uIDomain) {
        if (this.uiDomain.equals(uIDomain)) {
            return;
        }
        this.uiDomain = uIDomain;
        this.deFrame.setUIDomain(uIDomain);
        uIDomain.fireDomainSet(uIDomain.getDomain());
    }

    public UIDomain getUIDomain() {
        return this.uiDomain;
    }

    public Domain getDomain() {
        return this.uiDomain.getDomain();
    }

    public void refinementAdded(RefinementEvent refinementEvent) {
        if (this.deFrame != null) {
            this.deFrame.populateEditMenu();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("all")) {
            this.ensurePropertiesManager();
            this.propMan.updateApplicationFromProperties();
            return;
        }
        Object object = propertyChangeEvent.getOldValue();
        String string2 = (String)propertyChangeEvent.getNewValue();
        if (object != null && object.equals(string2)) {
            return;
        }
        Debug.note("IDE: got property change for " + string);
        Debug.noteln(" - old: " + object.toString() + " new:", (Object)string2);
        this.setProperty(string, string2);
    }

    protected JPropertiesManager ensurePropertiesManager() {
        if (this.propMan == null) {
            this.propMan = new IDEPropertiesManager(this);
        }
        return this.propMan;
    }

    protected JPropertiesManager ensureProperties() {
        if (this.propMan == null) {
            this.propMan = new IDEPropertiesManager(this);
            this.propMan.initProperties();
        }
        return this.propMan;
    }

    public void setVisible(boolean bl) {
        if (this.deFrame != null) {
            this.deFrame.setVisible(bl);
        }
    }

    public static void main(String[] stringArray) {
        File file = DomainParser.getLibraryDirectory();
        Parameters.processCommandLineArguments(stringArray);
        Domain domain = new Domain();
        DomainEditor.readDomain(domain);
        Debug.noteln("Domain Editor finished reading domain", (Object)domain);
        new SimpleIXAgent();
        Debug.noteln("Domain Editor starting up.....");
        DomainEditor domainEditor = new DomainEditor(domain, true);
        domainEditor.setModelDirectory(file);
        Debug.noteln("...Domain Editor started.");
        domainEditor.setVisible(true);
    }

    protected static void readDomain(Domain domain) {
        List list = Parameters.getList("domain");
        for (String string : list) {
            try {
                DomainEditor.readDomain(domain, string);
            }
            catch (Exception exception) {
                Debug.displayException("Problem with domain " + string, exception);
                if (Parameters.isInteractive()) continue;
                throw new RethrownException(exception);
            }
        }
    }

    public static void readDomain(Domain domain, String string) {
        Debug.noteln("Loading a domain from", (Object)string);
        URL uRL = XML.toURL(string);
        if (uRL == null) {
            uRL = DomainEditor.resolveDomainFile(string);
        }
        if (uRL == null) {
            throw new IllegalArgumentException("Can't find a domain named " + Strings.quote(string));
        }
        Domain domain2 = XML.readObject(Domain.class, uRL);
        domain.takeFrom(domain2);
    }

    public static URL resolveDomainFile(String string) {
        URL uRL = XML.toURL(string);
        if (uRL == null) {
            File file = DomainParser.getLibraryDirectory();
            File file2 = new File(string);
            if (!file2.exists() && file2.getParentFile() == null) {
                Debug.noteln("Resolving " + file2 + " against " + file);
                file2 = new File(file, file2.getPath());
            }
            if (!file2.exists()) {
                String string2 = System.getProperty("file.separator");
                String string3 = file.getPath() + string2 + string;
                file2 = new File(string3);
            }
            if (file2.exists()) {
                try {
                    uRL = file2.toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    Debug.noteException(malformedURLException);
                    throw new ConsistencyException("Unexpected", (Object)malformedURLException);
                }
            }
        }
        return uRL;
    }
}

