/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.IXAgent;
import ix.icore.IXObject;
import ix.icore.domain.Domain;
import ix.icore.domain.Refinement;
import ix.icore.domain.event.DomainEvent;
import ix.icore.domain.event.RefinementEvent;
import ix.iface.domain.DomainParser;
import ix.iface.ui.AboutFrame;
import ix.iface.ui.EditableObject;
import ix.iface.ui.IFormPanel;
import ix.iface.ui.IXToolItem;
import ix.iface.ui.JFrameMTP;
import ix.iface.ui.JPropertiesManager;
import ix.iface.ui.util.UIUtil;
import ix.iview.AConstructFramePanel;
import ix.iview.AROEditorPanel;
import ix.iview.ActionEditorPanel;
import ix.iview.ConstructEditing;
import ix.iview.DomainEditor;
import ix.iview.GlobalFramePanel;
import ix.iview.GrammarEditorPanel;
import ix.iview.IDESymbols;
import ix.iview.InternalDomainEditor;
import ix.iview.OrderingEditor;
import ix.iview.UndoManager;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UIObject;
import ix.iview.domain.UIObjectClass;
import ix.iview.domain.UIRefinement;
import ix.iview.domain.event.UIDomainEvent;
import ix.iview.domain.event.UIDomainListener;
import ix.iview.event.UndoChangeListener;
import ix.iview.util.IVUtil;
import ix.test.SimpleIXAgent;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.Strings;
import ix.util.TextAreaFrame;
import ix.util.Util;
import ix.util.lisp.Symbol;
import ix.util.xml.XML;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.event.ChangeListener;

public class DomainEditorFrame
extends JFrameMTP
implements ChangeListener,
UIDomainListener,
UndoChangeListener,
InternalDomainEditor,
IDESymbols {
    protected IXAgent agent;
    protected JPropertiesManager propMan;
    protected GlobalFramePanel domainPanel;
    protected ActionEditorPanel actionPanel;
    protected AROEditorPanel aroPanel;
    private boolean useARO = true;
    protected GrammarEditorPanel grammarPanel;
    protected AConstructFramePanel lexiconPanel;
    protected AConstructFramePanel testPanel;
    protected OrderingEditor orderingEditor;
    protected AboutFrame aboutFrame;
    protected ImageIcon checkIcon = Util.resourceImageIcon("ide-check.gif");
    protected ImageIcon revertOIcon = Util.resourceImageIcon("ide-revert-orig.gif");
    protected ImageIcon modifyIcon = Util.resourceImageIcon("ide-modify-draft.gif");
    protected ImageIcon varDecIcon = Util.resourceImageIcon("ide-var-icon.gif");
    protected ImageIcon publishIcon = Util.resourceImageIcon("ide-draft-publish.gif");
    protected ImageIcon minimalIcon = Util.resourceImageIcon("ide-view-minimal.gif");
    protected ImageIcon comprehensiveIcon = Util.resourceImageIcon("ide-view-comprehensive.gif");
    protected ImageIcon graphicalIcon = Util.resourceImageIcon("ide-view-graphical.gif");
    protected ImageIcon preferredIcon = Util.resourceImageIcon("ide-preferences.gif");
    protected ImageIcon simpleIcon = Util.resourceImageIcon("ide-mode-simple.gif");
    protected ImageIcon advancedIcon = Util.resourceImageIcon("ide-mode-advanced.gif");
    private JMenu editConstructMenu;
    private JMenu orderMenu;
    private ButtonGroup modeGroup = new ButtonGroup();
    private ButtonGroup viewGroup = new ButtonGroup();
    private JRadioButtonMenuItem simpleMI;
    private JRadioButtonMenuItem advancedMI;
    private JRadioButtonMenuItem minimalMI;
    private JRadioButtonMenuItem comprehensiveMI;
    private JRadioButtonMenuItem graphicalMI;
    private JButton minimalTB;
    private JButton comprehensiveTB;
    private JButton graphicalTB;
    private JCheckBoxMenuItem defSequenceMI;
    protected IXToolItem publishItem = new IXToolItem(this.fileMenu, this.toolBar, (ActionListener)this, "publish", "Publish Draft", this.publishIcon, 'P', "Publish draft to application");
    protected IXToolItem insertItem = new IXToolItem(this.fileMenu, (ActionListener)this, "insert", "Insert into draft domain...", 'I', "Insert all constructs from an existing domain into the draft");
    protected IXToolItem clearItem = new IXToolItem(this.fileMenu, (ActionListener)this, "clearDom", "Clear draft domain", 'C', "Clear draft domain");
    protected IXToolItem revertDItem = new IXToolItem(this.fileMenu, (ActionListener)this, "revertDom", "Discard domain changes (revert to published)", 'R', "Discard changes to draft domain (revert to published)");
    protected IXToolItem changesAllItem = new IXToolItem(this.fileMenu, (ActionListener)this, "changesAll", "View changes in the domain", 'V', "View all changes in the draft domain and its constructs");
    protected IXToolItem newEditItem = new IXToolItem(this.editMenu, this.toolBar, (ActionListener)this, "newEdit", "New", this.newIcon, 'N', "Create new item");
    protected IXToolItem revertOItem = new IXToolItem(this.editMenu, this.toolBar, this, "revertO", "Revert to Published", this.revertOIcon, "Revert to last published version");
    protected IXToolItem modifyItem = new IXToolItem(this.editMenu, this.toolBar, (ActionListener)this, "modify", "Modify Draft", this.modifyIcon, 'M', "Note changes from panel into draft");
    protected IXToolItem declareItem = new IXToolItem(this.editMenu, this.toolBar, (ActionListener)this, "declareVars", "Declare variables", this.varDecIcon, 'D', "Declare variables for the Activity");
    protected IXToolItem findVarsItem = new IXToolItem(this.editMenu, (ActionListener)this, "findVars", "Find variables", 'V', "Find all variables used in domain refinements");
    protected JMenu modeMenu;
    protected IXToolItem refreshItem = new IXToolItem(this.viewMenu, (ActionListener)this, "refresh", "Refresh", 'R', "Refresh the display (may fold trees)");
    protected IXToolItem changesItem = new IXToolItem(this.viewMenu, (ActionListener)this, "changes", "Changes from Draft", 'C', "View changes not yet noted to draft");
    protected IXToolItem changesOItem = new IXToolItem(this.viewMenu, (ActionListener)this, "changesO", "Changes from Published", 'P', "View changes to published object");
    protected IXToolItem simpleItem = new IXToolItem(this.modeMenu, this.toolBar, (ActionListener)this, "simple", "Simple Mode", this.simpleIcon, 'S', "Switch to simple mode");
    protected IXToolItem advancedItem = new IXToolItem(this.modeMenu, this.toolBar, (ActionListener)this, "advanced", "Advanced Mode", this.advancedIcon, 'A', "Switch to advanced mode");
    protected IXToolItem sortItem = new IXToolItem(this.viewMenu, (ActionListener)this, "sort", "Sort overview alphabetically", 'A', "Sort overview alphabetically or in input order");
    protected JMenu viewsMenu;
    protected IXToolItem minimalItem = new IXToolItem(this.viewsMenu, this.toolBar, (ActionListener)this, "minimal", "Minimal View", "Minimal", this.minimalIcon, "Switch to minimal view");
    protected IXToolItem comprehensiveItem = new IXToolItem(this.viewsMenu, this.toolBar, (ActionListener)this, "comprehensive", "Comprehensive View", "Comprehensive", this.comprehensiveIcon, "Switch to comprehensive view");
    protected IXToolItem graphicalItem = new IXToolItem(this.viewsMenu, this.toolBar, (ActionListener)this, "graphical", "Graphical View", "Graphical", this.graphicalIcon, "Switch to graphical view");
    protected IXToolItem viewFieldsItem = new IXToolItem(this.viewMenu, (ActionListener)this, "viewFields", "Set Fields to View", 'F', "Set which of the object's fields to show in the viewer");
    protected IXToolItem checkItem = new IXToolItem(this.toolsMenu, this.toolBar, (ActionListener)this, "check", "Check", this.checkIcon, 'C', "Check the current construct");
    protected IXToolItem genItem = new IXToolItem(this.toolsMenu, (ActionListener)this, "generateOS", "Generate Object System", 'G', "Generate an object system from activity constraints");
    protected IXToolItem searchItem = new IXToolItem(this.toolsMenu, (ActionListener)this, "search", "Search", 'S', "Search the domain");
    protected IXToolItem preferencesItem;
    protected IXToolItem preferredItem = new IXToolItem(this.viewMenu, this.toolBar, (ActionListener)this, "preferred", "Preferred", this.preferredIcon, 'P', "Use current preferences to set mode, style, and view");
    protected IXToolItem sequenceNewItem;
    protected IXToolItem sequenceItem;
    protected IXToolItem parallelItem;
    public IXToolItem[] allButtons = new IXToolItem[]{this.newItem, this.openItem, this.saveItem, this.saveAsItem, this.revertItem, this.redoItem, this.declareItem, this.publishItem, this.newEditItem, this.pasteItem, this.revertOItem, this.modifyItem, this.minimalItem, this.comprehensiveItem, this.graphicalItem, this.checkItem, this.helpItem};
    public IXToolItem[] showButtons = new IXToolItem[]{this.openItem, this.saveItem, this.publishItem, null, this.newEditItem, this.revertItem, this.redoItem, this.declareItem, null, this.minimalItem, this.comprehensiveItem, this.graphicalItem, null};
    public IXToolItem[] allMenuItems = new IXToolItem[]{this.newItem, this.openItem, this.saveItem, this.saveAsItem, this.toolbarItem, this.closeItem, this.exitItem, this.publishItem, this.insertItem, this.clearItem, this.revertDItem, this.changesAllItem, this.revertItem, this.redoItem, this.cutItem, this.copyItem, this.pasteItem, this.newEditItem, this.revertOItem, this.modifyItem, this.declareItem, this.findVarsItem, this.refreshItem, this.changesItem, this.changesOItem, this.preferredItem, this.simpleItem, this.advancedItem, this.sortItem, this.sequenceNewItem, this.sequenceItem, this.parallelItem, this.minimalItem, this.comprehensiveItem, this.graphicalItem, this.viewFieldsItem, this.checkItem, this.genItem, this.searchItem, this.helpItem, this.manualItem, this.aboutItem};
    private boolean standAlone = false;
    private DomainEditor editor;
    protected boolean simpleMode = true;
    protected boolean showButtonTexts = true;
    protected boolean isEditable = true;
    protected boolean listsAsText = true;
    protected boolean useNewCondEd = true;
    protected Symbol preferredView = VIEW_COMPREHENSIVE;
    protected String preferredStyle = "tabbed";
    protected Symbol preferredConstraints = C_ALL;
    private ImageIcon frameIcon = Util.resourceImageIcon("ide-icon.gif");
    private ImageIcon logo = Util.resourceImageIcon("ide-logo.gif");
    private String title = "I-X Domain Editor";
    public File directory = DomainParser.getLibraryDirectory();
    private boolean adjustingDomain = false;
    private boolean adjustingMode = false;
    private boolean adjustingView = false;
    JToolBar.Separator tbs = new JToolBar.Separator();

    public DomainEditorFrame(DomainEditor domainEditor) {
        this(domainEditor, true);
    }

    public DomainEditorFrame(DomainEditor domainEditor, boolean bl) {
        this.editor = domainEditor;
        this.standAlone = bl;
        this.helpFile = "ide-help.html";
        this.helpFrameIcon = Util.resourceImageIcon("ide-help-icon.gif");
        this.setVisuals();
        this.preInitMenus();
        this.preInitToolbar();
        this.preInitPanels();
        this.setCurrentPanel(this.actionPanel);
        this.orderingEditor = this.actionPanel.orderingEditor;
        this.setUIDomainListeners(domainEditor.getUIDomain());
    }

    public DomainEditorFrame(DomainEditor domainEditor, Domain domain) {
        this(domainEditor, domain, true);
    }

    public DomainEditorFrame(DomainEditor domainEditor, Domain domain, boolean bl) {
        this(domainEditor, bl);
        this.setDomain(domain);
        this.populateEditMenu();
        this.activateUndo();
    }

    public void setupFrame() {
        this.propMan = this.editor.ensureProperties();
        Debug.noteln("I-DE made menus");
        this.makeToolbar();
        Debug.noteln("I-DE made toolbar");
        if (this.actionPanel == null) {
            this.actionPanel = new ActionEditorPanel(this, this.preferredView, this.preferredConstraints);
        } else {
            this.actionPanel.setupPanelProperties(this.preferredView, this.preferredConstraints);
        }
        boolean bl = this.showButtonTexts;
        this.showButtonTexts = !bl;
        this.updateToolbar(bl);
        if (this.useARO && this.aroPanel == null) {
            this.aroPanel = new AROEditorPanel(this);
        }
        this.addPanels();
        Debug.noteln("I-DE added panels");
        this.fillWindowsMenu();
        this.setCurrentPanel(this.actionPanel);
        this.adaptMenusToPanel(this.actionPanel);
        this.advancedMI.setSelected(!this.simpleMode);
        this.simpleMI.setSelected(this.simpleMode);
        this.updateViewMenu(this.preferredView);
        this.orderingEditor = this.actionPanel.orderingEditor;
        this.addWindowListener(new IXWindow());
        UIDomain uIDomain = this.getUIDomain();
        this.setUIDomainListeners(uIDomain);
        this.activateUndo();
        this.pack();
        this.setSize(650, 750);
        this.propMan.updateApplicationFromProperties();
        this.invalidate();
    }

    public void makeTitle(IXAgent iXAgent) {
        this.agent = iXAgent;
        this.title = iXAgent.getAgentDisplayName().toString() + " Domain Editor";
        this.exitItem.hide();
        this.setVisuals();
    }

    private void preInitMenus() {
        this.makeDefaultMenu();
    }

    private void preInitToolbar() {
        this.toolBar.removeAll();
    }

    public DomainEditor editor() {
        return this.editor;
    }

    private void preInitPanels() {
        this.actionPanel = new ActionEditorPanel(this);
        if (this.useARO) {
            this.aroPanel = new AROEditorPanel(this);
        }
        this.domainPanel = new GlobalFramePanel(this);
        this.grammarPanel = new GrammarEditorPanel(this);
        this.actionPanel.addCurrentActionListener(this.domainPanel);
        this.domainPanel.addCurrentActionListener(this.actionPanel);
    }

    protected void postInitPanels() {
        if (this.useARO) {
            this.aroPanel.populateARO();
        }
        this.populateEditMenu();
        this.activateUndo();
    }

    public boolean listsAsText() {
        return this.listsAsText;
    }

    public boolean isSimple() {
        return this.simpleMode && this.getPanelStyle().equals("single") && this.actionPanel.getActivityView().equals(VIEW_MINIMAL);
    }

    protected void setBoundsFromProperties() {
        int n = UIUtil.propertyToInt(this.propMan.getProperty("ideX"));
        int n2 = UIUtil.propertyToInt(this.propMan.getProperty("ideY"));
        int n3 = UIUtil.propertyToInt(this.propMan.getProperty("ideWidth"));
        int n4 = UIUtil.propertyToInt(this.propMan.getProperty("ideHeight"));
        this.setBounds(n, n2, n3, n4);
        this.validate();
    }

    protected void setMode(Symbol symbol) {
        if (MODE_SIMPLE.equals(symbol)) {
            this.setSimpleMode(true);
        } else if (MODE_ADVANCED.equals(symbol)) {
            this.setSimpleMode(false);
        } else {
            Debug.noteln("I-DE: Cannot recognise mode ", (Object)symbol.toString());
        }
    }

    protected void updateToolbar(boolean bl) {
        if (this.showButtonTexts != bl) {
            this.showButtonTexts = bl;
            for (int i = 0; i < this.showButtons.length; ++i) {
                try {
                    IXToolItem iXToolItem = this.showButtons[i];
                    if (iXToolItem == null) continue;
                    iXToolItem.showButtonText(bl);
                    continue;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (this.actionPanel != null) {
                this.actionPanel.updateToolbar(bl);
            }
        }
    }

    protected void showListsAsTexts(boolean bl) {
        if (this.listsAsText != bl) {
            this.listsAsText = bl;
            if (this.grammarPanel != null) {
                this.grammarPanel.setListsAsText(this.listsAsText);
            }
            if (bl) {
                String string = "Sofar, only lists in the grammar panel can be shown as texts";
                JOptionPane.showMessageDialog(this, string);
            }
        }
    }

    protected void useNewCondEditor(boolean bl) {
        this.useNewCondEd = bl;
    }

    protected void addPanels() {
        this.addPanel(this.domainPanel, "Domain", "Viewer/editor for global domain constraints and issues");
        this.addPanel(this.actionPanel, "Activity", "Activity viewer/editor");
        this.addPanel(this.grammarPanel, "Grammar", "Grammar viewer/editor");
        if (this.useARO) {
            this.addPanel(this.aroPanel, "Object Class", "Object Class viewer/editor.");
            this.aroPanel.addUndoListener(this);
        }
        this.domainPanel.addUndoListener(this);
        this.actionPanel.addUndoListener(this);
        this.grammarPanel.addUndoListener(this);
    }

    protected void clearPanels() {
        this.domainPanel.clear();
        this.actionPanel.clear();
        this.grammarPanel.clear();
        if (this.useARO) {
            this.aroPanel.clear();
        }
    }

    protected boolean closePanels() {
        Debug.noteln("IDE-F: Closing panels");
        if (this.domainPanel.beforeClosing()) {
            if (this.actionPanel.beforeClosing()) {
                if (this.grammarPanel.beforeClosing()) {
                    if (!this.useARO || this.aroPanel.beforeClosing()) {
                        return true;
                    }
                    Debug.noteln(" Object panel not closing");
                } else {
                    Debug.noteln(" Grammar panel not closing");
                }
            } else {
                Debug.noteln(" Action panel not closing");
            }
        } else {
            Debug.noteln(" Domain panel not closing");
        }
        return false;
    }

    protected boolean currentPanelChanging(JPanel jPanel, JPanel jPanel2) {
        if (jPanel == null) {
            return ((AConstructFramePanel)jPanel2).beforeOpening();
        }
        if (jPanel.equals(jPanel2)) {
            return true;
        }
        AConstructFramePanel aConstructFramePanel = (AConstructFramePanel)jPanel;
        AConstructFramePanel aConstructFramePanel2 = (AConstructFramePanel)jPanel2;
        return aConstructFramePanel.beforeClosing() && aConstructFramePanel2.beforeOpening();
    }

    protected void setVisuals() {
        this.setTitle(this.title);
        this.setIconImage(this.frameIcon.getImage());
    }

    public void setEditable(boolean bl) {
        Debug.noteln("IDE-F: editor is always editable. Setting ignored.");
        this.isEditable = bl;
    }

    public boolean isSimpleMode() {
        return this.simpleMode;
    }

    public void setActivityView(Symbol symbol) {
        if (this.adjustingView) {
            return;
        }
        this.adjustingView = true;
        try {
            this.updateViewMenu(symbol);
            if (!this.preferredView.equals(symbol)) {
                this.enableView(symbol);
            }
            if (this.actionPanel != null) {
                this.actionPanel.setCurrentView(symbol);
            }
            this.adjustingView = false;
        }
        catch (Exception exception) {
            this.adjustingView = false;
        }
    }

    public boolean setPanelStyle(String string) {
        boolean bl = super.setPanelStyle(string);
        if (bl && this.simpleMode && !string.equals("single")) {
            this.setSimpleMode(false);
        }
        return bl;
    }

    public void setConstraintsView(Symbol symbol) {
        if (!this.preferredConstraints.equals(symbol)) {
            this.preferredConstraints = symbol;
            if (this.actionPanel != null) {
                this.actionPanel.setConstraintsView(symbol);
            }
        }
    }

    public void updateViewMenu(Symbol symbol) {
        if (VIEW_GRAPHICAL.equals(symbol)) {
            if (this.graphicalMI != null && !this.graphicalMI.isSelected()) {
                this.graphicalMI.setSelected(true);
                this.minimalMI.setSelected(false);
                this.comprehensiveMI.setSelected(false);
            }
        } else if (VIEW_COMPREHENSIVE.equals(symbol)) {
            if (this.comprehensiveMI != null && !this.comprehensiveMI.isSelected()) {
                this.comprehensiveMI.setSelected(true);
                this.minimalMI.setSelected(false);
                this.graphicalMI.setSelected(false);
            }
        } else if (VIEW_MINIMAL.equals(symbol) && this.minimalMI != null && !this.minimalMI.isSelected()) {
            this.minimalMI.setSelected(true);
            this.comprehensiveMI.setSelected(false);
            this.graphicalMI.setSelected(false);
        }
    }

    public void setSimpleMode(boolean bl) {
        if (this.adjustingMode) {
            return;
        }
        this.adjustingMode = true;
        if (this.simpleMI != null && this.simpleMI.isSelected() != bl) {
            this.simpleMI.setSelected(bl);
            this.advancedMI.setSelected(!bl);
        }
        this.simpleMode = bl;
        if (bl) {
            this.setPanelStyle("single");
            this.setActivityView(VIEW_MINIMAL);
            if (this.minimalMI != null) {
                this.minimalMI.setSelected(true);
            }
        } else {
            this.propMan = this.editor.ensurePropertiesManager();
            this.setPanelStyle(this.propMan.getProperty("idePanelStyle"));
            String string = this.propMan.getProperty("ideActivityView");
            this.setActivityView(UIUtil.propertyToSymbol(string));
        }
        this.adjustingMode = false;
    }

    public void setGraphical() {
        if (this.graphicalMI != null && !this.graphicalMI.isSelected()) {
            this.graphicalMI.setSelected(true);
            this.minimalMI.setSelected(false);
            this.comprehensiveMI.setSelected(false);
        }
    }

    public void setModelDirectory(File file) {
        this.directory = file;
    }

    public File getModelDirectory() {
        return this.directory;
    }

    protected void enableView(Symbol symbol) {
        this.preferredView = symbol;
        Dimension dimension = this.getSize();
        if (this.defSequenceMI != null) {
            if (VIEW_MINIMAL.equals(symbol)) {
                this.defSequenceMI.setEnabled(true);
            } else {
                this.defSequenceMI.setEnabled(false);
            }
        }
        if (this.simpleMode && !VIEW_MINIMAL.equals(symbol)) {
            this.setSimpleMode(false);
        }
        this.setSize(dimension);
        this.validate();
    }

    public void adaptDefaultMenu() {
        this.adaptMenuToAction();
    }

    protected void adaptMenuToAction() {
        if (this.orderMenu == null) {
            this.orderMenu = this.makeMenu(this.editMenu, "Set Constraints");
        } else {
            this.orderMenu.setVisible(true);
        }
        if (this.sequenceItem == null) {
            this.sequenceItem = new IXToolItem(this.orderMenu, this, "makeSequence", "Put Sub-Activities in Sequence", "Put Sub-Activities in Sequence");
        }
        if (this.parallelItem == null) {
            this.parallelItem = new IXToolItem(this.orderMenu, this, "makeParallel", "Put Sub-Activities in Parallel", "Put Sub-Activities in Parallel");
        }
        this.sequenceItem.showItem();
        this.parallelItem.showItem();
        this.populateEditMenu();
        this.activateUndo();
        this.makeViewsMenu();
    }

    public void makeFileMenu() {
        this.openItem.setItemLabel("Open as draft domain...");
        this.openItem.setToolTip("Open an existing file as a draft domain");
        this.openItem.hideItem();
        this.openItem.showItem();
        this.insertItem.hideItem();
        this.insertItem.showItem();
        this.clearItem.showItem();
        this.revertDItem.showItem();
        this.changesAllItem.showItem();
        this.saveItem.setItemLabel("Save draft to file");
        this.saveItem.showItem();
        this.saveAsItem.setItemLabel("Save draft as...");
        this.saveAsItem.showItem();
        this.publishItem.showItem();
        this.makeFileMenuExits();
    }

    public void makeFileMenuExits() {
        this.fileMenu.addSeparator();
        if (this.standAlone) {
            this.exitItem.showItem();
        } else {
            this.closeItem.showItem();
        }
    }

    public void makeOptionsMenu() {
    }

    public void makeEditMenu() {
        this.newEditItem.setLabel("New construct");
        this.newEditItem.setToolTip("New construct");
        this.newEditItem.makeItem();
        this.newEditItem.show();
        this.cutItem.setToolTip("Delete");
        this.cutItem.showItem();
        this.editConstructMenu = this.makeMenu(this.editMenu, "Edit Construct");
        this.editConstructMenu.setEnabled(false);
        this.copyItem.showItem();
        this.editMenu.addSeparator();
        this.modifyItem.showItem();
        this.revertItem.setToolTip("Undo last change in the panel");
        this.revertItem.showItem();
        this.redoItem.showItem();
        this.revertOItem.showItem();
        this.editMenu.addSeparator();
    }

    public void makeViewMenu() {
        this.changesItem.show();
        this.changesOItem.show();
        this.viewMenu.addSeparator();
        this.refreshItem.show();
        this.viewMenu.addSeparator();
        this.makeToolbarItem(this.viewMenu);
        this.viewMenu.addSeparator();
        this.preferredItem.showItem();
        this.makeModeMenu();
        this.makeStyleMenu(this.viewMenu);
        this.makeWindowsMenu(this.viewMenu);
        this.viewMenu.addSeparator();
        this.viewFieldsItem.showItem();
    }

    public void makeModeMenu() {
        this.modeMenu = this.makeMenu(this.viewMenu, "Editor Mode");
        this.modeMenu.setMnemonic('M');
        this.simpleItem.setMenu(this.modeMenu);
        this.advancedItem.setMenu(this.modeMenu);
        if (this.simpleMI == null) {
            this.simpleMI = this.simpleItem.makeRadioItem();
        }
        if (this.advancedMI == null) {
            this.advancedMI = this.advancedItem.makeRadioItem();
        }
        this.modeGroup.add(this.simpleMI);
        this.modeGroup.add(this.advancedMI);
        this.simpleItem.showItem();
        this.advancedItem.showItem();
    }

    public void makeViewsMenu() {
        this.viewsMenu = this.makeMenu(this.viewMenu, "Activity Views");
        this.minimalItem.setMenu(this.viewsMenu);
        this.comprehensiveItem.setMenu(this.viewsMenu);
        this.graphicalItem.setMenu(this.viewsMenu);
        if (this.minimalMI == null) {
            this.minimalMI = this.minimalItem.makeRadioItem();
        }
        if (this.comprehensiveMI == null) {
            this.comprehensiveMI = this.comprehensiveItem.makeRadioItem();
        }
        if (this.graphicalMI == null) {
            this.graphicalMI = this.graphicalItem.makeRadioItem();
        }
        this.viewGroup.add(this.minimalMI);
        this.viewGroup.add(this.comprehensiveMI);
        this.viewGroup.add(this.graphicalMI);
    }

    public void makeToolsMenu() {
        this.checkItem.showItem();
        this.checkItem.setEnabled(false);
        this.toolsMenu.addSeparator();
        this.makePreferences();
    }

    public void makeHelpMenu() {
        super.makeHelpMenu();
        this.manualItem.setEnabled(false);
    }

    protected void makeToolbar() {
        this.toolBar.removeAll();
        for (int i = 0; i < this.allButtons.length; ++i) {
            IXToolItem iXToolItem = this.allButtons[i];
            if (iXToolItem == null) continue;
            iXToolItem.showButtonText(true);
            iXToolItem.hideButton();
        }
        LayoutManager layoutManager = this.toolBar.getLayout();
        this.openItem.setButtonLabel("Open Draft");
        this.saveItem.setButtonLabel("Save Draft");
        this.declareItem.setButtonLabel("Declare");
        for (int i = 0; i < this.showButtons.length; ++i) {
            IXToolItem iXToolItem = this.showButtons[i];
            if (iXToolItem != null) {
                iXToolItem.showButton();
                continue;
            }
            this.toolBar.addSeparator();
        }
    }

    public void showButtonTexts(boolean bl) {
    }

    protected void adaptMenusToPanel(JPanel jPanel) {
        Object object;
        if (jPanel == null) {
            return;
        }
        String string = jPanel.getName();
        this.editConstructMenu.setText("Edit " + string);
        if (jPanel.equals(this.aroPanel)) {
            this.newEditItem.setItemLabel("New Child");
            this.newEditItem.setButtonLabel("New Child");
            this.newEditItem.setToolTip("New Child");
            this.genItem.showItem();
            this.genItem.setEnabled(this.getUIDomain() != null && !this.getUIDomain().isEmpty() && !this.getUIDomain().hasObjectSystem());
        } else {
            this.newEditItem.setItemLabel("New " + string);
            this.newEditItem.setButtonLabel("New");
            this.newEditItem.setToolTip("Create a new " + string);
            this.genItem.hideItem();
        }
        this.newEditItem.setEnabled(true);
        this.newEditItem.hideItem();
        this.newEditItem.showItem();
        this.modifyItem.setItemLabel("Note " + string + " into Draft");
        this.modifyItem.setEnabled(true);
        this.modifyItem.hideItem();
        this.modifyItem.showItem();
        this.checkItem.setItemLabel("Check current " + string);
        this.checkItem.setEnabled(false);
        this.checkItem.hideItem();
        this.checkItem.showItem();
        this.findVarsItem.hideItem();
        this.populateEditMenu();
        if (jPanel.equals(this.actionPanel) || jPanel.equals(this.aroPanel)) {
            this.cutItem.setItemLabel("Delete " + string);
            this.cutItem.setEnabled(true);
            this.cutItem.hideItem();
            this.cutItem.showItem();
            this.cutItem.hideButton();
            this.copyItem.setItemLabel("Copy " + string);
            this.copyItem.setEnabled(true);
            this.copyItem.hideItem();
            this.copyItem.showItem();
            this.copyItem.hideButton();
            this.revertItem.hideButton();
            this.revertItem.showButton();
            this.redoItem.hideButton();
            this.redoItem.showButton();
            this.searchItem.showItem();
            this.activateDomainItems();
        } else {
            this.cutItem.hideItem();
            this.copyItem.hideItem();
            this.searchItem.hideItem();
        }
        if (jPanel.equals(this.actionPanel)) {
            this.declareItem.hideItem();
            this.declareItem.setToolTip("Declare variables for the Activity");
            this.declareItem.showItem();
            this.declareItem.showButton();
            this.manageActViewGroup();
            this.editMenu.add(this.orderMenu);
        } else {
            this.viewsMenu.setVisible(false);
            this.minimalItem.hideItem();
            this.comprehensiveItem.hideItem();
            this.graphicalItem.hideItem();
            this.declareItem.hideItem();
            this.declareItem.hideButton();
            if (jPanel.equals(this.domainPanel)) {
                object = "Declare variables as used for all Activities in the domain";
                this.declareItem.setToolTip((String)object);
                this.declareItem.showItem();
                this.declareItem.showButton();
                this.findVarsItem.showItem();
            }
            this.editMenu.remove(this.orderMenu);
        }
        if (jPanel instanceof AConstructFramePanel && ((AConstructFramePanel)jPanel).hasOverview()) {
            object = this.sortItem.ensureCheckItem();
            ((JCheckBoxMenuItem)object).setState(((AConstructFramePanel)jPanel).getSort());
            this.sortItem.show();
        } else {
            this.sortItem.hide();
        }
        this.refreshToolbar(jPanel);
        this.activateUndo();
    }

    protected void adaptMenusToPanelTrial(JPanel jPanel) {
        if (jPanel == null) {
            return;
        }
        String string = jPanel.getName();
        this.editConstructMenu.setText("Edit " + string);
        if (jPanel.equals(this.aroPanel)) {
            this.newEditItem.setItemLabel("New Child");
        } else {
            this.newEditItem.setItemLabel("New " + string);
        }
        this.modifyItem.setItemLabel("Note " + string + " into Draft");
        this.checkItem.setItemLabel("Check current " + string);
        this.checkItem.setEnabled(false);
        this.cutItem.setItemLabel("Delete " + string);
        this.copyItem.setItemLabel("Copy " + string);
        if (jPanel.equals(this.actionPanel) || jPanel.equals(this.aroPanel)) {
            this.cutItem.setEnabled(true);
            this.copyItem.setEnabled(true);
        } else {
            this.cutItem.setEnabled(false);
            this.copyItem.setEnabled(false);
        }
        if (jPanel.equals(this.actionPanel)) {
            this.declareItem.setToolTip("Declare variables for the Activity");
        }
        this.populateEditMenu();
        if (jPanel.equals(this.actionPanel) || jPanel.equals(this.aroPanel)) {
            this.cutItem.setItemLabel("Delete " + string);
            this.cutItem.setEnabled(true);
            this.cutItem.hide();
            this.cutItem.show();
            this.cutItem.hideButton();
            this.copyItem.setItemLabel("Copy " + string);
            this.copyItem.setEnabled(true);
            this.copyItem.hide();
            this.copyItem.show();
            this.copyItem.hideButton();
            this.revertItem.hideButton();
            this.revertItem.showButton();
            this.redoItem.hideButton();
            this.redoItem.showButton();
        } else {
            this.cutItem.hide();
            this.copyItem.hide();
        }
        if (jPanel.equals(this.actionPanel)) {
            this.declareItem.hide();
            this.declareItem.setToolTip("Declare variables for the Activity");
            this.declareItem.show();
            this.toolBar.add(this.tbs);
            Component component = Box.createHorizontalGlue();
            this.toolBar.add(component);
            String string2 = "";
            try {
                string2 = this.viewGroup.getSelection().getActionCommand();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.viewGroup = new ButtonGroup();
            this.minimalMI = (JRadioButtonMenuItem)this.minimalItem.show();
            this.comprehensiveMI = (JRadioButtonMenuItem)this.comprehensiveItem.show();
            this.graphicalMI = (JRadioButtonMenuItem)this.graphicalItem.show();
            this.viewGroup.add(this.minimalMI);
            this.viewGroup.add(this.comprehensiveMI);
            this.viewGroup.add(this.graphicalMI);
            if (string2 != "" && string2 != null) {
                if (string2.equals("comprehensive")) {
                    this.comprehensiveMI.setSelected(true);
                } else if (string2.equals("graphical")) {
                    this.graphicalMI.setSelected(true);
                } else if (string2.equals("minimal")) {
                    this.minimalMI.setSelected(true);
                }
            }
            this.editMenu.add(this.orderMenu);
        } else {
            this.minimalItem.hide();
            this.comprehensiveItem.hide();
            this.graphicalItem.hide();
            this.declareItem.hide();
            if (jPanel.equals(this.domainPanel)) {
                String string3 = "Declare variables as used for all Activities in the domain";
                this.declareItem.setToolTip(string3);
                this.declareItem.show();
                this.findVarsItem.show();
            }
            this.editMenu.remove(this.orderMenu);
            this.toolBar.remove(this.tbs);
        }
        this.activateUndo();
    }

    private void refreshToolbar(JPanel jPanel) {
        this.toolBar.removeAll();
        if (jPanel == null) {
            return;
        }
        for (int i = 0; i < this.showButtons.length; ++i) {
            IXToolItem iXToolItem = this.showButtons[i];
            if (iXToolItem != null) {
                iXToolItem.hideButton();
                if (iXToolItem.equals(this.minimalItem) || iXToolItem.equals(this.comprehensiveItem) || iXToolItem.equals(this.graphicalItem)) {
                    iXToolItem.hideButton();
                    if (!jPanel.equals(this.actionPanel)) continue;
                    iXToolItem.showButton();
                    continue;
                }
                iXToolItem.showButton();
                continue;
            }
            this.toolBar.addSeparator();
        }
    }

    private void showToolbarComponents() {
        for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
            Debug.noteln("Component at " + i + ":", (Object)this.toolBar.getComponent(i));
        }
    }

    private void manageActViewGroup() {
        this.toolBar.addSeparator();
        Component component = Box.createHorizontalGlue();
        this.toolBar.add(component);
        String string = "";
        try {
            string = this.viewGroup.getSelection().getActionCommand();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.viewGroup = new ButtonGroup();
        this.viewsMenu.setVisible(true);
        this.minimalMI = (JRadioButtonMenuItem)this.minimalItem.show();
        this.comprehensiveMI = (JRadioButtonMenuItem)this.comprehensiveItem.show();
        this.graphicalMI = (JRadioButtonMenuItem)this.graphicalItem.show();
        this.viewGroup.add(this.minimalMI);
        this.viewGroup.add(this.comprehensiveMI);
        this.viewGroup.add(this.graphicalMI);
        if (string != "" && string != null) {
            if (string.equals("comprehensive")) {
                this.comprehensiveMI.setSelected(true);
            } else if (string.equals("graphical")) {
                this.graphicalMI.setSelected(true);
            } else if (string.equals("minimal")) {
                this.minimalMI.setSelected(true);
            }
        }
    }

    protected void populateEditMenu() {
        AConstructFramePanel aConstructFramePanel = (AConstructFramePanel)this.getCurrentPanel();
        if (aConstructFramePanel != null) {
            ArrayList arrayList;
            Collection collection = aConstructFramePanel.getAllConstructs();
            if (collection != null) {
                collection = IVUtil.sortNamedCollection(collection);
                arrayList = new ArrayList(collection);
            } else {
                arrayList = new ArrayList();
            }
            UIUtil.populateMenu(this, this.editConstructMenu, "editConstruct", arrayList);
        }
        this.activateDomainItems();
    }

    protected void activateDomainItems() {
        AConstructFramePanel aConstructFramePanel = (AConstructFramePanel)this.getCurrentPanel();
        if (aConstructFramePanel == null) {
            return;
        }
        if (aConstructFramePanel.equals(this.aroPanel)) {
            this.genItem.setEnabled(this.getUIDomain() != null && !this.getUIDomain().isEmpty() && !this.getUIDomain().hasObjectSystem());
            this.searchItem.setEnabled(this.getUIDomain() != null && !this.getUIDomain().isEmpty() && this.getUIDomain().hasObjectSystem());
        } else if (aConstructFramePanel.equals(this.actionPanel)) {
            this.searchItem.setEnabled(this.getUIDomain() != null && !this.getUIDomain().isEmpty() && this.getUIDomain().hasRefinements());
        }
        ConstructEditing constructEditing = aConstructFramePanel.getEditingPanel();
        if (constructEditing instanceof IFormPanel) {
            this.viewFieldsItem.showItem();
        } else {
            this.viewFieldsItem.hideItem();
        }
    }

    public void activateUndo() {
        this.revertItem.setEnabled(false);
        this.redoItem.setEnabled(false);
        AConstructFramePanel aConstructFramePanel = (AConstructFramePanel)this.getCurrentPanel();
        if (aConstructFramePanel == null) {
            return;
        }
        if (aConstructFramePanel.canUndo()) {
            this.revertItem.setEnabled(true);
        }
        if (aConstructFramePanel.canRedo()) {
            this.redoItem.setEnabled(true);
        }
    }

    public void undoChanged(UndoManager undoManager, EditableObject editableObject) {
        this.activateUndo();
    }

    protected void makePreferences() {
        this.preferencesItem = new IXToolItem(this.toolsMenu, (ActionListener)this, "preferences", "Preferences", 'P', "Edit I-DE preferences");
        this.preferencesItem.showItem();
    }

    public void saveExpansion(Refinement refinement) {
        this.setConstruct(refinement);
    }

    public void setConstruct(IXObject iXObject) {
        this.setUIConstruct(this.getUIDomain().getUIObject(iXObject));
    }

    public void setUIConstruct(UIObject uIObject) {
        if (uIObject instanceof UIRefinement) {
            this.setCurrentPanel(this.actionPanel);
        } else if (uIObject instanceof UIDomain) {
            this.setCurrentPanel(this.domainPanel);
        } else if (uIObject instanceof UIObjectClass) {
            this.setCurrentPanel(this.aroPanel);
        }
        AConstructFramePanel aConstructFramePanel = (AConstructFramePanel)this.getCurrentPanel();
        if (aConstructFramePanel != null) {
            aConstructFramePanel.setUIConstruct(uIObject);
        }
    }

    protected void setDomain(Domain domain) {
        if (this.adjustingDomain) {
            return;
        }
        this.adjustingDomain = true;
        if (!domain.equals(this.getDomain())) {
            this.getUIDomain().setDomain(domain);
        }
        this.adjustingDomain = false;
    }

    public void setUIDomain(UIDomain uIDomain) {
        if (this.getUIDomain().equals(uIDomain)) {
            return;
        }
        this.setUIDomainListeners(uIDomain);
        uIDomain.fireDomainSet(uIDomain.getDomain());
    }

    protected void ensureUIDomainListeners(UIDomain uIDomain) {
        UIDomain uIDomain2 = this.getUIDomain();
        if (uIDomain2.equals(uIDomain)) {
            return;
        }
        uIDomain.setUIDomainListeners(uIDomain2.getUIDomainListeners());
        uIDomain.addUIDomainListener(this);
        uIDomain.addUIDomainListener(this.grammarPanel);
        uIDomain.addUIDomainListener(this.actionPanel);
        uIDomain.addUIDomainListener(this.aroPanel);
    }

    protected void setUIDomainListeners(UIDomain uIDomain) {
        UIDomain uIDomain2 = this.getUIDomain();
        uIDomain.setUIDomainListeners(uIDomain2.getUIDomainListeners());
        uIDomain.addUIDomainListener(this);
        uIDomain.addUIDomainListener(this.grammarPanel);
        uIDomain.addUIDomainListener(this.actionPanel);
        uIDomain.addUIDomainListener(this.aroPanel);
    }

    public UIDomain getUIDomain() {
        return this.editor.getUIDomain();
    }

    public Domain getDomain() {
        return this.getUIDomain().getDomain();
    }

    public void updateCurrentPanel(AConstructFramePanel aConstructFramePanel) {
        super.updateCurrentPanel(aConstructFramePanel);
        this.populateEditMenu();
        this.activateUndo();
    }

    public void setDefaultSequence(boolean bl) {
        if (this.defSequenceMI != null) {
            this.defSequenceMI.setState(bl);
        }
        this.actionPanel.setDefaultSequence(bl);
    }

    protected void userClearDomain() {
        int n = 0;
        if (!this.getUIDomain().isEmpty()) {
            String[] stringArray = new String[]{"This will clear all constructs in the draft.", "Are you sure you want to do this?"};
            n = JOptionPane.showConfirmDialog(this, stringArray, "Confirm", 0);
        }
        if (n == 0) {
            this.getUIDomain().clearDraft();
        }
    }

    protected void userRevertDomain() {
        int n = 0;
        if (this.getUIDomain().hasChangedConstructsFromOriginal()) {
            String[] stringArray = new String[]{"This will clear all changes to the draft (including open/insert)", "since it was last published.", "If the domain has not been published yet, it will revert to the original domain.", "Are you sure you want to do this?"};
            n = JOptionPane.showConfirmDialog(this, stringArray, "Confirm", 0);
        }
        if (n == 0) {
            this.getUIDomain().revertToOriginal();
        }
    }

    protected void userOpenDomain() {
        int n = 0;
        if (!this.getUIDomain().isEmpty()) {
            String[] stringArray = new String[]{"This will clear all current domain constructs.", "Are you sure you want to do this?", "(Use 'Insert domain' to add to the current constructs)"};
            n = JOptionPane.showConfirmDialog(this, stringArray, "Confirm", 0);
        }
        if (n == 0) {
            this.getUIDomain().loadDomain();
        }
    }

    protected void userInsertDomain() {
        this.getUIDomain().insertDomain();
    }

    protected File userSaveDomain() {
        ((AConstructFramePanel)this.getACurrentPanel()).beforeClosing();
        return this.getUIDomain().saveDomain();
    }

    protected File userSaveDomainAs() {
        ((AConstructFramePanel)this.getACurrentPanel()).beforeClosing();
        return this.getUIDomain().saveDomain(null);
    }

    protected void userPublishDomain() {
        ((AConstructFramePanel)this.getACurrentPanel()).beforeClosing();
        this.getUIDomain().publishToDomain();
    }

    private void userPropSimple(boolean bl) {
        this.setSimpleMode(bl);
        this.propMan = this.editor.ensurePropertiesManager();
        if (bl) {
            this.propMan.setProperty("ideMode", MODE_SIMPLE.toString());
        } else {
            this.propMan.setProperty("ideMode", MODE_ADVANCED.toString());
        }
    }

    public void refinementAdded(RefinementEvent refinementEvent) {
        this.populateEditMenu();
    }

    public void constructAdded(DomainEvent domainEvent) {
        this.populateEditMenu();
    }

    public void constructAdded(UIDomainEvent uIDomainEvent) {
        this.populateEditMenu();
    }

    public void constructEdited(UIDomainEvent uIDomainEvent) {
        this.populateEditMenu();
    }

    public void constructRemoved(UIDomainEvent uIDomainEvent) {
        this.populateEditMenu();
    }

    public void domainCleared(UIDomainEvent uIDomainEvent) {
        Debug.noteln("DE-F: got domain-cleared event");
        this.populateEditMenu();
    }

    public void domainEdited(UIDomainEvent uIDomainEvent) {
        this.populateEditMenu();
    }

    public void domainSet(UIDomainEvent uIDomainEvent) {
        this.populateEditMenu();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = ((AbstractButton)object).getActionCommand();
        Debug.noteln("Domain Editor: action command is", (Object)string);
        if (string.equals("close")) {
            this.userClose();
        } else if (string.equals("clearDom")) {
            this.userClearDomain();
        } else if (string.equals("open")) {
            this.userOpenDomain();
        } else if (string.equals("revertDom")) {
            this.userRevertDomain();
        } else if (string.equals("insert")) {
            this.userInsertDomain();
        } else if (string.equals("save")) {
            this.userSaveDomain();
        } else if (string.equals("saveAs")) {
            this.userSaveDomainAs();
        } else if (string.equals("publish")) {
            this.userPublishDomain();
        } else if (string.equals("refresh")) {
            this.userRefresh();
        } else if (string.equals("sort")) {
            this.userSort();
        } else if (string.equals("changes")) {
            this.userViewChanges();
        } else if (string.equals("changesAll")) {
            this.userViewAllChanges();
        } else if (string.equals("changesO")) {
            this.userViewChangesFromOriginal();
        } else if (string.equals("viewFields")) {
            try {
                AConstructFramePanel aConstructFramePanel = (AConstructFramePanel)this.getCurrentPanel();
                ConstructEditing constructEditing = aConstructFramePanel.getEditingPanel();
                if (constructEditing != null && constructEditing instanceof IFormPanel) {
                    ((IFormPanel)((Object)constructEditing)).editFields(this);
                }
            }
            catch (Exception exception) {}
        } else if (string.equals("undo")) {
            try {
                if (!((AConstructFramePanel)this.getCurrentPanel()).undo()) {
                    Debug.noteln("I-DE: Something went wrong during undo");
                }
                this.activateUndo();
            }
            catch (Exception exception) {}
        } else if (string.equals("redo")) {
            try {
                if (!((AConstructFramePanel)this.getCurrentPanel()).redo()) {
                    Debug.noteln("I-DE: Something went wrong during redo");
                }
                this.activateUndo();
            }
            catch (Exception exception) {}
        } else if (string.equals("preferences")) {
            this.userPreferences();
        } else if (string.equals("modeSimple")) {
            this.userPropSimple(((JCheckBoxMenuItem)object).getState());
        } else if (string.equals("preferred")) {
            this.propMan = this.editor.ensurePropertiesManager();
            this.propMan.updateApplicationFromProperties();
        } else if (string.equals("simple")) {
            this.setSimpleMode(true);
        } else if (string.equals("advanced")) {
            this.setSimpleMode(false);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private boolean userCheckConstruct() {
        AConstructFramePanel aConstructFramePanel = (AConstructFramePanel)this.getCurrentPanel();
        if (aConstructFramePanel != null) {
            return aConstructFramePanel.checkConstruct();
        }
        return true;
    }

    public void userViewAllChanges() {
        UIDomain uIDomain = this.getUIDomain();
        if (uIDomain == null) {
            JOptionPane.showMessageDialog(this, "No domain to check");
        } else {
            List list = uIDomain.collectAllChanges();
            if (list == null || list.size() == 0) {
                JOptionPane.showMessageDialog(this, "No changes found");
            } else {
                TextAreaFrame textAreaFrame = new TextAreaFrame("Changes for domain " + uIDomain.getName());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    textAreaFrame.appendLine((String)iterator.next());
                }
                textAreaFrame.setVisible(true);
            }
        }
    }

    public void userViewChanges() {
        AConstructFramePanel aConstructFramePanel = (AConstructFramePanel)this.getCurrentPanel();
        if (aConstructFramePanel != null) {
            aConstructFramePanel.viewChanges();
        }
    }

    public void userViewChangesFromOriginal() {
        AConstructFramePanel aConstructFramePanel = (AConstructFramePanel)this.getCurrentPanel();
        if (aConstructFramePanel != null) {
            aConstructFramePanel.viewChangesFromOriginal();
        }
    }

    private void closeIDE() {
        if (this.standAlone) {
            System.exit(0);
        } else {
            this.setVisible(false);
        }
    }

    public void exitApplication() {
        this.userClose();
    }

    public boolean userClose() {
        if (this.fileChooser != null) {
            this.fileChooser.setVisible(false);
        }
        if (this.helpFrame != null) {
            this.helpFrame.setVisible(false);
        }
        if (this.closePanels()) {
            if (this.getUIDomain().hasChangedAllFromOriginal()) {
                Object object;
                Debug.noteln("Domain Changes are:", (Object)this.getUIDomain().collectAllChanges());
                if (this.standAlone) {
                    String string = "Do you want to save unsaved changes?";
                    int n = JOptionPane.showConfirmDialog(this, string, "", 1, 3);
                    if (n == 2) {
                        return false;
                    }
                    object = n == 1 ? "Exit" : (n == 0 ? "Save" : null);
                } else {
                    String string = "Do you want to save/publish changes?";
                    Object[] objectArray = new Object[]{"Save and Publish", "Save", "Publish", "Close only"};
                    object = JOptionPane.showInputDialog(this, string, "", 3, null, objectArray, objectArray[0]);
                }
                if (object == null) {
                    return false;
                }
                if (object.equals("Save")) {
                    this.getUIDomain().saveDomain();
                } else if (object.equals("Publish")) {
                    this.getUIDomain().publishToDomain();
                } else if (object.equals("Save and Publish")) {
                    this.getUIDomain().saveDomain();
                    this.getUIDomain().publishToDomain();
                }
            }
            this.closeIDE();
            return true;
        }
        return false;
    }

    public void aboutDialog() {
        if (this.aboutFrame == null) {
            String[] stringArray = new String[]{"About " + this.getTitle(), IVUtil.ideReleaseToString()};
            this.aboutFrame = new AboutFrame("About " + this.getTitle(), stringArray);
        }
        this.aboutFrame.setVisible(true);
    }

    private void userRefresh() {
        AConstructFramePanel aConstructFramePanel = (AConstructFramePanel)this.getCurrentPanel();
        if (aConstructFramePanel != null) {
            aConstructFramePanel.refresh();
        }
    }

    private void userSort() {
        AConstructFramePanel aConstructFramePanel;
        aConstructFramePanel.setSort(!(aConstructFramePanel = (AConstructFramePanel)this.getCurrentPanel()).getSort());
    }

    private void userPreferences() {
        this.propMan = this.editor.ensurePropertiesManager();
        this.propMan.editPreferences();
    }

    public static void main(String[] stringArray) {
        File file = DomainParser.getLibraryDirectory();
        Parameters.processCommandLineArguments(stringArray);
        Domain domain = new Domain();
        DomainEditorFrame.readDomain(domain);
        new SimpleIXAgent();
        DomainEditor domainEditor = new DomainEditor(domain, true);
        domainEditor.setModelDirectory(file);
        domainEditor.setVisible(true);
    }

    protected static void readDomain(Domain domain) {
        List list = Parameters.getList("domain");
        for (String string : list) {
            try {
                DomainEditorFrame.readDomain(domain, string);
            }
            catch (Exception exception) {
                Debug.displayException("Problem with domain " + string, exception);
                if (Parameters.isInteractive()) continue;
                throw new RethrownException(exception);
            }
        }
    }

    public static void readDomain(Domain domain, String string) {
        Debug.noteln("Loading a domain from", (Object)string);
        URL uRL = XML.toURL(string);
        if (uRL == null) {
            uRL = DomainEditorFrame.resolveDomainFile(string);
        }
        if (uRL == null) {
            throw new IllegalArgumentException("Can't find a domain named " + Strings.quote(string));
        }
        Domain domain2 = XML.readObject(Domain.class, uRL);
        domain.takeFrom(domain2);
    }

    public static URL resolveDomainFile(String string) {
        URL uRL = XML.toURL(string);
        if (uRL == null) {
            File file = DomainParser.getLibraryDirectory();
            File file2 = new File(string);
            if (!file2.exists() && file2.getParentFile() == null) {
                Debug.noteln("Resolving " + file2 + " against " + file);
                file2 = new File(file, file2.getPath());
            }
            if (!file2.exists()) {
                String string2 = System.getProperty("file.separator");
                String string3 = file.getPath() + string2 + string;
                file2 = new File(string3);
            }
            if (file2.exists()) {
                try {
                    uRL = file2.toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    Debug.noteException(malformedURLException);
                    throw new ConsistencyException("Unexpected", (Object)malformedURLException);
                }
            }
        }
        return uRL;
    }

    class IXWindow
    extends WindowAdapter {
        IXWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            DomainEditorFrame.this.userClose();
        }
    }
}

