/*
 * Decompiled with CFR 0.152.
 */
package ix.iview.domain;

import ix.icore.AbstractAnnotatedObject;
import ix.icore.GenericConstraint;
import ix.icore.domain.Constraint;
import ix.icore.domain.Refinement;
import ix.icore.domain.event.DomainEvent;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UIRefinement;
import ix.iview.domain.event.UIDomainEvent;
import ix.iview.domain.event.UIDomainListener;
import ix.util.Debug;
import ix.util.lisp.Symbol;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;

public class UIGrammar
extends AbstractAnnotatedObject
implements UIDomainListener {
    protected TreeMap genericConstraints = new TreeMap();
    protected UIDomain uiDomain;

    public UIGrammar(UIDomain uIDomain) {
        this.uiDomain = uIDomain;
        uIDomain.addUIDomainListener(this);
        Debug.noteln("***************making new UIGrammar");
        this.loadGenericConstraints(uIDomain);
    }

    public void initGenericConstraints() {
        this.genericConstraints.clear();
        Symbol symbol = Symbol.intern("world-state");
        String string = "<pattern> = <value>";
        this.addGenericConstraint(symbol, Symbol.intern("condition"), string);
        this.addGenericConstraint(symbol, Symbol.intern("effect"), string);
        this.addGenericConstraint(Symbol.intern("temporal"), Symbol.intern("before"), "<node-end> <node-end>");
        this.addGenericConstraint(Symbol.intern("compute"), Symbol.intern("null"), string);
        this.addGenericConstraint(Symbol.intern("compute"), Symbol.intern("multiple-answer"), string);
    }

    public GenericConstraint addGenericConstraint(Symbol symbol, Symbol symbol2, String string) {
        try {
            GenericConstraint genericConstraint = new GenericConstraint(symbol, symbol2);
            genericConstraint.setForm(string);
            this.genericConstraints.put(Symbol.intern(symbol + "-" + symbol2), genericConstraint);
            return genericConstraint;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public GenericConstraint addGenericConstraint(Constraint constraint) {
        if (constraint == null) {
            return null;
        }
        try {
            GenericConstraint genericConstraint = new GenericConstraint(constraint.getType(), constraint.getRelation());
            this.genericConstraints.put(Symbol.intern(constraint.getType() + "-" + constraint.getRelation()), genericConstraint);
            return genericConstraint;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void loadGenericConstraints(UIDomain uIDomain) {
        this.initGenericConstraints();
        Debug.noteln("UIGr: loading constraint grammar");
        this.uiDomain = uIDomain;
        List list = uIDomain.getAllRefinements();
        if (list == null) {
            return;
        }
        for (Object e : list) {
            List list2 = null;
            if (e instanceof Refinement) {
                list2 = ((Refinement)e).getConstraints();
            } else if (e instanceof UIRefinement) {
                list2 = ((UIRefinement)e).getConstraints();
            }
            this.addGenericConstraints(list2);
        }
    }

    public void addGenericConstraints(Collection collection) {
        if (collection != null) {
            for (Object e : collection) {
                if (!(e instanceof Constraint)) continue;
                GenericConstraint genericConstraint = this.findGenericConstraint((Constraint)e);
                if (genericConstraint == null) {
                    genericConstraint = this.addGenericConstraint((Constraint)e);
                }
                if (genericConstraint == null || genericConstraint.getExample() != null) continue;
                genericConstraint.setExample(((Constraint)e).getParameters());
            }
        }
    }

    public GenericConstraint findGenericConstraint(Constraint constraint) {
        if (constraint == null) {
            return null;
        }
        Symbol symbol = Symbol.intern(constraint.getType() + "-" + constraint.getRelation());
        Object v = this.genericConstraints.get(symbol);
        try {
            return (GenericConstraint)v;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List getAllConstraintPatterns(UIDomain uIDomain) {
        this.loadGenericConstraints(uIDomain);
        return new LinkedList(this.genericConstraints.values());
    }

    public List getConstraintPatterns() {
        return new LinkedList(this.genericConstraints.values());
    }

    public void constructAdded(UIDomainEvent uIDomainEvent) {
    }

    public void constructAdded(DomainEvent domainEvent) {
    }

    public void constructEdited(UIDomainEvent uIDomainEvent) {
    }

    public void constructRemoved(UIDomainEvent uIDomainEvent) {
    }

    public void domainCleared(UIDomainEvent uIDomainEvent) {
        this.initGenericConstraints();
    }

    public void domainEdited(UIDomainEvent uIDomainEvent) {
    }

    public void domainSet(UIDomainEvent uIDomainEvent) {
        this.initGenericConstraints();
    }
}

