/*
 * Decompiled with CFR 0.152.
 */
package ix.iview.tree;

import ix.icore.domain.ObjectClass;
import ix.iface.ui.tree.IXTreeNode;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UIObjectClass;
import ix.iview.tree.DomainTreeModel;
import ix.iview.tree.ObjectClassTreeNode;
import ix.iview.util.IVUtil;
import ix.util.Debug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class ObjectClassTreeModel
extends DomainTreeModel {
    public ObjectClassTreeModel(UIDomain uIDomain, IXTreeNode iXTreeNode) {
        super(uIDomain, iXTreeNode);
    }

    public IXTreeNode newIXTreeNode(Object object) {
        ObjectClassTreeNode objectClassTreeNode = null;
        try {
            objectClassTreeNode = new ObjectClassTreeNode((ObjectClass)object);
        }
        catch (ClassCastException classCastException) {
            try {
                objectClassTreeNode = new ObjectClassTreeNode((UIObjectClass)object);
            }
            catch (ClassCastException classCastException2) {
                Debug.noteln("OcTM: cannot make objectClass tree from class", object.getClass());
            }
        }
        return objectClassTreeNode;
    }

    public List findUserObjects() {
        if (this.uiDomain == null) {
            Debug.noteln("OCTreeModel has no domain");
            return null;
        }
        return this.uiDomain.getAllObjectClasses();
    }

    public Object findUserNode(String string) {
        if (this.uiDomain == null) {
            Debug.noteln("OCTreeModel has no domain");
            return null;
        }
        return this.uiDomain.getNamedObjectClass(string);
    }

    public Object makeUserObject(String string) {
        UIObjectClass uIObjectClass = new UIObjectClass(this.uiDomain, string);
        return uIObjectClass;
    }

    public Object makeUserObject(String string, List list) {
        UIObjectClass uIObjectClass = (UIObjectClass)this.makeUserObject(string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = IVUtil.getRelativeName(iterator.next());
            if (string2 == null) continue;
            uIObjectClass.addChild(string2);
        }
        return uIObjectClass;
    }

    public boolean isOwnUserObject(Object object) {
        return object instanceof UIObjectClass;
    }

    public List getUserChildren(Object object) {
        try {
            Enumeration enumeration = ((UIObjectClass)object).children();
            ArrayList arrayList = Collections.list(enumeration);
            return arrayList;
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            return null;
        }
    }

    public void addUserChild(Object object, Object object2) {
        if (object instanceof UIObjectClass) {
            String string = IVUtil.getRelativeName(object2);
            if (string != null) {
                ((UIObjectClass)object).addChild(string);
            }
        } else {
            Debug.noteln("UCTreeMod: cannot add children to ObjectClass directly");
        }
    }

    public void removeUserChild(Object object, Object object2) {
        if (object instanceof UIObjectClass) {
            String string = IVUtil.getRelativeName(object2);
            if (string != null) {
                ((UIObjectClass)object).removeChild(string);
            }
        } else {
            Debug.noteln("UCTreeMod: cannot remove children from ObjectClass");
        }
    }

    public List getUserParents(Object object) {
        try {
            List list = ((UIObjectClass)object).getParents();
            return list;
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            return null;
        }
    }

    public void addUserParent(Object object, Object object2) {
        if (object instanceof UIObjectClass && object2 instanceof UIObjectClass) {
            if (object2 != null) {
                ((UIObjectClass)object).addParent((UIObjectClass)object2);
            }
        } else {
            Debug.noteln("OCTreeMod: cannot only add parents with UIObjectClasses");
            Debug.noteln(" found " + object.getClass() + " and " + object2.getClass());
        }
    }

    public void removeUserParent(Object object, Object object2) {
        if (object instanceof UIObjectClass) {
            String string = IVUtil.getRelativeName(object2);
            if (string != null) {
                ((UIObjectClass)object).removeParent(string);
            }
        } else {
            Debug.noteln("UCTreeMod: cannot remove parent from ObjectClass");
        }
    }
}

