/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.icore.Status;
import ix.ip2.ActivityHandler;
import ix.ip2.AgendaItem;
import ix.ip2.HandlerAction;
import ix.ip2.Ip2;
import ix.ip2.Ip2ModelManager;
import ix.util.Debug;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.match.MatchEnv;
import ix.util.match.Matcher;
import ix.util.match.SimpleMatcher;
import java.util.LinkedList;
import java.util.List;

public class MatchChoiceHandler
extends ActivityHandler {
    static final Symbol S_MATCH_CHOICE = Symbol.intern("match-choice");
    static final LList activityPattern = (LList)Lisp.readFromString("(match-choice ?pattern = &rest ?values)");
    Ip2 ip2;

    public MatchChoiceHandler(Ip2 ip2) {
        super("Match against choices");
        this.ip2 = ip2;
    }

    public List getSyntaxList() {
        return (LList)Lisp.readFromString("((match-choice ?pattern = ?value ...))");
    }

    public boolean appliesTo(AgendaItem agendaItem) {
        LList lList = agendaItem.getPattern();
        return SimpleMatcher.match(activityPattern, lList) != null;
    }

    public void addHandlerActions(AgendaItem agendaItem) {
        agendaItem.addAction(new MatchChoiceAction(agendaItem));
    }

    class MatchChoiceAction
    extends HandlerAction {
        AgendaItem item;

        MatchChoiceAction(AgendaItem agendaItem) {
            this.item = agendaItem;
            this.shortDescription = "Take Choices";
        }

        public boolean isReady() {
            return true;
        }

        public void handle(AgendaItem agendaItem) {
            Object object2;
            LList lList = agendaItem.getPattern();
            MatchEnv matchEnv = SimpleMatcher.match(activityPattern, lList);
            Debug.expect(matchEnv != null, "activity pattern doesn't match");
            Object v = matchEnv.get(Symbol.intern("?pattern"));
            List list = (List)matchEnv.get(Symbol.intern("?values"));
            Debug.expect(v != null, "lost pattern");
            Debug.expect(list != null, "lost choices");
            LinkedList<MatchEnv> linkedList = new LinkedList<MatchEnv>();
            for (Object object2 : list) {
                MatchEnv matchEnv2 = Matcher.match(v, object2);
                if (matchEnv2 == null || linkedList.contains(matchEnv2)) continue;
                linkedList.add(matchEnv2);
            }
            Debug.expect(!linkedList.isEmpty());
            Debug.noteln("Matches", linkedList);
            Ip2ModelManager ip2ModelManager = (Ip2ModelManager)MatchChoiceHandler.this.ip2.getModelManager();
            object2 = ip2ModelManager.addMatchChoice(linkedList);
            agendaItem.setStatus(Status.COMPLETE);
        }
    }
}

