/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.ip2.Ip2XMLConfig;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.StructuralEquality;
import ix.util.Util;
import ix.util.reflect.ClassSyntax;
import ix.util.xml.FileSyntaxManager;
import ix.util.xml.XML;
import ix.util.xml.XMLConfig;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SerializationTest {
    XMLConfig config = new Ip2XMLConfig();
    ClassSyntax syntax = this.config.defaultClassSyntax();
    StructuralEquality strictEquality = new StrictEquality(this.syntax);
    StructuralEquality flexibleEquality = new FlexibleEquality(this.syntax);

    SerializationTest() {
    }

    public static void main(String[] stringArray) {
        new SerializationTest().do_main(stringArray);
    }

    void do_main(String[] stringArray) {
        Debug.off();
        Parameters.setIsInteractive(false);
        Parameters.processCommandLineArguments(stringArray);
        String string = Parameters.getParameter("directory", "test-domains");
        FileSyntaxManager fileSyntaxManager = XML.fileSyntaxManager();
        File[] fileArray = fileSyntaxManager.getFiles(Object.class, string);
        LinkedList linkedList = new LinkedList();
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                Object object = XML.readObject(fileArray[i].getPath());
                this.traceln("File " + fileArray[i].getName() + " contains a " + object.getClass().getName());
                this.test(object);
                continue;
            }
            catch (Throwable throwable) {
                this.handleException(linkedList, fileArray[i], throwable);
            }
        }
        if (linkedList.isEmpty()) {
            this.traceln("\nNo problems found.");
            System.exit(0);
        } else {
            this.traceln("\nProblems:");
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                this.traceln((String)iterator.next());
            }
            System.exit(1);
        }
    }

    void traceln(String string) {
        System.out.println(string);
    }

    void test(Object object) {
        Object object2 = Util.cloneBySerializing(object);
        Debug.expect(this.strictEquality.equal(object, object2), "Not structurally equal");
    }

    void handleException(List list, File file, Throwable throwable) {
        String string = file.getName() + ":  " + Debug.describeException(throwable);
        list.add(string);
        this.traceln(string);
        if (Debug.on) {
            Debug.displayException(throwable);
        }
    }

    public static class FlexibleEquality
    extends StrictEquality {
        public FlexibleEquality(ClassSyntax classSyntax) {
            super(classSyntax);
        }

        protected boolean haveEquivalentClasses(Object object, Object object2) {
            Class<?> clazz;
            Class<?> clazz2 = object.getClass();
            return clazz2 == (clazz = object2.getClass()) || object instanceof List && object2 instanceof List || object instanceof Set && object2 instanceof Set || object instanceof Map && object2 instanceof Map;
        }
    }

    public static class StrictEquality
    extends StructuralEquality {
        public StrictEquality(ClassSyntax classSyntax) {
            super(classSyntax);
        }

        public boolean equal(Object object, Object object2) {
            boolean bl = super.equal(object, object2);
            if (bl) {
                return bl;
            }
            throw new IllegalArgumentException("Mismatched objects " + object + " and " + object2);
        }
    }
}

