/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.icore.IXAgentExtension;
import ix.icore.process.event.ProcessStatusEvent;
import ix.ip2.Ip2;
import ix.ip2.PanelFrame;
import ix.ip2.StateViewer;
import ix.test.xml.WorldStateExport;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Fn;
import ix.util.Parameters;
import ix.util.xml.XML;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StateExportExtension
implements IXAgentExtension {
    Ip2 ip2;
    StateExporter exporter;
    List exportList;

    public StateExportExtension(Ip2 ip2) {
        this.ip2 = ip2;
    }

    public void installExtension() {
        this.exporter = new StateExporter();
        this.ip2.getModelManager().addProcessStatusListener(this.exporter);
        this.ip2.addResetHook(new ResetHook());
        String string = Parameters.getParameter("state-export-list");
        if (string != null) {
            Iterator iterator = XML.readObject(string);
            if (iterator instanceof List && Collect.every((List)((Object)iterator), Fn.isInstanceOf(WorldStateExport.class))) {
                this.exportList = (List)((Object)iterator);
            } else {
                Debug.warn(string + " did not contain a " + "list of world-state-exports.");
            }
        }
        if (this.exportList != null) {
            for (WorldStateExport worldStateExport : this.exportList) {
                Debug.noteln("Exporting to", (Object)worldStateExport.getDestination());
                Iterator iterator = worldStateExport.getFilters().iterator();
                while (iterator.hasNext()) {
                    Debug.noteln("   ", iterator.next());
                }
            }
        }
    }

    class StateExporter
    implements StateViewer {
        StateExporter() {
        }

        public Component getView(PanelFrame panelFrame) {
            throw new UnsupportedOperationException("getView");
        }

        public void reset() {
        }

        public void statusUpdate(ProcessStatusEvent processStatusEvent) {
        }

        public void newBindings(ProcessStatusEvent processStatusEvent, Map map) {
        }

        public void stateChange(ProcessStatusEvent processStatusEvent, Map map) {
            Debug.noteln("State to consider exporting", (Object)map);
            if (StateExportExtension.this.exportList == null) {
                return;
            }
            for (WorldStateExport worldStateExport : StateExportExtension.this.exportList) {
                worldStateExport.handleStateChange(map, StateExportExtension.this.ip2);
            }
        }

        public void stateDeletion(ProcessStatusEvent processStatusEvent, Map map) {
        }
    }

    class ResetHook
    implements Runnable {
        ResetHook() {
        }

        public void run() {
            Debug.noteln("Resetting", (Object)StateExportExtension.this.exporter);
            StateExportExtension.this.exporter.reset();
        }
    }
}

