/*
 * Decompiled with CFR 0.152.
 */
package ix.test.xml;

import ix.icore.domain.Domain;
import ix.icore.plan.Plan;
import ix.iplan.AutoTester;
import ix.iplan.PlanCheckingSimulator;
import ix.iplan.PlanTest;
import ix.iplan.Slip;
import ix.test.BlockStacker;
import ix.test.HtnBlockStacker;
import ix.test.PrecondBlockStacker;
import java.util.List;
import java.util.Map;

public class BlockStackingTest
extends PlanTest {
    String problem;

    public String getProblem() {
        return this.problem;
    }

    public void setProblem(String string) {
        this.problem = string;
    }

    public void setTask(String string) {
        throw new UnsupportedOperationException();
    }

    public void setInitialPlan(String string) {
        throw new UnsupportedOperationException();
    }

    public String testDescription() {
        return "Domain " + this.getDomain() + ", Problem " + this.getProblem();
    }

    public String taskDescription() {
        return this.getProblem();
    }

    public AutoTester.TestRunner makeTestRunner(AutoTester autoTester) {
        return new BlockTestRunner(this, autoTester);
    }

    static class BlockTestRunner
    extends AutoTester.TestRunner {
        AutoTester auto;
        BlockStacker stacker;
        BlockStackingTest test;

        BlockTestRunner(BlockStackingTest blockStackingTest, AutoTester autoTester) {
            AutoTester autoTester2 = autoTester;
            autoTester2.getClass();
            super(blockStackingTest);
            this.auto = autoTester;
            this.test = blockStackingTest;
        }

        protected Domain readDomain() {
            Domain domain = super.readDomain();
            this.stacker = this.makeBlockStacker(domain);
            Domain domain2 = this.stacker.problemDomain();
            domain2.takeFrom(domain);
            return domain2;
        }

        private BlockStacker makeBlockStacker(Domain domain) {
            return domain.getAnnotation(Slip.S_ACHIEVABLE_CONDS) == Slip.K_NONE ? new HtnBlockStacker(this.test.getProblem()) : new PrecondBlockStacker(this.test.getProblem());
        }

        protected Plan initialPlan() {
            return this.stacker.initialPlan();
        }

        protected Map runSimulation(PlanCheckingSimulator planCheckingSimulator) {
            Map map = super.runSimulation(planCheckingSimulator);
            List list = this.stacker.failedGoalPatterns(planCheckingSimulator.getWorldStateMap());
            if (!list.isEmpty()) {
                this.auto.testFailure(this.test, "False patterns " + list);
            } else {
                this.auto.traceln("World state is correct");
            }
            return map;
        }
    }
}

