/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class AgentLauncher {
    Map parameters = new HashMap();
    String agentClassName;
    String[] agent_argv = new String[0];
    String jarPath;
    ClassLoader loader;

    public static void main(String[] stringArray) throws Exception {
        AgentLauncher agentLauncher = new AgentLauncher();
        try {
            stringArray = agentLauncher.getArgv(stringArray);
            agentLauncher.startAgent(stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(null, throwable.toString(), "Exception", 0);
                }
            });
        }
    }

    String[] getArgv(String[] stringArray) throws InterruptedException, InvocationTargetException {
        if (stringArray.length == 0) {
            String string = this.findIxDir();
            final String string2 = "-jar-path=" + this.makeDefaultJarPath(string) + " ix.ip2.Ip2";
            final String[] stringArray2 = new String[]{""};
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    stringArray2[0] = JOptionPane.showInputDialog("Command line", (Object)string2);
                }
            });
            if (stringArray2[0] == null || stringArray2[0].equals("")) {
                System.exit(0);
            }
            List list = AgentLauncher.breakAt(" ", stringArray2[0]);
            stringArray = list.toArray(new String[list.size()]);
        }
        return stringArray;
    }

    String findIxDir() {
        if (new File("ix.jar").exists()) {
            return "";
        }
        if (new File("../../ix.jar").exists()) {
            return "../../";
        }
        return null;
    }

    String makeDefaultJarPath(String string) {
        if (string == null) {
            return "ix.jar:imports";
        }
        return string + "ix.jar" + ":" + string + "imports";
    }

    public void startAgent(String[] stringArray) throws Exception {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-")) {
                String string = stringArray[i].substring(1);
                List list = AgentLauncher.breakAt("=", string);
                String string2 = (String)list.get(0);
                String string3 = (String)list.get(1);
                this.parameters.put(string2, string3);
                continue;
            }
            this.agentClassName = stringArray[i++];
            int n = stringArray.length - i;
            this.agent_argv = new String[n];
            int n2 = 0;
            while (i < stringArray.length) {
                this.agent_argv[n2] = stringArray[i];
                ++n2;
                ++i;
            }
            break;
        }
        if (this.agentClassName == null) {
            throw new IllegalArgumentException("No agent class name was specified");
        }
        System.out.println("Launcher parameters " + this.parameters);
        System.out.println("Agent class " + this.agentClassName);
        System.out.println("Agent args " + Arrays.asList(this.agent_argv));
        this.jarPath = (String)this.parameters.get("jar-path");
        this.loader = this.makeLoader(this.jarPath == null ? "" : this.jarPath);
        this.startAgent(this.agentClassName, this.agent_argv);
    }

    public void startAgent(String string, String[] stringArray) throws Exception {
        Class<?> clazz = this.loader.loadClass(string);
        Class[] classArray = new Class[]{stringArray.getClass()};
        Method method = clazz.getMethod("main", classArray);
        method.invoke(null, new Object[]{stringArray});
    }

    URLClassLoader makeLoader(String string) throws MalformedURLException, FileNotFoundException {
        List list = AgentLauncher.breakAt(":", string);
        LinkedList<URL> linkedList = new LinkedList<URL>();
        for (String string2 : list) {
            File file = new File(string2);
            if (!file.exists()) {
                throw new FileNotFoundException("Jar-path entry " + string2 + " does not exist.");
            }
            if (string2.endsWith(".jar")) {
                linkedList.add(file.toURL());
                continue;
            }
            File[] fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.getName().endsWith(".jar");
                }
            });
            if (fileArray == null) {
                throw new IllegalArgumentException("Problem with jar-path entry " + string2);
            }
            if (fileArray.length == 0) {
                linkedList.add(file.toURL());
                continue;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                linkedList.add(fileArray[i].toURL());
            }
        }
        System.out.println("Jar-path " + linkedList);
        URL[] uRLArray = linkedList.toArray(new URL[linkedList.size()]);
        return new AgentClassLoader(uRLArray);
    }

    private static List breakAt(String string, String string2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        int n = string2.length();
        if (n == 0) {
            return linkedList;
        }
        int n2 = string2.indexOf(string);
        if (n2 < 0) {
            linkedList.add(string2);
            return linkedList;
        }
        int n3 = string.length();
        int n4 = 0;
        while (n2 >= 0) {
            linkedList.add(string2.substring(n4, n2));
            n4 = n2 + n3;
            if (n4 == n) break;
            n2 = string2.indexOf(string, n4);
        }
        linkedList.add(string2.substring(n4));
        return linkedList;
    }

    static class AgentClassLoader
    extends URLClassLoader {
        AgentClassLoader(URL[] uRLArray) {
            super(uRLArray);
        }

        public Class loadClass(String string) throws ClassNotFoundException {
            return this.loadClass(string, false);
        }

        protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            if (string.startsWith("java.") || string.startsWith("javax.") || string.startsWith("sun.")) {
                return super.loadClass(string, bl);
            }
            Class<?> clazz = this.findLoadedClass(string);
            if (clazz == null) {
                clazz = this.findClass(string);
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }
}

