/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.iface.util.XColors;
import ix.util.Debug;
import ix.util.RethrownException;
import ix.util.Strings;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class ColorGenerator {
    protected Map objectToColorMap = new HashMap();
    protected int niceColorsUsed = 0;
    protected int[] niceColors = new int[]{0x228B22, 0x8B0000, 12092939, 9055202, 35723, 0xFF6666, 10506797, 49151, 65407, 13047173, 0x808000, 128, 52945, 16729344, 0xFFCC33, 10145074};

    public Color genColor(Object object) {
        Color color = (Color)this.objectToColorMap.get(object);
        if (color == null) {
            color = this.nextColor();
            this.setColor(object, color);
        }
        Debug.noteln("Color for " + object + " = " + color);
        return color;
    }

    public Color getColor(Object object) {
        return this.getColor(object, null);
    }

    public Color getColor(Object object, Color color) {
        Color color2 = (Color)this.objectToColorMap.get(object);
        return color2 == null ? color : color2;
    }

    public void setColor(Object object, Color color) {
        this.objectToColorMap.put(object, color);
    }

    public void setColor(Object object, int n) {
        this.setColor(object, new Color(n));
    }

    public void setColor(Object object, String string) {
        this.setColor(object, ColorGenerator.getNamedColor(string));
    }

    public static Color getNamedColor(String string) {
        try {
            Field field = XColors.class.getField(Strings.capitalize(string));
            return (Color)field.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException("Cannot find a color named " + Strings.quote(string));
        }
        catch (Exception exception) {
            throw new RethrownException(exception);
        }
    }

    public Color nextColor() {
        return new Color(this.nextRGB());
    }

    public int nextRGB() {
        if (this.niceColorsUsed >= this.niceColors.length) {
            Debug.warn("Out of nice colors in " + this);
            return 0xFF0000;
        }
        return this.niceColors[this.niceColorsUsed++];
    }
}

