/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.ConsistencyException;
import ix.util.DirectedGraph;
import ix.util.TransitiveClosure;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DAGTransitiveClosure
implements TransitiveClosure {
    DirectedGraph baseGraph;
    Map successorMap = new HashMap();
    protected Object START_MARK = new Object(){

        public String toString() {
            return "#<TransitiveClosure START_MARK>";
        }
    };

    public DAGTransitiveClosure(DirectedGraph directedGraph) {
        this.baseGraph = directedGraph;
        this.computeTransitiveClosure();
    }

    public Collection getAllNodes() {
        return this.baseGraph.getAllNodes();
    }

    public Collection getRoots() {
        return this.baseGraph.getRoots();
    }

    public Collection getSuccessors(Object object) {
        return (Set)this.successorMap.get(object);
    }

    public boolean isBefore(Object object, Object object2) {
        return this.getSuccessors(object).contains(object2);
    }

    protected void computeTransitiveClosure() {
        this.walk(this.baseGraph.getRoots());
    }

    protected void walk(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.walkVertex(iterator.next());
        }
    }

    protected void walkVertex(Object object) {
        Object v = this.successorMap.get(object);
        if (v == this.START_MARK) {
            throw new ConsistencyException("Cycle at", object);
        }
        if (!(v instanceof Set)) {
            this.successorMap.put(object, this.START_MARK);
            Collection collection = this.baseGraph.getSuccessors(object);
            this.walk(collection);
            HashSet hashSet = new HashSet();
            for (Object e : collection) {
                Set set = (Set)this.successorMap.get(e);
                hashSet.add(e);
                hashSet.addAll(set);
            }
            this.successorMap.put(object, hashSet);
        }
    }
}

