/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.Proc;
import java.util.LinkedList;
import java.util.List;

public class MessageQueue {
    List contents = new LinkedList();
    boolean returnInterrupts = false;

    public MessageQueue() {
        this(false);
    }

    public MessageQueue(boolean bl) {
        this.returnInterrupts = bl;
    }

    public synchronized void send(Object object) {
        this.contents.add(object);
        this.notifyAll();
    }

    public synchronized void sendIfNew(Object object) {
        if (!this.contents.contains(object)) {
            this.contents.add(object);
            this.notifyAll();
        }
    }

    public synchronized void push(Object object) {
        this.contents.add(0, object);
        this.notifyAll();
    }

    public synchronized Object nextMessage() {
        while (this.contents.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                if (!this.returnInterrupts) continue;
                return interruptedException;
            }
        }
        return this.contents.remove(0);
    }

    public synchronized boolean waitForMessage() {
        if (this.contents.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return !this.contents.isEmpty();
    }

    public synchronized boolean waitForMessage(long l) {
        if (this.contents.isEmpty()) {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return !this.contents.isEmpty();
    }

    public synchronized boolean hasMessage() {
        return !this.contents.isEmpty();
    }

    public synchronized void callOnContents(Proc proc) {
        proc.call(this.contents);
    }

    public synchronized void clear() {
        this.contents.clear();
    }
}

