/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.Collect;
import ix.util.Debug;
import ix.util.Gensym;
import ix.util.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class NameMapper {
    Gensym.Generator gensym = new Gensym.Generator();
    protected Map longToShort = new HashMap();
    protected Map shortToLong = new HashMap();

    public NameMapper() {
    }

    public NameMapper(Map map) {
        this.shortToLong = new HashMap(map);
        this.longToShort = Collect.transposeMap(this.shortToLong);
    }

    public boolean hasShortName(String string) {
        return this.longToShort.containsKey(string);
    }

    public String shortName(String string) {
        String string2 = (String)this.longToShort.get(string);
        if (string2 == null) {
            throw new IllegalArgumentException("Unknown long name " + Strings.quote(string));
        }
        return string2;
    }

    public boolean hasLongName(String string) {
        return this.shortToLong.containsKey(string);
    }

    public String longName(String string) {
        String string2 = (String)this.shortToLong.get(string);
        if (string2 == null) {
            throw new IllegalArgumentException("Unknown short name " + Strings.quote(string));
        }
        return string2;
    }

    public Map getShortToLongMap() {
        return Collections.unmodifiableMap(this.shortToLong);
    }

    public Map getLongToShortMap() {
        return Collections.unmodifiableMap(this.longToShort);
    }

    public void setMapping(String string, String string2) {
        this.longToShort.put(string, string2);
        this.shortToLong.put(string2, string);
    }

    public String mapLongName(Object object) {
        return this.mapLongName(object.toString());
    }

    public String mapLongName(String string) {
        String string2 = (String)this.longToShort.get(string);
        if (string2 == null) {
            string2 = this.generateShortName(string);
            this.setMapping(string, string2);
        }
        Debug.noteln("Short name for " + Strings.quote(string) + " = " + Strings.quote(string2));
        return string2;
    }

    public String generateShortName(String string) {
        String string2 = this.plausibleShortName(string);
        String string3 = (String)this.shortToLong.get(string2);
        if (string3 == null) {
            return string2;
        }
        Debug.expect(!string3.equals(string), "shouldn't have needed a short name for", string);
        string2 = this.gensym.nextString(string2);
        Debug.expect(string2.length() > 0, "empty plausible name for", string);
        Debug.expect(this.shortToLong.get(string2) == null, "generated string is not unique", string2);
        return string2;
    }

    public String plausibleShortName(String string) {
        if (this.hasSeparator(string, 35)) {
            return Strings.afterLast("#", string);
        }
        if (this.hasSeparator(string, 47)) {
            String string2 = Strings.afterLast("/", string);
            return Strings.beforeLast(".", string2);
        }
        if (this.hasSeparator(string, 92)) {
            String string3 = Strings.afterLast("\\", string);
            return Strings.beforeLast(".", string3);
        }
        return string;
    }

    protected boolean hasSeparator(String string, int n) {
        int n2 = string.indexOf(n);
        return n2 >= 0 && n2 < string.length() - 1;
    }
}

