/*
 * Decompiled with CFR 0.152.
 */
package ix.util.http;

import ix.util.Debug;
import ix.util.Fn1;
import ix.util.Parameters;
import ix.util.RethrownIOException;
import ix.util.Strings;
import ix.util.Util;
import ix.util.http.HttpRequestException;
import ix.util.http.HttpUtilities;
import ix.util.lisp.Lisp;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpObjectClient {
    protected HttpUtilities util = new HttpUtilities();
    protected String requestContentType = "application/xml";
    protected String requestCharsetName = "UTF-8";

    public void setRequestContentType(String string) {
        this.requestContentType = string;
    }

    public void setRequestCharsetName(String string) {
        this.requestCharsetName = string;
    }

    public Object sendRequest(URL uRL, Object object) throws RethrownIOException {
        try {
            return this.do_sendRequest(uRL, object);
        }
        catch (IOException iOException) {
            throw new RethrownIOException("Trouble requesting an object from " + uRL + ":", iOException);
        }
    }

    private Object do_sendRequest(URL uRL, Object object) throws IOException, HttpRequestException {
        Debug.noteln("Sending to", (Object)uRL);
        Debug.noteln("Contents:", object);
        byte[] byArray = this.encodeForSend(object);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        this.sendBytes(byArray, uRL, httpURLConnection);
        this.describeResponse(httpURLConnection);
        if (this.handleResponseCode(httpURLConnection)) {
            return this.decodeReceived(this.readReply(httpURLConnection));
        }
        return null;
    }

    protected byte[] encodeForSend(Object object) throws UnsupportedEncodingException {
        return this.util.encodeForSend(object, this.requestCharsetName);
    }

    protected void sendBytes(byte[] byArray, URL uRL, HttpURLConnection httpURLConnection) throws IOException {
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Length", "" + byArray.length);
        httpURLConnection.setRequestProperty("Content-Type", this.requestContentType + "; charset=" + this.requestCharsetName);
        httpURLConnection.setRequestProperty("Host", uRL.getHost() + ":" + uRL.getPort());
        httpURLConnection.connect();
        OutputStream outputStream = httpURLConnection.getOutputStream();
        outputStream.write(byArray);
        outputStream.flush();
        outputStream.close();
    }

    protected void describeResponse(HttpURLConnection httpURLConnection) throws IOException {
        Debug.noteln("\nResponse:", (Object)(httpURLConnection.getResponseCode() + " " + httpURLConnection.getResponseMessage()));
        Debug.noteln("\nReply Headers:");
        for (Map.Entry<String, List<String>> entry : httpURLConnection.getHeaderFields().entrySet()) {
            Debug.noteln(entry.getKey() + ": " + entry.getValue());
        }
    }

    protected boolean handleResponseCode(HttpURLConnection httpURLConnection) throws HttpRequestException, IOException {
        int n = httpURLConnection.getResponseCode();
        String string = httpURLConnection.getResponseMessage();
        return this.handleResponseCode(n, string);
    }

    protected boolean handleResponseCode(int n, String string) throws HttpRequestException {
        if (n == 200) {
            return true;
        }
        Debug.noteln("Rejecting response " + n + " " + string);
        throw new HttpRequestException(n, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readReply(HttpURLConnection httpURLConnection) throws EOFException, IOException {
        InputStream inputStream = httpURLConnection.getInputStream();
        String string = httpURLConnection.getContentType();
        String string2 = this.util.getContentCharset(string);
        int n = httpURLConnection.getContentLength();
        try {
            String string3 = this.util.readContent(inputStream, n, string2);
            Debug.noteln("\nReply:\n", (Object)string3);
            String string4 = string3;
            return string4;
        }
        finally {
            inputStream.close();
        }
    }

    protected Object decodeReceived(String string) {
        return this.util.decodeReceived(string);
    }

    public static void main(String[] stringArray) throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class LispParser
        implements Fn1<String, Object> {
            LispParser() {
            }

            @Override
            public Object funcall(String string) {
                return Lisp.readFromString(string);
            }
        }
        HttpObjectClient.mainLoop(stringArray, new HttpObjectClient(), new LispParser());
    }

    protected static void mainLoop(String[] stringArray, HttpObjectClient httpObjectClient, Fn1<String, Object> fn1) throws Exception {
        Parameters.processCommandLineArguments(stringArray);
        URL uRL = new URL(Parameters.getParameter("url"));
        String string;
        while (!(string = Util.askLines("\nContent:")).equals("")) {
            Object object = fn1.funcall(string);
            Object object2 = httpObjectClient.sendRequest(uRL, object);
            System.out.println(object2.getClass() + " reply:\n");
            System.out.println(Strings.quote(object2.toString()));
        }
        return;
    }
}

