/*
 * Decompiled with CFR 0.152.
 */
package ix.util.lisp;

import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.LListIterator;
import ix.util.lisp.Lisp;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LListListIterator
extends LListIterator
implements ListIterator {
    protected LList list = null;
    protected int index = 0;
    protected Cons setPoint = null;

    public LListListIterator(LList lList) {
        super(lList);
        this.list = lList;
    }

    public LListListIterator(LList lList, int n) {
        super(lList);
        this.list = lList;
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        while (this.at != Lisp.NIL && this.index < n) {
            this.at = this.at.cdr();
            ++this.index;
        }
        if (this.index != n) {
            throw new IndexOutOfBoundsException();
        }
    }

    public LListListIterator(LListListIterator lListListIterator) {
        super(lListListIterator);
        this.list = lListListIterator.list;
        this.index = lListListIterator.index;
        this.setPoint = lListListIterator.setPoint;
    }

    public boolean hasNext() {
        return this.at != Lisp.NIL;
    }

    public Object next() {
        if (this.at != Lisp.NIL) {
            Object object = this.at.car();
            this.setPoint = (Cons)this.at;
            ++this.index;
            this.at = this.at.cdr();
            return object;
        }
        throw new NoSuchElementException("at end of LList");
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public Object previous() {
        if (this.index > 0) {
            --this.index;
            this.at = this.at == Lisp.NIL ? this.list.lastCons() : LListListIterator.theCdrBefore((Cons)this.at, this.list);
            this.setPoint = (Cons)this.at;
            return this.at.car();
        }
        throw new NoSuchElementException("at start of LList");
    }

    protected static final Cons theCdrBefore(Cons cons, LList lList) {
        for (LList lList2 = lList; lList2 != Lisp.NIL; lList2 = lList2.cdr()) {
            if (lList2.cdr() != cons) continue;
            return (Cons)lList2;
        }
        throw new IllegalArgumentException("Can't find list tail");
    }

    public int nextIndex() {
        return this.index;
    }

    public int previousIndex() {
        return this.index - 1;
    }

    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from an LList");
    }

    public void set(Object object) {
        if (this.setPoint == null) {
            throw new IllegalStateException("set without next or previous");
        }
        this.setPoint.setCar(object);
    }

    public void add(Object object) {
        throw new UnsupportedOperationException("Cannot add to an LList");
    }
}

