/*
 * Decompiled with CFR 0.152.
 */
package ix.util.rdf;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import ix.icore.Activity;
import ix.icore.Issue;
import ix.icore.Priority;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.StructuralEquality;
import ix.util.lisp.Lisp;
import ix.util.rdf.ModelParser;
import ix.util.rdf.ObjectModel;
import ix.util.rdf.Rdf;
import ix.util.reflect.ClassSyntax;
import ix.util.xml.Loader;
import ix.util.xml.Saver;
import ix.util.xml.XML;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class RdfTranslator
implements Loader,
Saver {
    protected ClassSyntax classSyntax = Rdf.classSyntax();

    public String objectToString(Object object) {
        return this.modelToString(this.objectToModel(object));
    }

    public String modelToString(Model model) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        model.write((OutputStream)byteArrayOutputStream, "RDF/XML-ABBREV");
        try {
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new RethrownException(iOException);
        }
        return ((Object)byteArrayOutputStream).toString();
    }

    public Model objectToModel(Object object) {
        ObjectModel objectModel = new ObjectModel(this, object);
        Model model = objectModel.getModel();
        return model;
    }

    public void writeObject(Object object, File file) throws IOException {
        Model model = this.objectToModel(object);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        model.write((OutputStream)new BufferedOutputStream(fileOutputStream), "RDF/XML-ABBREV");
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
    }

    public Object objectFromString(String string) {
        return this.objectFromModel(this.modelFromString(string));
    }

    public Model modelFromString(String string) {
        Model model = ModelFactory.createDefaultModel();
        return model.read((Reader)new StringReader(string), null);
    }

    public Object objectFromModel(Model model) {
        ModelParser modelParser = new ModelParser(this, model);
        return modelParser.getRootObject();
    }

    public Object readObject(URL uRL) {
        Model model = ModelFactory.createDefaultModel();
        return this.objectFromModel(model.read(uRL.toString()));
    }

    public static void main(String[] stringArray) throws IOException {
        Parameters.processCommandLineArguments(stringArray);
        RdfTranslator rdfTranslator = new RdfTranslator();
        String string = Parameters.getParameter("file");
        if (string != null) {
            Object object = XML.readObject(string);
            rdfTranslator.test(object);
            return;
        }
        String string2 = rdfTranslator.modelToString(ModelFactory.createDefaultModel());
        System.out.println(string2);
        Model model = rdfTranslator.modelFromString(string2);
        System.out.println(rdfTranslator.modelToString(model));
        rdfTranslator.test(null);
        rdfTranslator.test("Applie pie is nice to eat");
        rdfTranslator.test("Apple <i>pie</i> is nice to eat.");
        rdfTranslator.test(Priority.HIGH);
        rdfTranslator.test(new Issue());
        rdfTranslator.test(new Long(12L));
        rdfTranslator.test(Lisp.NIL);
        rdfTranslator.test(Lisp.list("apple", "pie"));
        rdfTranslator.test(Lisp.readFromString("(2 or 3 pies)"));
        rdfTranslator.test(Lisp.list(new Issue(), new Activity()));
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        rdfTranslator.test(treeMap);
        treeMap.put("apple", "red");
        treeMap.put("grass", "green");
        treeMap.put("snow", "white");
        rdfTranslator.test(treeMap);
        TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
        treeMap2.put("tasty", "apple");
        rdfTranslator.test(Lisp.list(treeMap, treeMap2));
    }

    void test(Object object) {
        System.out.println("- - - - - - - - - - - - - - - - - - - -");
        StructEq structEq = new StructEq(this.classSyntax);
        try {
            Model model = this.objectToModel(object);
            System.out.println(this.modelToString(model));
            Object object2 = this.objectFromModel(model);
            System.out.println(object2);
            Debug.expect(structEq.equal(object, object2), "Not structurally equal");
        }
        catch (Throwable throwable) {
            Debug.displayException(throwable);
        }
    }

    static class StructEq
    extends StructuralEquality {
        StructEq(ClassSyntax classSyntax) {
            super(classSyntax);
        }

        protected boolean haveEquivalentClasses(Object object, Object object2) {
            Class<?> clazz;
            Class<?> clazz2 = object.getClass();
            return clazz2 == (clazz = object2.getClass()) || object instanceof List && object2 instanceof List || object instanceof Set && object2 instanceof Set || object instanceof Map && object2 instanceof Map;
        }
    }
}

