/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.util.Debug;
import ix.util.Strings;
import ix.util.Util;
import ix.util.xml.FileSyntax;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;

public abstract class AbstractFileSyntax
implements FileSyntax {
    public static final List ANY_CLASS = Collections.singletonList(Object.class);

    public boolean isAvailable() {
        return true;
    }

    public boolean canRead() {
        return false;
    }

    public boolean canWrite() {
        return false;
    }

    public List readableClasses() {
        return ANY_CLASS;
    }

    public List writableClasses() {
        return ANY_CLASS;
    }

    public Object readObject(URL uRL) throws IOException {
        throw new UnsupportedOperationException("Cannot read " + this.getFileTypeDescription());
    }

    public void writeObject(Object object, File file) throws IOException {
        throw new UnsupportedOperationException("Cannot write " + this.getFileTypeDescription());
    }

    public String toString() {
        return Strings.afterLast(".", this.getClass().getName()) + "[" + this.getFileTypeDescription() + " " + this.getFileTypes() + "]";
    }

    protected boolean existsClass(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return false;
        }
        catch (Throwable throwable) {
            Debug.displayException(throwable);
            return false;
        }
    }

    protected Object makeInstance(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return Util.makeInstance(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedOperationException("This agent cannot handle " + this.getFileTypeDescription());
        }
    }
}

