/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.util.lisp.Lisp;
import ix.util.xml.AbstractFileSyntax;
import ix.util.xml.Loader;
import ix.util.xml.Saver;
import ix.util.xml.XML;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;

public interface FileSyntax
extends Loader,
Saver {
    public List getFileTypes();

    public String getFileTypeDescription();

    public boolean isAvailable();

    public boolean canRead();

    public boolean canWrite();

    public List readableClasses();

    public List writableClasses();

    public static class RDFFiles
    extends AbstractFileSyntax {
        private List types = Lisp.list("rdf", "owl");

        public List getFileTypes() {
            return this.types;
        }

        public String getFileTypeDescription() {
            return "RDF and OWL files";
        }

        public boolean isAvailable() {
            return this.existsClass("ix.util.rdf.RdfTranslator") && this.existsClass("com.hp.hpl.jena.rdf.model.Model");
        }

        public boolean canRead() {
            return true;
        }

        public boolean canWrite() {
            return true;
        }

        public Object readObject(URL uRL) throws IOException {
            Loader loader = (Loader)this.getTranslator();
            return loader.readObject(uRL);
        }

        public void writeObject(Object object, File file) throws IOException {
            Saver saver = (Saver)this.getTranslator();
            saver.writeObject(object, file);
        }

        protected Object getTranslator() {
            return this.makeInstance("ix.util.rdf.RdfTranslator");
        }
    }

    public static class XMLFiles
    extends AbstractFileSyntax {
        private List types = Lisp.list("xml");

        public List getFileTypes() {
            return this.types;
        }

        public String getFileTypeDescription() {
            return "XML files";
        }

        public boolean canRead() {
            return true;
        }

        public boolean canWrite() {
            return true;
        }

        public Object readObject(URL uRL) throws IOException {
            return XML.defaultTranslator().readObject(uRL);
        }

        public void writeObject(Object object, File file) throws IOException {
            XML.defaultTranslator().writeObject(object, file);
        }
    }
}

