/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Fn;
import ix.util.Function1;
import ix.util.ListOf;
import ix.util.SemiPrimitive;
import ix.util.Strings;
import ix.util.TypedList;
import ix.util.Util;
import ix.util.WithCleanup;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.reflect.ClassDescr;
import ix.util.reflect.ClassFinder;
import ix.util.reflect.ClassSyntax;
import ix.util.reflect.FieldDescr;
import ix.util.reflect.Stringer;
import ix.util.xml.LiteralDocument;
import ix.util.xml.Loader;
import ix.util.xml.Saver;
import ix.util.xml.XML;
import ix.util.xml.XMLException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;

public class XMLTranslator
implements Loader,
Saver {
    protected ClassSyntax classSyntax;
    protected XMLOutputter outputter = XML.makePrettyXMLOutputter();
    protected Function1 prefilter = null;
    protected Function1 postfilter = null;
    protected String implAttributeName;
    protected String mapEntryName;
    protected boolean omitImplAttributes = false;
    protected Element lastExaminedElement = null;
    protected Class defaultListClass = LinkedList.class;
    protected Class defaultSetClass = HashSet.class;
    protected Class defaultMapClass = HashMap.class;
    protected boolean requireNamespace = false;
    protected Namespace homeNamespace = XML.config().getHomeNamespace();
    protected String homeNamespaceURI = this.homeNamespace.getURI();
    protected Namespace mostRecentHomeNamespace = this.homeNamespace;

    public XMLTranslator() {
        this(XML.config().defaultClassSyntax());
    }

    public XMLTranslator(ClassSyntax classSyntax) {
        this.classSyntax = classSyntax;
        this.implAttributeName = this.classSyntax.externalNameForField("implClass");
        this.mapEntryName = this.classSyntax.getClassFinder().externalName("MapEntry");
    }

    public ClassSyntax getClassSyntax() {
        return this.classSyntax;
    }

    public XMLOutputter getOutputter() {
        return this.outputter;
    }

    public void setPrefilter(Function1 function1) {
        this.prefilter = function1;
    }

    public void setPostfilter(Function1 function1) {
        this.postfilter = function1;
    }

    public void setOmitImplAttributes(boolean bl) {
        this.omitImplAttributes = bl;
    }

    public Namespace getHomeNamespace() {
        return this.homeNamespace;
    }

    protected Element nsElement(String string) {
        return new Element(string, this.homeNamespace);
    }

    public void setRequireNamespace(boolean bl) {
        this.requireNamespace = bl;
    }

    protected boolean isHomeNamespace(Namespace namespace) {
        if (namespace == this.mostRecentHomeNamespace) {
            return true;
        }
        if (this.isHomeNamespaceURI(namespace.getURI())) {
            this.mostRecentHomeNamespace = namespace;
            return true;
        }
        return false;
    }

    protected boolean isHomeNamespaceURI(String string) {
        return string.startsWith(this.homeNamespaceURI);
    }

    public void writeObject(Object object, File file) throws IOException {
        final Document document = this.objectToDocument(object);
        final BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        final XMLOutputter xMLOutputter = XML.makePrettyXMLOutputter();
        Util.run(new WithCleanup(){

            public void body() throws IOException {
                xMLOutputter.output(document, bufferedOutputStream);
                bufferedOutputStream.flush();
            }

            public void cleanup() throws IOException {
                bufferedOutputStream.close();
            }
        });
    }

    public String objectToXMLString(Object object) {
        return this.documentToXMLString(this.objectToDocument(object));
    }

    public synchronized String documentToXMLString(Document document) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.outputter.output(document, (Writer)stringWriter);
        }
        catch (IOException iOException) {
            Debug.noteException(iOException);
            throw new XMLException("Can't convert " + document + " to string", iOException);
        }
        stringWriter.flush();
        return stringWriter.toString();
    }

    public synchronized Document objectToDocument(Object object) {
        return new Document(this.objectToElement(object));
    }

    protected Element objectToElement(Object object) {
        if (this.prefilter != null) {
            object = this.prefilter.funcall(object);
        }
        if (object == null) {
            return this.nsElement("null");
        }
        if (object instanceof String) {
            return this.stringToElement(object);
        }
        ClassDescr classDescr = this.classSyntax.getClassDescr(object.getClass());
        if (classDescr.isPrimitive()) {
            return this.primitiveObjectToElement(object);
        }
        if (classDescr.isList()) {
            return this.listToElement(object);
        }
        if (classDescr.isSet()) {
            return this.setToElement(object);
        }
        if (classDescr.isMap()) {
            return this.mapToElement(object);
        }
        if (classDescr.isStruct()) {
            return this.structToElement(object);
        }
        if (classDescr.isXML()) {
            return this.embeddedXMLToElement(object);
        }
        throw new ConsistencyException("Unknown type " + classDescr);
    }

    protected Element primitiveObjectToElement(Object object) {
        Class<?> clazz = object.getClass();
        String string = this.classSyntax.externalNameForClass(clazz);
        Stringer stringer = this.classSyntax.getStringer(clazz);
        String string2 = stringer != null ? stringer.toString(object) : object.toString();
        Element element = this.nsElement(string);
        element.setText(string2);
        return element;
    }

    protected Element stringToElement(Object object) {
        return this.primitiveObjectToElement(object);
    }

    protected Element embeddedXMLToElement(Object object) {
        LiteralDocument literalDocument = (LiteralDocument)object;
        String string = this.classSyntax.externalNameForClass(LiteralDocument.class);
        Element element = this.nsElement(string);
        Element element2 = (Element)literalDocument.getRootElement().clone();
        element.addContent((Content)element2);
        return element;
    }

    protected Element listToElement(Object object) {
        return this.collectionToElement(List.class, (List)object);
    }

    protected Element setToElement(Object object) {
        return this.collectionToElement(Map.class, (Set)object);
    }

    protected Element collectionToElement(Class clazz, Collection collection) {
        Class<?> clazz2 = collection.getClass();
        String string = this.classSyntax.externalNameForClass(clazz2);
        String string2 = this.classSyntax.externalNameForClass(clazz);
        Element element = this.nsElement(string2);
        if (!this.omitImplAttributes) {
            this.setImplAttribute(element, string);
        }
        for (Object e : collection) {
            element.addContent((Content)this.objectToElement(e));
        }
        return element;
    }

    protected Element mapToElement(Object object) {
        Map map = (Map)object;
        Class<?> clazz = map.getClass();
        String string = this.classSyntax.externalNameForClass(clazz);
        String string2 = this.classSyntax.externalNameForClass(Map.class);
        Element element = this.nsElement(string2);
        if (!this.omitImplAttributes) {
            this.setImplAttribute(element, string);
        }
        for (Map.Entry entry : map.entrySet()) {
            Element element2 = this.nsElement(this.mapEntryName);
            Element element3 = this.nsElement("key");
            Element element4 = this.nsElement("value");
            element.addContent((Content)element2);
            element2.addContent((Content)element3);
            element2.addContent((Content)element4);
            element3.addContent((Content)this.objectToElement(entry.getKey()));
            element4.addContent((Content)this.objectToElement(entry.getValue()));
        }
        return element;
    }

    protected void setImplAttribute(Element element, String string) {
        element.setAttribute(this.implAttributeName, string);
    }

    protected Element structToElement(Object object) {
        Class<?> clazz = object.getClass();
        ClassDescr classDescr = this.classSyntax.getClassDescr(clazz);
        String string = classDescr.getExternalName();
        Element element = this.nsElement(string);
        for (FieldDescr fieldDescr : classDescr.getFieldDescrs()) {
            this.visitField(object, fieldDescr, element);
        }
        return element;
    }

    protected void visitField(Object object, FieldDescr fieldDescr, Element element) {
        String string = fieldDescr.getExternalName();
        try {
            Object object2 = fieldDescr.getValue(object);
            if (object2 == null) {
                return;
            }
            Class clazz = fieldDescr.getType();
            if (this.isAttributeClass(clazz)) {
                Stringer stringer = this.classSyntax.getStringer(clazz);
                String string2 = stringer != null ? stringer.toString(object2) : object2.toString();
                element.setAttribute(string, string2);
            } else {
                Element element2 = this.nsElement(string);
                element.addContent((Content)element2);
                element2.addContent((Content)this.objectToElement(object2));
            }
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw new XMLException("Cannot get value of field " + fieldDescr.getName() + " of class " + object.getClass().getName(), exception);
        }
    }

    public boolean isAttributeClass(Class clazz) {
        return clazz.isPrimitive() || SemiPrimitive.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz);
    }

    public Object readObject(URL uRL) throws IOException {
        return this.objectFromDocument(XML.parseXML(uRL));
    }

    public synchronized Object objectFromXML(String string) {
        Document document = XML.parseXML(string);
        return this.objectFromDocument(document);
    }

    public synchronized Object objectFromDocument(Document document) {
        Object object = this.objectFromElement(document.getRootElement());
        this.lastExaminedElement = null;
        return object;
    }

    public boolean looksLikeAnObjectDocument(Document document) {
        Element element = document.getRootElement();
        Namespace namespace = element.getNamespace();
        if (this.requireNamespace && !this.isHomeNamespace(namespace)) {
            return false;
        }
        if (!this.isHomeNamespace(namespace) && namespace != Namespace.NO_NAMESPACE) {
            return false;
        }
        return this.classSyntax.classForExternalName(element.getName()) != null;
    }

    public Element getLastExaminedElement() {
        return this.lastExaminedElement;
    }

    public Object objectFromElement(Element element) {
        this.lastExaminedElement = element;
        String string = element.getName();
        if (string.equals("null")) {
            return null;
        }
        Class clazz = this.classSyntax.classForExternalName(string);
        if (clazz == null) {
            throw new XMLException("Cannot find class " + string);
        }
        return this.objectFromElement(clazz, element);
    }

    protected Object objectFromElement(Class clazz, Element element) {
        Object object;
        this.lastExaminedElement = element;
        if (this.requireNamespace && !this.isHomeNamespace(element.getNamespace())) {
            throw new XMLException("Not an I-X element: " + element);
        }
        ClassDescr classDescr = this.classSyntax.getClassDescr(clazz);
        if (clazz == String.class) {
            object = this.stringFromElement(clazz, element);
        } else if (classDescr.isPrimitive()) {
            object = this.primitiveObjectFromElement(clazz, element);
        } else if (classDescr.isList()) {
            object = this.listFromElement(clazz, element);
        } else if (classDescr.isSet()) {
            object = this.setFromElement(clazz, element);
        } else if (classDescr.isMap()) {
            object = this.mapFromElement(clazz, element);
        } else if (classDescr.isStruct()) {
            object = this.structFromElement(clazz, element);
        } else if (classDescr.isXML()) {
            object = this.embeddedXMLFromElement(clazz, element);
        } else {
            throw new ConsistencyException("Unknown object type " + classDescr);
        }
        if (this.postfilter != null) {
            object = this.postfilter.funcall(object);
        }
        return object;
    }

    protected Object primitiveObjectFromElement(Class clazz, Element element) {
        return this.primitiveObjectFromString(clazz, element.getText());
    }

    protected Object primitiveObjectFromString(Class clazz, String string) {
        Stringer stringer = this.classSyntax.getStringer(clazz);
        if (stringer != null) {
            return stringer.fromString(string);
        }
        try {
            Method method = clazz.getMethod("valueOf", String.class);
            return method.invoke(null, string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Debug.noteException(noSuchMethodException);
            String string2 = this.lastExaminedElement.getName();
            Debug.on();
            Debug.noteln("class name from element:", (Object)string2);
            Debug.noteln("Java name:", (Object)this.classSyntax.getClassFinder().javaName(string2));
            Debug.noteln("class:", (Object)this.classSyntax.classForExternalName(string2));
            Debug.noteln("class syntax:", (Object)this.classSyntax);
            Debug.noteln("class finder:", (Object)this.classSyntax.getClassFinder());
            throw new XMLException("Can't convert to " + clazz, noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Debug.noteException(invocationTargetException);
            throw new XMLException("Can't convert to " + clazz, invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw new XMLException("Can't convert to " + clazz, exception);
        }
    }

    protected String stringFromElement(Class clazz, Element element) {
        return element.getText();
    }

    protected LiteralDocument embeddedXMLFromElement(Class clazz, Element element) {
        LiteralDocument literalDocument = (LiteralDocument)this.makeInstance(clazz);
        this.requireEltSize(1, element);
        Element element2 = (Element)element.getChildren().get(0);
        literalDocument.setRootElement((Element)element2.clone());
        return literalDocument;
    }

    protected List listFromElement(Class clazz, Element element) {
        return (List)this.collectionFromElement(clazz, this.defaultListClass, element);
    }

    protected Set setFromElement(Class clazz, Element element) {
        return (Set)this.collectionFromElement(clazz, this.defaultSetClass, element);
    }

    protected Collection collectionFromElement(Class clazz, Class clazz2, Element element) {
        Class clazz3;
        Class clazz4 = clazz3 = clazz.isInterface() ? this.getImplClass(element, clazz, clazz2) : clazz;
        if (LList.class.isAssignableFrom(clazz3)) {
            return this.makeLListFromElement(element);
        }
        LinkedList linkedList = LinkedList.class.isAssignableFrom(clazz3) ? (LinkedList)this.makeInstance(clazz3) : new LinkedList();
        for (Element element2 : element.getChildren()) {
            Object object = this.objectFromElement(element2);
            linkedList.add(object);
        }
        if (linkedList.getClass() == clazz3) {
            return linkedList;
        }
        try {
            Constructor constructor = clazz3.getConstructor(Collection.class);
            return (Collection)constructor.newInstance(linkedList);
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw new XMLException("Could not create " + clazz3 + " collection", exception);
        }
    }

    protected LList makeLListFromElement(Element element) {
        LListCollector lListCollector = new LListCollector();
        for (Element element2 : element.getChildren()) {
            String string = element2.getName();
            if (string.equals("null")) {
                lListCollector.add((Object)null);
                continue;
            }
            Class clazz = this.classSyntax.classForExternalName(string);
            Object object = clazz == List.class && this.getImplAttributeValue(element2) == null ? this.makeLListFromElement(element2) : this.objectFromElement(element2);
            lListCollector.add(object);
        }
        return lListCollector.contents();
    }

    protected String getImplAttributeValue(Element element) {
        return element.getAttributeValue(this.implAttributeName);
    }

    protected Class getImplClass(Element element, Class clazz, Class clazz2) {
        Debug.expect(clazz.isInterface());
        String string = this.getImplAttributeValue(element);
        Class clazz3 = null;
        if (string != null) {
            clazz3 = this.classSyntax.classForExternalName(string);
            if (clazz3 == null) {
                throw new XMLException("Cannot find implementation class " + string);
            }
            return clazz3;
        }
        if (TypedList.class.isAssignableFrom(clazz)) {
            Class clazz4 = ListOf.findImplementationClass(clazz, LinkedList.class);
            if (clazz4 == null) {
                throw new XMLException("Cannot find a linked implementation for " + clazz);
            }
            return clazz4;
        }
        return clazz2;
    }

    protected Map mapFromElement(Class clazz, Element element) {
        Class clazz2 = clazz.isInterface() ? this.getImplClass(element, clazz, this.defaultMapClass) : clazz;
        Map map = (Map)this.makeInstance(clazz2);
        String string = this.mapEntryName;
        for (Element element2 : element.getChildren()) {
            this.requireEltType(string, element2);
            this.requireEltSize(2, element2);
            List list = element2.getChildren();
            Element element3 = (Element)list.get(0);
            Element element4 = (Element)list.get(1);
            this.requireEltType("key", element3);
            this.requireEltType("value", element4);
            this.requireEltSize(1, element3);
            this.requireEltSize(1, element4);
            Element element5 = (Element)element3.getChildren().get(0);
            Element element6 = (Element)element4.getChildren().get(0);
            Object object = this.objectFromElement(element5);
            Object object2 = this.objectFromElement(element6);
            map.put(object, object2);
        }
        return map;
    }

    protected void requireEltType(String string, Element element) {
        if (!element.getName().equals(string)) {
            throw new XMLException("Expecting " + string + " element but found " + element.getName());
        }
    }

    protected void requireEltSize(int n, Element element) {
        int n2 = element.getChildren().size();
        if (n2 != n) {
            throw new XMLException("Expecting " + n + " children but found " + n2 + " in " + element);
        }
    }

    protected Object structFromElement(Class clazz, Element element) {
        Object object;
        Object object2;
        Class clazz2;
        Object object3;
        Object object4;
        String string;
        Object object5 = this.makeInstance(clazz);
        ClassDescr classDescr = this.classSyntax.getClassDescr(clazz);
        for (Attribute attribute : element.getAttributes()) {
            string = attribute.getName();
            object4 = attribute.getValue();
            object3 = classDescr.fieldForExternalName(string);
            if (object3 == null) {
                throw new XMLException("No field for attribute " + string);
            }
            clazz2 = ((FieldDescr)object3).getType();
            object2 = clazz2.isPrimitive() ? XMLTranslator.wrapperClass(clazz2) : clazz2;
            object = object2 == String.class ? object4 : this.primitiveObjectFromString((Class)object2, (String)object4);
            try {
                ((FieldDescr)object3).setValue(object5, object);
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                throw new XMLException("Cannot set field " + ((FieldDescr)object3).getName(), exception);
            }
        }
        for (Attribute attribute : element.getChildren()) {
            Object object6;
            this.lastExaminedElement = attribute;
            this.requireEltSize(1, (Element)attribute);
            string = attribute.getName();
            object4 = classDescr.fieldForExternalName(string);
            if (object4 == null) {
                this.handleUnknownFieldFromElement(object5, string, (Element)attribute);
                continue;
            }
            object3 = ((FieldDescr)object4).getType();
            clazz2 = (Element)attribute.getChildren().get(0);
            this.lastExaminedElement = clazz2;
            object2 = clazz2.getName();
            if (((String)object2).equals("null")) {
                object6 = null;
            } else {
                object = this.classSyntax.classForExternalName((String)object2);
                if (object == null) {
                    throw new XMLException("Cannot find field value class " + (String)object2);
                }
                object6 = ((Class)object).isInterface() && this.getImplAttributeValue((Element)clazz2) == null && (!((Class)object3).isInterface() || TypedList.class.isAssignableFrom((Class<?>)object3)) && object3 != Object.class ? this.objectFromElement((Class)object3, (Element)clazz2) : this.objectFromElement((Class)object, (Element)clazz2);
            }
            try {
                ((FieldDescr)object4).setValue(object5, object6);
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                throw new XMLException("Cannot set field " + ((FieldDescr)object4).getName(), exception);
            }
        }
        return object5;
    }

    void handleUnknownFieldFromElement(Object object, String string, Element element) {
        Object object2;
        Element element2;
        Class<?> clazz = object.getClass();
        Debug.noteln("Handling unknown field " + Strings.quote(string) + " in class " + this.classSyntax.externalNameForClass(clazz));
        ClassFinder classFinder = this.classSyntax.getClassFinder();
        String string2 = classFinder.javaFieldName(string);
        String string3 = "set" + Strings.capitalize(string2);
        Debug.noteln("Will try method name", (Object)string3);
        this.lastExaminedElement = element2 = (Element)element.getChildren().get(0);
        String string4 = element2.getName();
        Debug.noteln("Value class name", (Object)string4);
        if (string4.equals("null")) {
            throw new XMLException("No field for element " + string);
        }
        Class clazz2 = this.classSyntax.classForExternalName(string4);
        Debug.noteln("Value class", (Object)clazz2);
        Method method = Fn.getMethod(clazz, string3, new Class[]{clazz2});
        if (method == null && clazz2.isInterface() && (object2 = this.getImplClass(element2, clazz2, clazz2)) != clazz2) {
            method = Fn.getMethod(clazz, string3, new Class[]{object2});
        }
        if (method == null) {
            throw new XMLException("No field or set-method for element " + string);
        }
        object2 = this.objectFromElement(clazz2, element2);
        try {
            method.invoke(object, object2);
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw new XMLException("Cannot set field " + string + " by calling " + string3, exception);
        }
    }

    public static final Class wrapperClass(Class clazz) {
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        throw new IllegalArgumentException(clazz + " is not a primitive class");
    }

    protected Object makeInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw new XMLException("Cannot make 0-arg instance of " + clazz, exception);
        }
    }
}

