/*
 * Decompiled with CFR 0.152.
 */
package ixagentwizard;

import ixagentwizard.ErrorMessageBox;
import ixagentwizard.IXAgentWizardFrame;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class IXAgentWizardClass {
    protected IXAgentWizardFrame frame = new IXAgentWizardFrame(this);
    protected JFileChooser dirSelect;
    protected JFileChooser fileSelect;
    protected ErrorMessageBox errorBox;
    protected String ixBaseDir = null;

    public IXAgentWizardClass() {
        this.frame.validate();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.frame.setVisible(true);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.dirSelect = new JFileChooser();
        this.dirSelect.setMultiSelectionEnabled(false);
        this.dirSelect.setFileSelectionMode(1);
        this.fileSelect = new JFileChooser();
        this.fileSelect.setMultiSelectionEnabled(false);
        this.fileSelect.setFileSelectionMode(0);
        this.errorBox = new ErrorMessageBox(this.frame, "Problem", true);
        try {
            File parentDir = new File("..");
            String path = parentDir.getCanonicalPath();
            int lastSepPos = path.lastIndexOf(File.separatorChar);
            String ixDir = path.substring(lastSepPos + 1, path.length()).toLowerCase();
            if (ixDir.startsWith("ix") || ixDir.startsWith("i-x")) {
                this.ixBaseDir = path;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (this.ixBaseDir == null) {
            this.dirSelect.setDialogTitle("Select the I-X base directory");
            if (this.dirSelect.showDialog(this.frame, "Select") == 0) {
                this.ixBaseDir = this.dirSelect.getSelectedFile().getPath();
                continue;
            }
            this.displayErrorMessage("You must specify the I-X base directory!\nThis is the directory in which I-X is installed, e.g. \"ix-4.5\".");
        }
        this.frame.statusBar.setText("I-X base directory: " + this.ixBaseDir);
        String appsDirName = String.valueOf(this.ixBaseDir) + File.separatorChar + "apps";
        File appsDir = new File(appsDirName);
        if (appsDir.isDirectory()) {
            this.frame.agentDirPathTextField.setText(String.valueOf(appsDirName) + File.separatorChar + "newapp");
        } else {
            this.frame.agentDirPathTextField.setText("");
        }
        File currentDir = new File("./logo.gif");
        this.frame.iconPathTextField.setText("");
        try {
            String path = currentDir.getCanonicalPath();
            this.frame.iconPathTextField.setText(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean createAgent(String agentDir, String dName, String sName) {
        try {
            char sep = File.separatorChar;
            agentDir = String.valueOf(agentDir) + sep;
            File newDir = new File(String.valueOf(agentDir) + "config");
            newDir.mkdirs();
            newDir = new File(String.valueOf(agentDir) + "domain-library");
            newDir.mkdirs();
            newDir = new File(String.valueOf(agentDir) + "images");
            newDir.mkdirs();
            newDir = new File(String.valueOf(agentDir) + "java");
            newDir.mkdirs();
            newDir = new File(String.valueOf(agentDir) + "resources");
            newDir.mkdirs();
            newDir = new File(String.valueOf(agentDir) + "scripts" + sep + "unix");
            newDir.mkdirs();
            newDir = new File(String.valueOf(agentDir) + "scripts" + sep + "win");
            newDir.mkdirs();
            FileWriter fw = new FileWriter(String.valueOf(agentDir) + "scripts" + sep + "win" + sep + sName + ".bat");
            fw.write(":: file created by the I-X Agent Wizard\n@echo off\ntitle " + dName + " Command Console\n");
            fw.write(":: cd to the I-X application base\ncd ../..\nset app_base=.\nset app_path=./java\n");
            fw.write("set app_params=-ipc=xml -load config/" + sName + "-panel.props" + " -plan-state-to-save=*");
            fw.write(this.frame.serverCheckBox.isSelected() ? " -run-name-server\n" : "\n");
            fw.write("set ix_base=../..\nset java_params=\nset ipc=xml\n%ix_base%/scripts/win/run-ix-app.bat ix.ip2.Ip2\npause\n");
            fw.close();
            fw = new FileWriter(String.valueOf(agentDir) + "config" + sep + sName + "-panel.props");
            fw.write("# I-X Process Panel Property File\n\n# Panel naming and appearance\nsymbol-name=" + sName + "\n" + "display-name=" + dName + " Panel\n" + "logo-image=images/" + sName + "-logo.gif\n\n");
            fw.write("# Domain model\ndomain=domain-library/" + sName + "-process-model.xml\n\n");
            fw.write("#Test menu\ntest-menu=config/" + sName + "-test-menu.xml\n\n");
            fw.write("# I-Space\n");
            fw.close();
            File imageFile = new File(this.frame.iconPathTextField.getText());
            byte[] imageData = new byte[(int)imageFile.length()];
            FileInputStream fis = new FileInputStream(imageFile);
            if (fis.read(imageData) == -1) {
                throw new AssertionError((Object)"Unexpected end of image icon file!");
            }
            fis.close();
            FileOutputStream fos = new FileOutputStream(String.valueOf(agentDir) + "images" + sep + sName + "-logo.gif");
            fos.write(imageData);
            fos.close();
            fw = new FileWriter(String.valueOf(agentDir) + "domain-library" + sep + sName + "-process-model.xml");
            fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<domain xmlns=\"http://www.aiai.ed.ac.uk/project/ix/\">\n <refinements>\n  <list />\n </refinements>\n</domain>\n");
            fw.close();
            fw = new FileWriter(String.valueOf(agentDir) + "config" + sep + sName + "-test-menu.xml");
            fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<list>\n\n   <test-item\n         menu-text=\"test menu entry text\"\n         to-name=\"me\">\n      <contents>   \n         <activity priority=\"low\" report-back=\"no\">\n            <pattern>\n               <list>\n                  <symbol>activity</symbol>\n                  <symbol>parameter</symbol>\n               </list>\n            </pattern>\n         </activity>\n      </contents>\n   </test-item>\n\n</list>");
            fw.close();
        }
        catch (Exception ioe) {
            this.displayErrorMessage("Unable to create agent:\n" + ioe.getMessage());
            return false;
        }
        return true;
    }

    protected void displayErrorMessage(String msg) {
        this.errorBox.setMessageText(msg);
        Dimension dlgSize = this.errorBox.getPreferredSize();
        Dimension frmSize = this.frame.getSize();
        Point loc = this.frame.getLocation();
        this.errorBox.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        this.errorBox.pack();
        this.errorBox.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                new IXAgentWizardClass();
            }
        });
    }
}

