/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans.Extension;

import org.jabber.jabberbeans.Extension.AgentBuilder;
import org.jabber.jabberbeans.Extension.QueryExtension;
import org.jabber.jabberbeans.XMLData;
import org.jabber.jabberbeans.util.JID;

public class Agent
extends XMLData
implements QueryExtension {
    private JID jid;
    private String name;
    private String description;
    private String service;
    private String transport;
    private boolean register;
    private boolean search;
    private boolean IQAgent;

    public Agent(AgentBuilder agentBuilder) throws InstantiationException {
        this.IQAgent = agentBuilder.isIQAgent();
        this.jid = agentBuilder.getJID();
        if (this.IQAgent) {
            if (this.jid != null) {
                throw new InstantiationException("JID not allowed for iq:agent");
            }
            this.setXMLNS("jabber:iq:agent");
        } else if (this.jid == null) {
            throw new InstantiationException("JID required for agent");
        }
        this.name = agentBuilder.getName();
        this.description = agentBuilder.getDescription();
        this.service = agentBuilder.getService();
        this.register = agentBuilder.isRegister();
        this.search = agentBuilder.isSearchable();
        this.transport = agentBuilder.getTransport();
    }

    public String getName() {
        return this.name;
    }

    public JID getJID() {
        return this.jid;
    }

    public String getDescription() {
        return this.description;
    }

    public String getService() {
        return this.service;
    }

    public String getTransport() {
        return this.transport;
    }

    public boolean isRegister() {
        return this.register;
    }

    public boolean isSearchable() {
        return this.search;
    }

    public boolean isIQAgent() {
        return this.IQAgent;
    }

    public void appendItem(StringBuffer stringBuffer) {
        stringBuffer.append('<');
        if (this.isIQAgent()) {
            stringBuffer.append("query xmlns=\"jabber:iq:agent\"");
        } else {
            stringBuffer.append("agent");
        }
        XMLData.appendAttrib(stringBuffer, "jid", this.jid);
        stringBuffer.append('>');
        XMLData.appendChild(stringBuffer, "name", this.name);
        XMLData.appendChild(stringBuffer, "description", this.description);
        XMLData.appendChild(stringBuffer, "service", this.service);
        XMLData.appendChild(stringBuffer, "register", this.register);
        XMLData.appendChild(stringBuffer, "search", this.search);
        XMLData.appendChild(stringBuffer, "transport", this.transport);
        if (this.isIQAgent()) {
            stringBuffer.append("</query>");
        } else {
            stringBuffer.append("</agent>");
        }
    }
}

