/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans.Extension;

import java.util.Enumeration;
import java.util.Vector;
import org.jabber.jabberbeans.Extension.BrowseItemBuilder;
import org.jabber.jabberbeans.Extension.QueryExtension;
import org.jabber.jabberbeans.XMLData;
import org.jabber.jabberbeans.util.JID;

public class BrowseItem
extends XMLData
implements QueryExtension {
    private boolean iq;
    private String category;
    private String type;
    private String name;
    private JID jid;
    private Vector namespaces;
    private Vector childItems;

    public BrowseItem(BrowseItemBuilder browseItemBuilder) {
        this.iq = browseItemBuilder.isIQ();
        this.category = browseItemBuilder.getCategory();
        this.type = browseItemBuilder.getType();
        this.name = browseItemBuilder.getName();
        this.jid = browseItemBuilder.getJID();
        this.namespaces = browseItemBuilder.getNameSpaces();
        this.childItems = browseItemBuilder.getChildren();
    }

    public final boolean isIQ() {
        return this.iq;
    }

    public final String getCategory() {
        return this.category;
    }

    public final String getType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public final JID getJID() {
        return this.jid;
    }

    public Vector getNamespaces() {
        return this.namespaces;
    }

    public Vector getChildren() {
        return this.childItems;
    }

    public final Enumeration namespaces() {
        if (this.namespaces == null) {
            return null;
        }
        return this.namespaces.elements();
    }

    public final Enumeration children() {
        if (this.childItems == null) {
            return null;
        }
        return this.childItems.elements();
    }

    public String getXMLNS() {
        return null;
    }

    public void appendItem(StringBuffer stringBuffer) {
        stringBuffer.append('<');
        if (this.category == null) {
            stringBuffer.append("query");
        } else {
            stringBuffer.append(this.category);
        }
        if (this.isIQ()) {
            XMLData.appendAttrib(stringBuffer, "xmlns", this.getXMLNS());
        }
        XMLData.appendAttrib(stringBuffer, "type", this.getType());
        XMLData.appendAttrib(stringBuffer, "name", this.getName());
        XMLData.appendAttrib(stringBuffer, "jid", this.getJID());
        stringBuffer.append('>');
        Enumeration enumeration = this.namespaces.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("<ns>");
            stringBuffer.append(enumeration.nextElement().toString());
            stringBuffer.append("</ns>");
        }
        enumeration = this.childItems.elements();
        while (enumeration.hasMoreElements()) {
            BrowseItem browseItem = (BrowseItem)enumeration.nextElement();
            browseItem.appendItem(stringBuffer);
        }
        stringBuffer.append("</");
        if (this.category == null) {
            stringBuffer.append("query");
        } else {
            stringBuffer.append(this.category);
        }
        stringBuffer.append('>');
    }
}

