/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans.Extension;

import org.jabber.jabberbeans.Extension.IQAuthBuilder;
import org.jabber.jabberbeans.Extension.QueryExtension;
import org.jabber.jabberbeans.XMLData;

public class IQAuth
extends XMLData
implements QueryExtension {
    private String username;
    private String resource;
    private String password;
    private String SHA1Digest;
    private String ZeroKHash;
    private String ZeroKToken;
    private int sequence;
    private String sessionid;
    private String msisdn;

    public IQAuth(IQAuthBuilder iQAuthBuilder) throws InstantiationException {
        this.username = iQAuthBuilder.getUsername();
        this.resource = iQAuthBuilder.getResource();
        this.password = iQAuthBuilder.getPassword();
        this.SHA1Digest = iQAuthBuilder.getSHA1Digest();
        this.ZeroKHash = iQAuthBuilder.getZeroKHash();
        this.ZeroKToken = iQAuthBuilder.getZeroKToken();
        this.sequence = iQAuthBuilder.getZeroKSequence();
        this.sessionid = iQAuthBuilder.getSessionId();
        this.msisdn = iQAuthBuilder.getMsisdn();
        this.setXMLNS("jabber:iq:auth");
    }

    public String getUsername() {
        return this.username;
    }

    public String getResource() {
        return this.resource;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSHA1Digest() {
        return this.SHA1Digest;
    }

    public String getZeroKHash() {
        return this.ZeroKHash;
    }

    public String getZeroKToken() {
        return this.ZeroKToken;
    }

    public int getZeroKSequence() {
        return this.sequence;
    }

    public String getSessionId() {
        return this.sessionid;
    }

    public String getMsisdn() {
        return this.msisdn;
    }

    public void appendItem(StringBuffer stringBuffer) {
        stringBuffer.append("<query xmlns=\"");
        stringBuffer.append(this.getXMLNS());
        stringBuffer.append("\">");
        XMLData.appendChild(stringBuffer, "username", this.username);
        XMLData.appendChild(stringBuffer, "password", this.password);
        if (null != this.SHA1Digest) {
            stringBuffer.append("<digest");
            if (null != this.sessionid) {
                XMLData.appendAttrib(stringBuffer, "sid", this.sessionid);
            }
            stringBuffer.append(">").append(this.SHA1Digest).append("</digest>");
        }
        XMLData.appendChild(stringBuffer, "resource", this.resource);
        XMLData.appendChild(stringBuffer, "hash", this.ZeroKHash);
        XMLData.appendChild(stringBuffer, "token", this.ZeroKToken);
        XMLData.appendChild(stringBuffer, "sequence", this.sequence == -1 ? null : new Integer(this.sequence).toString());
        XMLData.appendChild(stringBuffer, "msisdn", this.msisdn);
        stringBuffer.append("</query>");
    }
}

