/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans.Extension;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jabber.jabberbeans.Extension.IQRPCResponseBuilder;
import org.jabber.jabberbeans.Extension.QueryExtension;
import org.jabber.jabberbeans.XMLData;

public class IQRPCResponse
extends XMLData
implements QueryExtension {
    private Vector parameters;
    private Hashtable faultHash = new Hashtable();

    public IQRPCResponse(IQRPCResponseBuilder iQRPCResponseBuilder) {
        this.parameters = iQRPCResponseBuilder.getParameters();
        this.faultHash = iQRPCResponseBuilder.getFaultHash();
    }

    public Vector getParameters() {
        return this.parameters;
    }

    public Hashtable getFaultHash() {
        return this.faultHash;
    }

    public boolean isFaultResponse() {
        Integer n = (Integer)this.faultHash.get("faultCode");
        return n != null && n > 0;
    }

    public int getFaultCode() {
        Integer n = (Integer)this.faultHash.get("faultCode");
        return n;
    }

    public String getFaultCodeString() {
        Integer n = (Integer)this.faultHash.get("faultCode");
        return n.toString();
    }

    public String getFaultString() {
        return (String)this.faultHash.get("faultString");
    }

    public void appendItem(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append("<query xmlns=\"jabber:iq:rpc\">");
        XMLData.appendChild(stringBuffer2, "methodResponse", false);
        Integer n = (Integer)this.faultHash.get("faultCode");
        if (n != null && n > 0) {
            StringBuffer stringBuffer3 = new StringBuffer();
            this.appendFault(stringBuffer3, this.faultHash);
            XMLData.appendChild(stringBuffer2, "fault", stringBuffer3.toString(), false);
        } else if (this.parameters.size() > 0) {
            StringBuffer stringBuffer4 = new StringBuffer();
            this.appendParameters(stringBuffer4);
            XMLData.appendChild(stringBuffer2, "params", stringBuffer4.toString(), false);
        }
        XMLData.appendChild(stringBuffer, "methodResponse", stringBuffer2.toString(), false);
        stringBuffer.append("</query>");
    }

    protected void appendFault(StringBuffer stringBuffer, Hashtable hashtable) {
        this.appendParameter(stringBuffer, hashtable);
    }

    protected void appendParameters(StringBuffer stringBuffer) {
        Enumeration enumeration = this.parameters.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("<param>");
            this.appendParameter(stringBuffer, enumeration.nextElement());
            stringBuffer.append("</param>");
        }
    }

    protected void appendParameter(StringBuffer stringBuffer, Integer n) {
        StringBuffer stringBuffer2 = new StringBuffer();
        XMLData.appendChild(stringBuffer2, "i4", n.toString());
        XMLData.appendChild(stringBuffer, "value", stringBuffer2.toString(), false);
    }

    protected void appendParameter(StringBuffer stringBuffer, Boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        XMLData.appendChild(stringBuffer2, "boolean", bl != false ? "1" : "0");
        XMLData.appendChild(stringBuffer, "value", stringBuffer2.toString(), false);
    }

    protected void appendParameter(StringBuffer stringBuffer, Object object) {
        if (object instanceof Integer) {
            this.appendParameter(stringBuffer, (Integer)object);
        } else if (object instanceof Boolean) {
            this.appendParameter(stringBuffer, (Boolean)object);
        } else if (object instanceof Double) {
            this.appendParameter(stringBuffer, (Double)object);
        } else if (object instanceof Date) {
            this.appendParameter(stringBuffer, (Date)object);
        } else if (object instanceof Vector) {
            this.appendParameter(stringBuffer, (Vector)object);
        } else if (object instanceof Hashtable) {
            this.appendParameter(stringBuffer, (Hashtable)object);
        } else {
            StringBuffer stringBuffer2 = new StringBuffer();
            XMLData.appendChild(stringBuffer2, "string", object.toString());
            XMLData.appendChild(stringBuffer, "value", stringBuffer2.toString(), false);
        }
    }

    protected void appendParameter(StringBuffer stringBuffer, Double d) {
        StringBuffer stringBuffer2 = new StringBuffer();
        XMLData.appendChild(stringBuffer2, "double", d.toString());
        XMLData.appendChild(stringBuffer, "value", stringBuffer2.toString(), false);
    }

    protected void appendParameter(StringBuffer stringBuffer, Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd'T'hh:mm:ss");
        StringBuffer stringBuffer2 = new StringBuffer();
        XMLData.appendChild(stringBuffer2, "dateTime.iso8601", simpleDateFormat.format(date));
        XMLData.appendChild(stringBuffer, "value", stringBuffer2.toString(), false);
    }

    protected void appendParameter(StringBuffer stringBuffer, Vector vector) {
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.appendParameter(stringBuffer3, enumeration.nextElement());
        }
        XMLData.appendChild(stringBuffer4, "data", stringBuffer3.toString(), false);
        XMLData.appendChild(stringBuffer2, "array", stringBuffer4.toString(), false);
        XMLData.appendChild(stringBuffer, "value", stringBuffer2.toString(), false);
    }

    protected void appendParameter(StringBuffer stringBuffer, Hashtable hashtable) {
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            StringBuffer stringBuffer4 = new StringBuffer();
            String string = (String)enumeration.nextElement();
            XMLData.appendChild(stringBuffer4, "name", string);
            this.appendParameter(stringBuffer4, hashtable.get(string));
            XMLData.appendChild(stringBuffer3, "member", stringBuffer4.toString(), false);
        }
        XMLData.appendChild(stringBuffer2, "struct", stringBuffer3.toString(), false);
        XMLData.appendChild(stringBuffer, "value", stringBuffer2.toString(), false);
    }
}

