/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans.Extension;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.jabber.jabberbeans.Extension.QueryExtension;
import org.jabber.jabberbeans.Extension.XDataFieldBuilder;
import org.jabber.jabberbeans.XMLData;
import org.jabber.jabberbeans.core.Attribute;

public class XDataField
extends XMLData
implements Serializable,
QueryExtension {
    private String m_label = null;
    private String m_variable = null;
    private String m_type = null;
    private Vector m_options = null;
    private String m_desc = null;
    private Boolean m_required = null;
    private String m_value = null;

    public XDataField(XDataFieldBuilder xDataFieldBuilder) throws InstantiationException {
        this.m_label = this.checkString(xDataFieldBuilder.getLabel());
        this.m_variable = this.checkString(xDataFieldBuilder.getVariable());
        if (null == this.m_variable) {
            throw new InstantiationException("Invalid var value");
        }
        this.m_type = this.checkString(xDataFieldBuilder.getType());
        if ("none".equals(this.m_type)) {
            this.m_type = null;
        } else if (!(null == this.m_type || this.m_type.equals("text-single") || this.m_type.equals("text-private") || this.m_type.equals("text-multi") || this.m_type.equals("list-multi") || this.m_type.equals("list-single") || this.m_type.equals("boolean") || this.m_type.equals("fixed") || this.m_type.equals("hidden"))) {
            throw new InstantiationException("Invalid type value");
        }
        if (null != xDataFieldBuilder.getRequired()) {
            this.m_required = new Boolean(xDataFieldBuilder.getRequired());
        }
        this.m_desc = this.checkString(xDataFieldBuilder.getDescription());
        this.m_value = this.checkString(xDataFieldBuilder.getValue());
        if (null != xDataFieldBuilder.getOptions()) {
            this.m_options = new Vector(xDataFieldBuilder.getOptions());
        }
    }

    public void appendItem(StringBuffer stringBuffer) {
        stringBuffer.append("<field");
        XMLData.appendAttrib(stringBuffer, "var", this.getVariable());
        XMLData.appendAttrib(stringBuffer, "label", this.getLabel());
        XMLData.appendAttrib(stringBuffer, "type", this.getType());
        stringBuffer.append(">");
        XMLData.appendChild(stringBuffer, "required", this.getRequired());
        XMLData.appendChild(stringBuffer, "desc", this.getDescription());
        XMLData.appendChild(stringBuffer, "value", this.getValue());
        if (null != this.m_options && this.m_options.size() > 0) {
            Enumeration enumeration = this.m_options.elements();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                stringBuffer.append("<option");
                XMLData.appendAttrib(stringBuffer, "label", attribute.getName());
                stringBuffer.append(">");
                XMLData.appendChild(stringBuffer, "value", attribute.getValue());
                stringBuffer.append("</option>");
            }
        }
        stringBuffer.append("</field>");
    }

    private String checkString(String string) {
        if (null == string || string.length() == 0) {
            return null;
        }
        return new String(string).intern();
    }

    public Enumeration getOptions() {
        if (null == this.m_options) {
            return new Vector(0).elements();
        }
        Vector<String> vector = new Vector<String>(this.m_options.size());
        Enumeration enumeration = this.m_options.elements();
        while (enumeration.hasMoreElements()) {
            vector.add(((Attribute)enumeration.nextElement()).getName());
        }
        return vector.elements();
    }

    public String getOptionValue(String string) {
        if (null == string || null == this.m_options) {
            Enumeration enumeration = this.m_options.elements();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                if (!string.equals(attribute.getName())) continue;
                return attribute.getValue();
            }
        }
        return null;
    }

    public String getLabel() {
        return this.m_label;
    }

    public String getVariable() {
        return this.m_variable;
    }

    public String getType() {
        return this.m_type;
    }

    public String getDescription() {
        return this.m_desc;
    }

    public boolean getRequired() {
        return null == this.m_required ? false : this.m_required;
    }

    public String getValue() {
        return this.m_value;
    }
}

