/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans;

import java.io.Serializable;
import java.util.Enumeration;
import org.jabber.jabberbeans.ContentPacket;
import org.jabber.jabberbeans.Extension.Extension;
import org.jabber.jabberbeans.PresenceBuilder;
import org.jabber.jabberbeans.XMLData;

public final class Presence
extends ContentPacket
implements Serializable {
    private String status;
    private int priority;
    private String stateShow;

    public Presence(PresenceBuilder presenceBuilder) throws InstantiationException {
        super(presenceBuilder);
        if (this.type == null || this.type.equals("available")) {
            this.type = null;
        }
        this.status = presenceBuilder.getStatus();
        this.priority = presenceBuilder.getPriority();
        if (this.priority < -1) {
            throw new InstantiationException("Invalid (negative) priority on presence information");
        }
        this.stateShow = presenceBuilder.getStateShow();
        if (this.status != null) {
            this.status.intern();
        }
        if (this.stateShow != null) {
            this.stateShow.intern();
        }
    }

    public final String getStatus() {
        return this.status;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final String getStateShow() {
        return this.stateShow;
    }

    public final void appendItem(StringBuffer stringBuffer) {
        stringBuffer.append("<presence");
        this.appendBaseAttribs(stringBuffer);
        stringBuffer.append(">");
        this.appendAnyError(stringBuffer);
        XMLData.appendChild(stringBuffer, "status", this.status);
        XMLData.appendChild(stringBuffer, "show", this.stateShow);
        if (this.getPriority() != -1) {
            stringBuffer.append("<priority>" + new Integer(this.getPriority()).toString() + "</priority>");
        }
        Enumeration enumeration = this.Extensions();
        while (enumeration.hasMoreElements()) {
            ((Extension)enumeration.nextElement()).appendItem(stringBuffer);
        }
        stringBuffer.append("</presence>");
    }
}

