/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans;

import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.jabber.jabberbeans.ConnectionBean;
import org.jabber.jabberbeans.PacketEvent;
import org.jabber.jabberbeans.PacketListener;
import org.jabber.jabberbeans.Presence;
import org.jabber.jabberbeans.PresenceListener;
import org.jabber.jabberbeans.PresenceUserNode;
import org.jabber.jabberbeans.util.JID;

public class PresenceBean
implements Serializable {
    private boolean debug = false;
    private ConnectionBean cb = null;
    private Vector presenceListeners = new Vector();
    private Hashtable jidTree = new Hashtable();
    private Vector blackList = new Vector();
    private boolean blackListEnable = false;
    private int blackListCounter = 0;
    private PresencePacketListener listener = null;

    public void setConnBean(ConnectionBean connectionBean) {
        this.cb = connectionBean;
        this.listener = new PresencePacketListener();
        this.cb.addPacketListener(this.listener);
    }

    public ConnectionBean getConnBean() {
        return this.cb;
    }

    public Hashtable getJIDTree() {
        return this.jidTree;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void toPrintString() {
        Collection collection = this.jidTree.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PresenceUserNode presenceUserNode = (PresenceUserNode)iterator.next();
            if (!this.debug) continue;
            System.err.println(presenceUserNode.toString());
        }
    }

    public void fireChangedPresence(Hashtable hashtable, Presence presence, PresenceUserNode presenceUserNode, String string) {
        try {
            Vector vector = (Vector)this.presenceListeners.clone();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ((PresenceListener)enumeration.nextElement()).changedPresence(hashtable, presence, presenceUserNode, string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void fireSubscribe(Presence presence) {
        try {
            Vector vector = (Vector)this.presenceListeners.clone();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ((PresenceListener)enumeration.nextElement()).subscribe(presence);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void fireSubscribed(Presence presence) {
        try {
            Vector vector = (Vector)this.presenceListeners.clone();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ((PresenceListener)enumeration.nextElement()).subscribed(presence);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void fireUnsubscribe(Presence presence) {
        try {
            Vector vector = (Vector)this.presenceListeners.clone();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ((PresenceListener)enumeration.nextElement()).unsubscribe(presence);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void fireUnsubscribed(Presence presence) {
        try {
            Vector vector = (Vector)this.presenceListeners.clone();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ((PresenceListener)enumeration.nextElement()).unsubscribed(presence);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void fireError(Presence presence) {
        try {
            Vector vector = (Vector)this.presenceListeners.clone();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ((PresenceListener)enumeration.nextElement()).error(presence);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void addPresenceListener(PresenceListener presenceListener) {
        if (!this.presenceListeners.contains(presenceListener)) {
            this.presenceListeners.addElement(presenceListener);
        }
    }

    public synchronized void delPresenceListener(PresenceListener presenceListener) {
        if (this.presenceListeners.contains(presenceListener)) {
            this.presenceListeners.removeElement(presenceListener);
        }
    }

    public void addToBlacklist(JID jID) {
        if (!this.blackList.contains(jID.toSimpleString())) {
            this.blackList.addElement(jID.toSimpleString());
        }
    }

    public void removeFromBlacklist(JID jID) {
        if (this.blackList.contains(jID.toSimpleString())) {
            this.blackList.removeElement(jID.toSimpleString());
        }
    }

    public void setBlacklistEnable(boolean bl) {
        if (bl) {
            ++this.blackListCounter;
        } else if (this.blackListCounter >= 1) {
            --this.blackListCounter;
        }
        this.blackListEnable = this.blackListCounter >= 1;
    }

    public boolean getBlacklistEnable() {
        return this.blackListEnable;
    }

    class PresencePacketListener
    implements PacketListener {
        PresencePacketListener() {
        }

        public void receivedPacket(PacketEvent packetEvent) {
            try {
                Presence presence;
                if (!(packetEvent.getPacket() instanceof Presence)) {
                    return;
                }
                try {
                    presence = (Presence)packetEvent.getPacket();
                    if (PresenceBean.this.blackListEnable && PresenceBean.this.blackList.contains(presence.getFromAddress().toSimpleString())) {
                        return;
                    }
                    if (PresenceBean.this.debug) {
                        System.err.println("Packet to String: " + presence.toString());
                    }
                }
                catch (ClassCastException classCastException) {
                    System.err.println("Error in Presence Bean.  Could not cast Presence Packet");
                    return;
                }
                String string = presence.getType();
                JID jID = presence.getFromAddress();
                String string2 = presence.getStateShow();
                String string3 = presence.getStatus();
                JID jID2 = JID.fromString(jID.toSimpleString());
                JID jID3 = jID;
                boolean bl = PresenceBean.this.jidTree.containsKey(jID2);
                if (PresenceBean.this.debug) {
                    System.err.println("Short: " + jID2);
                    System.err.println("Full: " + jID3);
                    System.err.println("Type:  " + string + "  Addy:  " + jID.toPrettyString() + "  State:  " + string2 + "  Status:  " + string3);
                }
                if (string == null || "available".equals(string)) {
                    if (!bl) {
                        if (PresenceBean.this.debug) {
                            System.err.println("Adding user the first time.");
                        }
                        PresenceUserNode presenceUserNode = new PresenceUserNode(jID, string2, string3);
                        if (PresenceBean.this.debug) {
                            System.err.println("Node: " + presenceUserNode);
                        }
                        PresenceBean.this.jidTree.put(jID2, presenceUserNode);
                        PresenceBean.this.fireChangedPresence(PresenceBean.this.jidTree, presence, presenceUserNode, "online");
                        if (PresenceBean.this.debug) {
                            System.err.println("Fired changed presence event.");
                        }
                    } else {
                        PresenceUserNode presenceUserNode = (PresenceUserNode)PresenceBean.this.jidTree.get(jID2);
                        if (presenceUserNode.containsResource(jID3)) {
                            if (PresenceBean.this.debug) {
                                System.err.println(jID3 + " adjusted for state info.");
                            }
                            presenceUserNode.setState(jID, string2);
                            presenceUserNode.setStatus(jID, string3);
                            PresenceBean.this.fireChangedPresence(PresenceBean.this.jidTree, presence, presenceUserNode, "status");
                        } else {
                            if (PresenceBean.this.debug) {
                                System.err.println(jID + " added as a resource to the user node.");
                            }
                            presenceUserNode.addResource(jID, string2, string3);
                            if (PresenceBean.this.debug) {
                                System.err.println("Adding resource " + jID2 + ".\nResources: " + presenceUserNode.getNumResources());
                            }
                            PresenceBean.this.fireChangedPresence(PresenceBean.this.jidTree, presence, presenceUserNode, "online");
                        }
                        if (PresenceBean.this.debug) {
                            System.err.println("Fired changed presence event.");
                        }
                    }
                } else if ("unavailable".equals(string)) {
                    PresenceUserNode presenceUserNode = null;
                    if (bl) {
                        presenceUserNode = (PresenceUserNode)PresenceBean.this.jidTree.get(jID2);
                        if (presenceUserNode.getNumResources() <= 1) {
                            PresenceBean.this.jidTree.remove(jID2);
                            if (PresenceBean.this.debug) {
                                System.err.println("Removing resource " + jID2);
                            }
                        } else {
                            if (PresenceBean.this.debug) {
                                System.err.println("Removing resource " + jID3 + ".\nResources: " + presenceUserNode.getNumResources());
                            }
                            presenceUserNode.removeResource(jID3);
                            if (PresenceBean.this.debug) {
                                System.err.println("Removing resource " + jID3 + ".\nResources: " + presenceUserNode.getNumResources());
                            }
                        }
                        PresenceBean.this.fireChangedPresence(PresenceBean.this.jidTree, presence, presenceUserNode, "unavailable");
                    }
                } else if ("subscribe".equals(string)) {
                    if (PresenceBean.this.debug) {
                        System.err.println("Subscription request from " + jID.toPrettyString());
                    }
                    PresenceBean.this.fireSubscribe(presence);
                } else if ("subscribed".equals(string)) {
                    if (PresenceBean.this.debug) {
                        System.err.println("Subcription request succeeded from " + jID.toPrettyString());
                    }
                    PresenceBean.this.fireSubscribed(presence);
                } else if ("unsubscribe".equals(string)) {
                    if (PresenceBean.this.debug) {
                        System.err.println(jID.toPrettyString() + " is unsubscribing from our presence.");
                    }
                    PresenceBean.this.fireUnsubscribe(presence);
                } else if ("unsubscribed".equals(string)) {
                    if (PresenceBean.this.debug) {
                        System.err.println(jID.toPrettyString() + " has unsubscribed us from their presence.");
                    }
                    PresenceBean.this.jidTree.remove(jID2);
                    PresenceBean.this.fireUnsubscribed(presence);
                } else {
                    if (PresenceBean.this.debug) {
                        System.err.println("Error presence packet recieved");
                    }
                    PresenceBean.this.fireError(presence);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void sentPacket(PacketEvent packetEvent) {
        }

        public void sendFailed(PacketEvent packetEvent) {
        }
    }
}

