/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans;

import java.util.Enumeration;
import java.util.Vector;
import org.jabber.jabberbeans.RosterItemBuilder;
import org.jabber.jabberbeans.XMLData;
import org.jabber.jabberbeans.util.JID;

public class RosterItem
extends XMLData {
    private JID jid;
    private String subscriptionType;
    private String askStateType;
    private String friendlyName;
    private String subscribeAttr;
    private String hiddenAttr;
    private Vector groups = null;

    public RosterItem(RosterItemBuilder rosterItemBuilder) throws InstantiationException {
        this.jid = rosterItemBuilder.getJID();
        if (this.jid == null) {
            throw new InstantiationException("No JID specified");
        }
        this.subscriptionType = rosterItemBuilder.getSubscriptionType();
        if (this.subscriptionType == null || this.subscriptionType.equals("")) {
            this.subscriptionType = null;
        } else {
            if (!(this.subscriptionType.equals("to") || this.subscriptionType.equals("from") || this.subscriptionType.equals("both") || this.subscriptionType.equals("none") || this.subscriptionType.equals("remove"))) {
                throw new InstantiationException("Invalid subscription type");
            }
            this.subscriptionType.intern();
        }
        this.askStateType = rosterItemBuilder.getWaitingStateType();
        if (this.askStateType == null || this.askStateType.equals("") || this.askStateType.equals("none")) {
            this.askStateType = null;
        } else {
            if (!this.askStateType.equals("subscribe") && !this.askStateType.equals("unsubscribe")) {
                throw new InstantiationException("Invalid in-process request");
            }
            this.askStateType.intern();
        }
        this.friendlyName = rosterItemBuilder.getFriendlyName();
        if (this.friendlyName == null || this.friendlyName.equals("")) {
            this.friendlyName = null;
        }
        if (this.friendlyName != null) {
            this.friendlyName.intern();
        }
        this.subscribeAttr = rosterItemBuilder.getSubscribe();
        this.hiddenAttr = rosterItemBuilder.getHidden();
        this.groups = (Vector)rosterItemBuilder.getGroups().clone();
    }

    public JID getJID() {
        return this.jid;
    }

    public String getSubscriptionType() {
        return this.subscriptionType;
    }

    public String getWaitingStateType() {
        return this.askStateType;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getSubscribe() {
        return this.subscribeAttr;
    }

    public String getHidden() {
        return this.hiddenAttr;
    }

    public Enumeration enumerateGroups() {
        if (this.groups == null) {
            return null;
        }
        return this.groups.elements();
    }

    public void appendItem(StringBuffer stringBuffer) {
        stringBuffer.append("<item");
        XMLData.appendAttrib(stringBuffer, "jid", this.getJID());
        XMLData.appendAttrib(stringBuffer, "subscription", this.getSubscriptionType());
        XMLData.appendAttrib(stringBuffer, "ask", this.getWaitingStateType());
        XMLData.appendAttrib(stringBuffer, "name", this.getFriendlyName());
        XMLData.appendAttrib(stringBuffer, "subscribe", this.getSubscribe());
        XMLData.appendAttrib(stringBuffer, "hidden", this.getHidden());
        Enumeration enumeration = this.enumerateGroups();
        if (enumeration == null) {
            stringBuffer.append("/>");
            return;
        }
        stringBuffer.append(">");
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e == null) {
                stringBuffer.append("<group/>");
                continue;
            }
            XMLData.appendChild(stringBuffer, "group", e.toString());
        }
        stringBuffer.append("</item>");
    }
}

