/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans.sax.Extension;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.jabber.jabberbeans.sax.Extension.RPCArrayHandler;
import org.jabber.jabberbeans.sax.Extension.RPCStructHandler;
import org.jabber.jabberbeans.sax.SubHandler;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class RPCValueHandler
extends SubHandler {
    StringBuffer elementChars;
    Object obj = null;
    SubHandler subHandler = null;
    protected static final String I4Tag = "i4";
    protected static final String IntTag = "int";
    protected static final String BooleanTag = "boolean";
    protected static final String StringTag = "string";
    protected static final String DoubleTag = "double";
    protected static final String DateTimeTag = "dateTime.iso8601";
    protected static final String StructTag = "struct";
    protected static final String ArrayTag = "array";
    protected static final String ValueTag = "value";

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.elementChars.append(cArray, n, n2);
    }

    protected void startHandler(String string, AttributeList attributeList) throws SAXException {
        this.elementChars = new StringBuffer();
        this.obj = null;
        this.subHandler = null;
    }

    protected void handleStartElement(String string, AttributeList attributeList) throws SAXException {
        if (string.equalsIgnoreCase(ArrayTag)) {
            this.subHandler = new RPCArrayHandler();
            this.setChildSubHandler(this.subHandler, string, attributeList);
        } else if (string.equalsIgnoreCase(StructTag)) {
            this.subHandler = new RPCStructHandler();
            this.setChildSubHandler(this.subHandler, string, attributeList);
        }
    }

    protected void handleEndElement(String string) throws SAXException {
        if (string.equalsIgnoreCase(I4Tag) || string.equalsIgnoreCase(IntTag)) {
            this.obj = new Integer(this.elementChars.toString());
        } else if (string.equalsIgnoreCase(BooleanTag)) {
            String string2 = this.elementChars.toString();
            this.obj = new Boolean(string2.equals("1") || Boolean.getBoolean(string2));
        } else if (string.equalsIgnoreCase(StringTag)) {
            this.obj = this.elementChars.toString();
        } else if (string.equalsIgnoreCase(DoubleTag)) {
            this.obj = new Double(this.elementChars.toString());
        } else if (string.equalsIgnoreCase(DateTimeTag)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd'T'hh:mm:ss");
            try {
                this.obj = simpleDateFormat.parse(this.elementChars.toString());
            }
            catch (ParseException parseException) {
                this.obj = this.elementChars.toString();
            }
        } else if (string.equalsIgnoreCase(ValueTag) && this.obj == null) {
            this.obj = this.elementChars.toString();
        }
    }

    protected Object stopHandler(String string) {
        return this.obj;
    }

    protected void receiveChildData(SubHandler subHandler, Object object) {
        this.obj = object;
        this.subHandler = null;
    }
}

