/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans.sax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.jabber.jabberbeans.ConnectionBean;
import org.jabber.jabberbeans.Packet;

public final class OutputStreamHandler
extends Thread {
    private OutputStream out;
    private ConnectionBean.OutputStreamInterface osi;
    private final LockingQueue output = new LockingQueue();
    private boolean keepRunning = true;

    public OutputStreamHandler(ConnectionBean.OutputStreamInterface outputStreamInterface) {
        this.osi = outputStreamInterface;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public final void send(Packet packet) {
        if (this.keepRunning) {
            this.output.put(packet);
        } else {
            this.osi.sendFailed(packet);
        }
    }

    public void shutdown() {
        System.err.println("OutputStream: shutdown");
        this.keepRunning = false;
        this.output.putLast(null);
        System.err.println("OutputStream: closing queue");
    }

    public void handleThreadDeath(Exception exception, Packet packet) {
        System.err.println("OutputStream: thread death");
        if (packet != null) {
            this.osi.sendFailed(packet);
        }
        Object object = this.output.getLast();
        while (object != null) {
            this.osi.sendFailed((Packet)object);
            object = this.output.getLast();
        }
        this.osi.unexpectedThreadDeath(exception);
    }

    public void handleThreadDeath(Exception exception) {
        this.handleThreadDeath(exception, null);
    }

    public final void run() {
        if (this.out == null) {
            throw new RuntimeException("starting output thread without any IO set up to use");
        }
        Packet packet = null;
        while (this.keepRunning) {
            try {
                packet = (Packet)this.output.get();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("OutputStream: interrupted");
            }
            if (packet == null) continue;
            try {
                this.out.write(packet.toString().getBytes("UTF8"));
                this.out.flush();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new Error("No UTF-8 character set support");
            }
            catch (IOException iOException) {
                this.handleThreadDeath(iOException, packet);
                return;
            }
            this.osi.sent(packet);
        }
        try {
            this.out.write("</stream:stream>".getBytes("UTF8"));
            this.out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.err.println("OutputStream: stopped");
    }

    private final class LockingQueue {
        private LinkedList m_queue = new LinkedList();
        private boolean m_closed = false;
        private boolean m_reject = false;
        private int m_waiting = 0;

        public final synchronized void put(Object object) {
            if (this.m_closed || this.m_reject) {
                return;
            }
            this.m_queue.addLast(object);
            this.notify();
        }

        public final synchronized void putLast(Object object) {
            this.put(object);
            this.m_reject = true;
        }

        public final synchronized Object get(long l) throws InterruptedException {
            long l2 = System.currentTimeMillis() + l;
            if (this.m_closed) {
                return null;
            }
            try {
                if (this.m_queue.size() <= 0) {
                    ++this.m_waiting;
                    while (this.m_queue.size() <= 0) {
                        this.wait(l);
                        if (l > 0L && System.currentTimeMillis() > l2) {
                            --this.m_waiting;
                            throw new InterruptedException("LockingQueue : timeout to dequeue");
                        }
                        if (!this.m_closed) continue;
                        --this.m_waiting;
                        return null;
                    }
                    --this.m_waiting;
                }
                Object e = this.m_queue.removeFirst();
                if (this.m_queue.size() == 0 && this.m_reject) {
                    this.close();
                }
                return e;
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new Error("LockingQueue: internal error");
            }
        }

        public final Object getLast() {
            if (this.m_queue.size() <= 0) {
                return null;
            }
            return this.m_queue.removeFirst();
        }

        public final synchronized Object get() throws InterruptedException {
            return this.get(0L);
        }

        public final boolean isEmpty() {
            return this.m_queue.size() <= 0;
        }

        public final int size() {
            return this.m_waiting;
        }

        public synchronized void close() {
            this.m_closed = true;
            this.m_queue = null;
            this.notifyAll();
        }
    }
}

