/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans.serverside;

import org.jabber.jabberbeans.IdentifierCounter;
import org.jabber.jabberbeans.Packet;
import org.jabber.jabberbeans.XMLData;
import org.jabber.jabberbeans.serverside.LogBuilder;
import org.jabber.jabberbeans.util.JID;

public class Log
extends XMLData
implements Packet {
    protected JID fromAddress;
    protected String identifier;
    protected String type;
    protected String content;

    public Log(LogBuilder logBuilder) {
        this.fromAddress = logBuilder.getFromAddress();
        this.type = logBuilder.getType();
        if (this.type != null) {
            this.type.intern();
        }
        this.identifier = logBuilder.getIdentifier();
        this.content = logBuilder.getContent();
        if (this.identifier == null) {
            this.identifier = IdentifierCounter.getNewIdentifier();
        } else if (this.identifier.equals("none")) {
            this.identifier = null;
        }
        if (this.identifier != null) {
            this.identifier.intern();
        }
    }

    public JID getFromAddress() {
        return this.fromAddress;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getType() {
        return this.type;
    }

    public void appendItem(StringBuffer stringBuffer) {
        stringBuffer.append("<log");
        XMLData.appendAttrib(stringBuffer, "from", this.fromAddress);
        XMLData.appendAttrib(stringBuffer, "id", this.identifier);
        XMLData.appendAttrib(stringBuffer, "type", this.type);
        stringBuffer.append(">");
        stringBuffer.append(this.content);
        stringBuffer.append("</log>");
    }
}

