/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans.util;

import java.io.Serializable;
import org.jabber.jabberbeans.ConnectionBean;
import org.jabber.jabberbeans.ContentPacket;
import org.jabber.jabberbeans.Packet;
import org.jabber.jabberbeans.PacketEvent;
import org.jabber.jabberbeans.PacketListener;

public class SyncPacketListener
implements PacketListener,
Serializable {
    private ConnectionBean connectionbean;
    private Packet waitPacket;
    private Class waitClass;
    private int waitType;
    private static final char WAITUNKNOWN = '\u0000';
    private static final char WAITFORID = '\u0001';
    private static final char WAITFORPACKETTYPE = '\u0002';
    private boolean waitSuccessful;

    public SyncPacketListener(ConnectionBean connectionBean) {
        this.connectionbean = connectionBean;
        this.reset();
    }

    public void reset() {
        this.waitType = 0;
        this.waitPacket = null;
        this.waitClass = null;
        this.waitSuccessful = false;
        this.connectionbean.addPacketListener(this);
    }

    public Packet sendAndWait(ContentPacket contentPacket) throws InterruptedException {
        return this.sendAndWait(contentPacket, 0);
    }

    public synchronized Packet sendAndWait(ContentPacket contentPacket, int n) throws InterruptedException {
        if (!(contentPacket instanceof ContentPacket) || contentPacket.getIdentifier() == null) {
            throw new RuntimeException("Error: cannot block on non-ID packets");
        }
        this.connectionbean.send(contentPacket);
        this.waitPacket = contentPacket;
        this.waitType = 1;
        this.wait(n);
        return this.waitSuccessful ? this.waitPacket : null;
    }

    public Packet waitForType(Packet packet) throws InterruptedException {
        return this.waitForType(packet, 0);
    }

    public Packet waitForType(Class clazz) throws InterruptedException {
        return this.waitForType(clazz, 0);
    }

    public synchronized Packet waitForType(Packet packet, int n) throws InterruptedException {
        this.waitPacket = packet;
        this.waitType = 2;
        this.wait(n);
        return this.waitSuccessful ? this.waitPacket : null;
    }

    public synchronized Packet waitForType(Class clazz, int n) throws InterruptedException {
        this.waitClass = clazz;
        this.waitType = 2;
        this.wait(n);
        return this.waitSuccessful ? this.waitPacket : null;
    }

    public void sentPacket(PacketEvent packetEvent) {
    }

    public synchronized void receivedPacket(PacketEvent packetEvent) {
        if (packetEvent.getSource() != this.connectionbean) {
            return;
        }
        if (this.waitType == 0) {
            return;
        }
        if (this.waitType == 1) {
            if (!(packetEvent.getPacket() instanceof ContentPacket)) {
                return;
            }
            ContentPacket contentPacket = (ContentPacket)packetEvent.getPacket();
            if (contentPacket.getIdentifier() == null) {
                return;
            }
            if (contentPacket.getIdentifier().equals(((ContentPacket)this.waitPacket).getIdentifier())) {
                this.waitPacket = packetEvent.getPacket();
                this.waitSuccessful = true;
                this.waitType = 0;
                this.connectionbean.delPacketListener(this);
                this.notify();
            }
            return;
        }
        if (this.waitType == 2) {
            if (this.waitPacket != null) {
                this.waitClass = this.waitPacket.getClass();
            }
            if (this.waitClass.equals(packetEvent.getPacket().getClass())) {
                this.waitPacket = packetEvent.getPacket();
                this.waitSuccessful = true;
                this.waitType = 0;
                this.connectionbean.delPacketListener(this);
                this.notify();
            }
            return;
        }
    }

    public synchronized void sendFailed(PacketEvent packetEvent) {
        this.waitPacket = null;
        this.waitSuccessful = false;
        this.waitType = 0;
        this.connectionbean.delPacketListener(this);
        this.notify();
    }
}

